/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.binding.wrapper;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.openl.rules.lang.xls.binding.wrapper.IOpenMethodWrapper;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

class TopClassOpenMethodWrapperCache {
    private IOpenMethodWrapper methodWrapper;
    Map<IOpenClass, WeakReference<IOpenMethod>> cache = new WeakHashMap<IOpenClass, WeakReference<IOpenMethod>>();

    public TopClassOpenMethodWrapperCache(IOpenMethodWrapper methodWrapper) {
        this.methodWrapper = methodWrapper;
    }

    void put(IOpenClass openClass, IOpenMethod openMethod) {
        this.cache.put(openClass, new WeakReference<IOpenMethod>(openMethod));
    }

    IOpenMethod get(IOpenClass openClass) {
        WeakReference<IOpenMethod> w = this.cache.get(openClass);
        if (w != null) {
            return (IOpenMethod)w.get();
        }
        return null;
    }

    public IOpenMethod getTopOpenClassMethod(IOpenClass topOpenClass) {
        IOpenMethod openMethod = this.get(topOpenClass);
        if (openMethod == null) {
            openMethod = topOpenClass.getMethod(this.methodWrapper.getDelegate().getName(), this.methodWrapper.getDelegate().getSignature().getParameterTypes());
            this.put(topOpenClass, openMethod);
        }
        return openMethod;
    }
}

