/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.engine.OpenLCellExpressionsCompiler;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaInfo;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableBoundNode;
import org.openl.rules.dt.DecisionTableHelper;
import org.openl.rules.dt.IBaseAction;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.IBaseDecisionRow;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.AMethodMetaInfoReader;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGrid;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.Tokenizer;
import org.openl.types.IOpenClass;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTableMetaInfoReader
extends AMethodMetaInfoReader<DecisionTableBoundNode> {
    private final Logger log = LoggerFactory.getLogger(DecisionTableMetaInfoReader.class);
    private final DecisionTable decisionTable;
    private final Map<CellKey, HeaderMetaInfo> simpleRulesConditionMap = new HashMap<CellKey, HeaderMetaInfo>();
    private final Map<CellKey, HeaderMetaInfo> simpleRulesActionMap = new HashMap<CellKey, HeaderMetaInfo>();
    private final Map<CellKey, ReturnMetaInfo> simpleRulesReturnDescriptions = new HashMap<CellKey, ReturnMetaInfo>();
    private CellMetaInfo[][] preparedMetaInfos;
    private int top;
    private int left;
    private List<Pair<String, String>> inputParametersToReturn = new ArrayList<Pair<String, String>>();

    public DecisionTableMetaInfoReader(DecisionTableBoundNode boundNode) {
        this(boundNode, null);
    }

    public DecisionTableMetaInfoReader(DecisionTableBoundNode boundNode, DecisionTable decisionTable) {
        super(boundNode);
        this.decisionTable = decisionTable;
    }

    @Override
    protected String getAdditionalMetaInfoForTableReturnType() {
        if (this.inputParametersToReturn.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.inputParametersToReturn, (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey()));
        for (Pair<String, String> p : this.inputParametersToReturn) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Input ");
            sb.append((String)p.getKey());
            sb.append(" is set to return ");
            sb.append((String)p.getValue());
        }
        return sb.toString();
    }

    @Override
    public void prepare(IGridRegion region) {
        try {
            FunctionalRow funcRow;
            this.top = region.getTop();
            this.left = region.getLeft();
            this.preparedMetaInfos = new CellMetaInfo[region.getBottom() - this.top + 1][region.getRight() - this.left + 1];
            DecisionTable decisionTable = this.getDecisionTable();
            this.saveSimpleRulesMetaInfo(region);
            this.saveCompoundReturnColumn(region);
            IBaseCondition[] conditionRows = decisionTable.getConditionRows();
            IBaseAction[] actionRows = decisionTable.getActionRows();
            if (!DecisionTableHelper.isSmart(decisionTable.getSyntaxNode()) && !DecisionTableHelper.isSimple(decisionTable.getSyntaxNode())) {
                if (conditionRows != null) {
                    for (IBaseDecisionRow iBaseDecisionRow : conditionRows) {
                        this.saveDescriptionMetaInfo((FunctionalRow)iBaseDecisionRow, region);
                    }
                }
                if (actionRows != null) {
                    for (IBaseDecisionRow iBaseDecisionRow : actionRows) {
                        this.saveDescriptionMetaInfo((FunctionalRow)iBaseDecisionRow, region);
                    }
                }
            }
            if (conditionRows != null) {
                for (IBaseDecisionRow iBaseDecisionRow : conditionRows) {
                    funcRow = (FunctionalRow)iBaseDecisionRow;
                    this.saveValueMetaInfo(funcRow, region);
                }
            }
            if (actionRows != null) {
                for (IBaseDecisionRow iBaseDecisionRow : actionRows) {
                    funcRow = (FunctionalRow)iBaseDecisionRow;
                    this.saveValueMetaInfo(funcRow, region);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void release() {
        this.preparedMetaInfos = null;
    }

    @Override
    public CellMetaInfo getBodyMetaInfo(int row, int col) {
        return this.getPreparedMetaInfo(row, col);
    }

    private void setMetaInfo(CellKey key, HeaderMetaInfo headerMetaInfo, IGridRegion region, Function<HeaderMetaInfo, String> headerToString) {
        int row = key.getRow();
        int col = key.getColumn();
        if (!IGridRegion.Tool.contains(region, col, row)) {
            return;
        }
        IGrid grid = this.getTableSyntaxNode().getGridTable().getGrid();
        String cellValue = grid.getCell(col, row).getStringValue();
        if (StringUtils.isBlank((CharSequence)cellValue)) {
            return;
        }
        String text = headerToString.apply(headerMetaInfo);
        SimpleNodeUsage simpleNodeUsage = new SimpleNodeUsage(0, cellValue.length() - 1, text, headerMetaInfo.getUrl(), headerMetaInfo.getUrl() != null ? NodeType.OTHERUNDERLINED : NodeType.OTHER);
        this.setPreparedMetaInfo(row, col, new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(simpleNodeUsage)));
    }

    private String buildStringForCondition(HeaderMetaInfo headerMetaInfo) {
        String[] parameterNames = headerMetaInfo.getParameterNames();
        String header = headerMetaInfo.getHeader();
        String statement = headerMetaInfo.getConditionStatement();
        IOpenClass[] columnTypes = headerMetaInfo.getColumnTypes();
        StringBuilder sb = new StringBuilder();
        sb.append("Condition: ").append(header);
        if (!StringUtils.isEmpty((CharSequence)statement)) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Expression: ").append(statement.replaceAll("\n", " "));
        }
        if (!StringUtils.isEmpty((CharSequence)headerMetaInfo.getAdditionalDetails())) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(headerMetaInfo.getAdditionalDetails());
        }
        DecisionTableMetaInfoReader.appendParameters(sb, parameterNames, columnTypes);
        return sb.toString();
    }

    public static void appendParameters(StringBuilder sb, String[] parameterNames, IOpenClass[] columnTypes) {
        if (columnTypes == null || columnTypes.length == 0) {
            return;
        }
        int i = 0;
        if (sb.length() > 0) {
            sb.append("\n");
        }
        if (columnTypes.length > 1) {
            if (parameterNames != null && parameterNames.length > 0 && Arrays.stream(parameterNames).allMatch(Objects::nonNull)) {
                sb.append("Parameters: ");
            } else {
                sb.append("Types: ");
            }
        } else if (parameterNames != null && parameterNames.length > 0) {
            sb.append("Parameter: ");
        } else {
            sb.append("Type: ");
        }
        for (IOpenClass type : columnTypes) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(type.getDisplayName(0));
            if (parameterNames != null && parameterNames[i] != null) {
                sb.append(" ").append(parameterNames[i]);
            }
            ++i;
        }
    }

    private String buildStringForAction(HeaderMetaInfo headerMetaInfo) {
        String[] parameterNames = headerMetaInfo.getParameterNames();
        String header = headerMetaInfo.getHeader();
        String statement = headerMetaInfo.getConditionStatement();
        IOpenClass[] columnTypes = headerMetaInfo.getColumnTypes();
        StringBuilder sb = new StringBuilder();
        sb.append("Action: ").append(header);
        if (!StringUtils.isEmpty((CharSequence)statement)) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Expression: ").append(statement.replaceAll("\n", " "));
        }
        if (!StringUtils.isEmpty((CharSequence)headerMetaInfo.getAdditionalDetails())) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(headerMetaInfo.getAdditionalDetails());
        }
        DecisionTableMetaInfoReader.appendParameters(sb, parameterNames, columnTypes);
        return sb.toString();
    }

    private void saveSimpleRulesMetaInfo(IGridRegion region) {
        for (Map.Entry<CellKey, HeaderMetaInfo> entry : this.simpleRulesConditionMap.entrySet()) {
            this.setMetaInfo(entry.getKey(), entry.getValue(), region, this::buildStringForCondition);
        }
        for (Map.Entry<CellKey, HeaderMetaInfo> entry : this.simpleRulesActionMap.entrySet()) {
            this.setMetaInfo(entry.getKey(), entry.getValue(), region, this::buildStringForAction);
        }
    }

    private void saveCompoundReturnColumn(IGridRegion region) {
        for (Map.Entry<CellKey, ReturnMetaInfo> entry : this.simpleRulesReturnDescriptions.entrySet()) {
            ICell cell;
            String stringValue;
            CellKey key = entry.getKey();
            int row = key.getRow();
            int col = key.getColumn();
            if (!IGridRegion.Tool.contains(region, col, row) || StringUtils.isBlank((CharSequence)(stringValue = (cell = this.getTableSyntaxNode().getGridTable().getGrid().getCell(col, row)).getStringValue()))) continue;
            ReturnMetaInfo returnMetaInfo = entry.getValue();
            SimpleNodeUsage simpleNodeUsage = new SimpleNodeUsage(0, stringValue.length() - 1, returnMetaInfo.getDetails(), returnMetaInfo.getUri(), returnMetaInfo.getUri() != null ? NodeType.OTHERUNDERLINED : NodeType.OTHER);
            CellMetaInfo metaInfo = new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(simpleNodeUsage));
            this.setPreparedMetaInfo(row, col, metaInfo);
        }
    }

    public void addSimpleRulesCondition(int row, int col, String header, String[] parameterNames, String statement, IOpenClass[] columnTypes, String url, String additionalDetails) {
        this.simpleRulesConditionMap.put(CellKey.CellKeyFactory.getCellKey(col, row), new HeaderMetaInfo(header, parameterNames, statement, columnTypes, url, additionalDetails));
    }

    public void addSimpleRulesAction(int row, int col, String header, String[] parameterNames, String statement, IOpenClass[] columnTypes, String url, String additionalInfo) {
        this.simpleRulesActionMap.put(CellKey.CellKeyFactory.getCellKey(col, row), new HeaderMetaInfo(header, parameterNames, statement, columnTypes, url, additionalInfo));
    }

    public void addSimpleRulesReturn(int row, int col, String details, String uri) {
        this.simpleRulesReturnDescriptions.put(CellKey.CellKeyFactory.getCellKey(col, row), new ReturnMetaInfo(details, uri));
    }

    private void saveValueMetaInfo(FunctionalRow funcRow, IGridRegion region) {
        for (int c = 0; c < funcRow.nValues(); ++c) {
            IParameterDeclaration[] params = funcRow.getParams();
            int paramsCount = params == null ? 0 : params.length;
            ILogicalTable valueCell = funcRow.getValueCell(c);
            for (int i = 0; i < paramsCount; ++i) {
                ICell cell = valueCell.getCell(0, i);
                int row = cell.getAbsoluteRow();
                int col = cell.getAbsoluteColumn();
                if (!IGridRegion.Tool.contains(region, col, row)) continue;
                Object storageValue = funcRow.getStorageValue(i, c);
                if (storageValue instanceof CompositeMethod) {
                    String stringValue = cell.getStringValue();
                    int startIndex = stringValue.indexOf(61) + 1;
                    List<NodeUsage> nodeUsages = OpenLCellExpressionsCompiler.getNodeUsages((CompositeMethod)storageValue, stringValue.substring(startIndex), startIndex);
                    this.setPreparedMetaInfo(row, col, new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, nodeUsages));
                    continue;
                }
                IParameterDeclaration param = params[i];
                if (param == null) continue;
                IOpenClass type = param.getType();
                boolean multiValue = false;
                if (type.isArray()) {
                    multiValue = true;
                    type = type.getAggregateInfo().getComponentType(type);
                }
                this.setPreparedMetaInfo(row, col, type, multiValue);
            }
        }
    }

    private void saveDescriptionMetaInfo(FunctionalRow funcRow, IGridRegion region) {
        ICell codeCell = funcRow.getCodeTable().getCell(0, 0);
        int row = codeCell.getAbsoluteRow();
        int col = codeCell.getAbsoluteColumn();
        if (IGridRegion.Tool.contains(region, col, row)) {
            List<CellMetaInfo> metaInfoList = OpenLCellExpressionsCompiler.getMetaInfo(funcRow.getSourceCodeModule(), funcRow.getMethod());
            this.setPreparedMetaInfo(row, col, metaInfoList.get(0));
        }
        ILogicalTable paramsTable = funcRow.getParamsTable();
        IParameterDeclaration[] params = funcRow.getParams();
        if (params != null && params.length > 0 && params[0] != null) {
            IParameterDeclaration param = params[0];
            ICell paramCell = paramsTable.getCell(0, 0);
            row = paramCell.getAbsoluteRow();
            col = paramCell.getAbsoluteColumn();
            if (IGridRegion.Tool.contains(region, col, row)) {
                this.setPreparedMetaInfo(row, col, this.getMetaInfo(paramsTable, param.getType()));
            }
        }
    }

    protected CellMetaInfo getMetaInfo(ILogicalTable paramsTable, IOpenClass type) {
        IOpenClass typeForLink = type;
        while (typeForLink.getMetaInfo() == null && typeForLink.isArray()) {
            typeForLink = typeForLink.getComponentClass();
        }
        ILogicalTable table = (ILogicalTable)paramsTable.getRow(0);
        if (table != null) {
            IMetaInfo metaInfo;
            IdentifierNode[] paramNodes;
            GridCellSourceCodeModule source = new GridCellSourceCodeModule(table.getSource());
            try {
                paramNodes = Tokenizer.tokenize((IOpenSourceCodeModule)source, (String)"[] \n\r");
            }
            catch (OpenLCompilationException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                return null;
            }
            if (paramNodes.length > 0 && (metaInfo = typeForLink.getMetaInfo()) != null) {
                SimpleNodeUsage nodeUsage = new SimpleNodeUsage(paramNodes[0], metaInfo.getDisplayName(0), metaInfo.getSourceUrl(), NodeType.DATATYPE);
                return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage));
            }
        }
        return null;
    }

    private DecisionTable getDecisionTable() {
        if (this.decisionTable != null) {
            return this.decisionTable;
        }
        return ((DecisionTableBoundNode)((Object)this.getBoundNode())).getDecisionTable();
    }

    private CellMetaInfo getPreparedMetaInfo(int row, int col) {
        if (this.preparedMetaInfos == null) {
            this.prepare(this.getTableSyntaxNode().getGridTable().getRegion());
        }
        int r = row - this.top;
        int c = col - this.left;
        if (r < 0 || r >= this.preparedMetaInfos.length || c < 0 || c >= this.preparedMetaInfos[0].length) {
            return null;
        }
        return this.preparedMetaInfos[r][c];
    }

    private void setPreparedMetaInfo(int row, int col, CellMetaInfo metaInfo) {
        this.preparedMetaInfos[row - this.top][col - this.left] = metaInfo;
    }

    private void setPreparedMetaInfo(int row, int col, IOpenClass type, boolean multiValue) {
        CellMetaInfo metaInfo = new CellMetaInfo(type, multiValue);
        CellMetaInfo previous = this.preparedMetaInfos[row - this.top][col - this.left];
        if (previous != null && previous.getUsedNodes() != null) {
            metaInfo.setUsedNodes(previous.getUsedNodes());
        }
        this.setPreparedMetaInfo(row, col, metaInfo);
    }

    public void addInputParametersToReturn(String statementInInputParameters, String statementInReturn) {
        this.inputParametersToReturn.add((Pair<String, String>)Pair.of((Object)statementInInputParameters, (Object)statementInReturn));
    }

    private static class HeaderMetaInfo {
        String header;
        String[] parameterNames;
        String statement;
        IOpenClass[] columnTypes;
        String additionalDetails;
        String url;

        public HeaderMetaInfo(String headerName, String[] parameterNames, String conditionStatement, IOpenClass[] columnTypes, String url, String additionalDetails) {
            if (parameterNames != null && columnTypes != null && parameterNames.length != columnTypes.length) {
                throw new IllegalArgumentException();
            }
            this.header = headerName;
            this.parameterNames = parameterNames;
            this.statement = conditionStatement;
            this.columnTypes = columnTypes;
            this.additionalDetails = additionalDetails;
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public String getAdditionalDetails() {
            return this.additionalDetails;
        }

        public String getHeader() {
            return this.header;
        }

        public String[] getParameterNames() {
            return this.parameterNames;
        }

        public String getConditionStatement() {
            return this.statement;
        }

        public IOpenClass[] getColumnTypes() {
            return this.columnTypes;
        }
    }

    private static class ReturnMetaInfo {
        String details;
        String uri;

        public ReturnMetaInfo(String details, String uri) {
            this.details = details;
            this.uri = uri;
        }

        public String getDetails() {
            return this.details;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

