/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.runtime;

import org.openl.binding.impl.cast.OutsideOfValidDomainException;
import org.openl.domain.IDomain;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.impl.ComponentTypeArrayOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.util.DomainUtils;
import org.openl.vm.IRuntimeEnv;

class ValidationHandler {
    ValidationHandler() {
    }

    void validateProxyArguments(IMethodSignature methodSignature, IRuntimeEnv env, Object[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg == null) continue;
            IOpenClass generatedType = methodSignature.getParameterType(i);
            if (generatedType instanceof DomainOpenClass) {
                this.validateAliasValue(arg, generatedType);
                continue;
            }
            if (generatedType instanceof ComponentTypeArrayOpenClass) {
                this.doValidate(env, (Object[])arg, generatedType.getComponentClass());
                continue;
            }
            if (!(generatedType instanceof DatatypeOpenClass)) continue;
            this.doValidate(env, arg, generatedType);
        }
    }

    private void doValidate(IRuntimeEnv env, Object[] objs, IOpenClass openType) {
        for (Object obj : objs) {
            if (obj == null) continue;
            if (openType instanceof ComponentTypeArrayOpenClass) {
                this.doValidate(env, (Object[])obj, openType.getComponentClass());
                continue;
            }
            if (!(openType instanceof DatatypeOpenClass)) continue;
            this.doValidate(env, obj, openType);
        }
    }

    private void doValidate(IRuntimeEnv env, Object obj, IOpenClass openType) {
        if (!obj.getClass().equals(openType.getInstanceClass())) {
            return;
        }
        for (IOpenField openField : openType.getFields().values()) {
            Object value;
            IOpenClass openClass = openField.getType();
            if (openClass instanceof ComponentTypeArrayOpenClass) {
                value = openField.get(obj, env);
                if (value == null) continue;
                this.doValidate(env, (Object[])value, openClass.getComponentClass());
                continue;
            }
            if (openClass instanceof DatatypeOpenClass) {
                value = openField.get(obj, env);
                if (value == null) continue;
                this.doValidate(env, value, openClass);
                continue;
            }
            if (!(openClass instanceof DomainOpenClass) || (value = openField.get(obj, env)) == null) continue;
            this.validateAliasValue(value, openClass);
        }
    }

    private void validateAliasValue(Object value, IOpenClass openClass) {
        if (openClass.isArray()) {
            Object[] values;
            for (Object o : values = (Object[])value) {
                this.testLookupValue(o, openClass);
            }
        } else {
            this.testLookupValue(value, openClass);
        }
    }

    private void testLookupValue(Object o, IOpenClass openClass) {
        IDomain domain = openClass.getDomain();
        boolean isInDomain = domain.selectObject(o);
        if (!isInDomain) {
            throw new OutsideOfValidDomainException(String.format("Object '%s' is outside of valid domain '%s'. Valid values: %s", o, openClass.getName(), DomainUtils.toString((IDomain)domain)));
        }
    }
}

