/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.Date;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;

class GridTableCell
implements ICell {
    private int column;
    private int row;
    private IGridTable table;
    private ICell cell;

    @Override
    public ICell getTopLeftCellFromRegion() {
        return this.cell.getTopLeftCellFromRegion();
    }

    public GridTableCell(int column, int row, IGridTable table) {
        this.column = column;
        this.row = row;
        this.table = table;
        int gridColumn = table.getGridColumn(column, row);
        int gridRow = table.getGridRow(column, row);
        this.cell = table.getGrid().getCell(gridColumn, gridRow);
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getAbsoluteColumn() {
        return this.cell.getAbsoluteColumn();
    }

    @Override
    public int getAbsoluteRow() {
        return this.cell.getAbsoluteRow();
    }

    @Override
    public IGridRegion getAbsoluteRegion() {
        return this.cell.getAbsoluteRegion();
    }

    @Override
    public IGridRegion getRegion() {
        return this.cell.getRegion();
    }

    @Override
    public ICellStyle getStyle() {
        return this.cell.getStyle();
    }

    @Override
    public ICellFont getFont() {
        return this.cell.getFont();
    }

    @Override
    public int getHeight() {
        return this.table.isNormalOrientation() ? this.cell.getHeight() : this.cell.getWidth();
    }

    @Override
    public Object getObjectValue() {
        return this.cell.getObjectValue();
    }

    @Override
    public String getStringValue() {
        return this.cell.getStringValue();
    }

    @Override
    public int getWidth() {
        return this.table.isNormalOrientation() ? this.cell.getWidth() : this.cell.getHeight();
    }

    @Override
    public String getFormula() {
        return this.cell.getFormula();
    }

    @Override
    public int getType() {
        return this.cell.getType();
    }

    @Override
    public String getUri() {
        return this.cell.getUri();
    }

    @Override
    public boolean getNativeBoolean() {
        return this.cell.getNativeBoolean();
    }

    @Override
    public double getNativeNumber() {
        return this.cell.getNativeNumber();
    }

    @Override
    public int getNativeType() {
        return this.cell.getNativeType();
    }

    @Override
    public boolean hasNativeType() {
        return this.cell.hasNativeType();
    }

    @Override
    public Date getNativeDate() {
        return this.cell.getNativeDate();
    }

    @Override
    public ICellComment getComment() {
        return this.cell.getComment();
    }
}

