/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.ALogicalTable;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.TableException;

public class LogicalTable
extends ALogicalTable {
    private int[] rowOffset;
    private int[] columnOffset;

    public LogicalTable(IGridTable table, int width, int height) {
        super(table);
        this.rowOffset = LogicalTableHelper.calculateRowOffsets(height, table);
        this.columnOffset = LogicalTableHelper.calculateColumnOffsets(width, table);
    }

    public LogicalTable(IGridTable table, int[] columnOffset, int[] rowOffset) {
        super(table);
        if (columnOffset == null) {
            int width = LogicalTableHelper.calcLogicalColumns(table);
            this.columnOffset = LogicalTableHelper.calculateColumnOffsets(width, table);
        } else {
            this.columnOffset = columnOffset;
        }
        if (rowOffset == null) {
            int height = LogicalTableHelper.calcLogicalRows(table);
            this.rowOffset = LogicalTableHelper.calculateRowOffsets(height, table);
        } else {
            this.rowOffset = rowOffset;
        }
    }

    @Override
    public int getWidth() {
        return this.columnOffset.length - 1;
    }

    @Override
    public int getHeight() {
        return this.rowOffset.length - 1;
    }

    @Override
    public int findColumnStart(int gridOffset) {
        for (int i = 0; i < this.columnOffset.length - 1; ++i) {
            if (this.columnOffset[i] == gridOffset) {
                return i;
            }
            if (this.columnOffset[i] <= gridOffset) continue;
            throw new TableException("gridOffset does not match column start");
        }
        throw new TableException("gridOffset is higher than table's width");
    }

    @Override
    public int findRowStart(int gridOffset) {
        for (int i = 0; i < this.rowOffset.length - 1; ++i) {
            if (this.rowOffset[i] == gridOffset) {
                return i;
            }
            if (this.rowOffset[i] <= gridOffset) continue;
            throw new TableException("gridOffset does not match row start");
        }
        throw new TableException("gridOffset is higher than table's height");
    }

    @Override
    public int getColumnWidth(int column) {
        return this.columnOffset[column + 1] - this.columnOffset[column];
    }

    @Override
    public int getRowHeight(int row) {
        return this.rowOffset[row + 1] - this.rowOffset[row];
    }

    @Override
    public ILogicalTable getSubtable(int column, int row, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        int startRow = this.rowOffset[row];
        int endRow = this.rowOffset[row + height];
        int startColumn = this.columnOffset[column];
        int endColumn = this.columnOffset[column + width];
        return LogicalTableHelper.logicalTable((IGridTable)this.getSource().getSubtable(startColumn, startRow, endColumn - startColumn, endRow - startRow));
    }

    public int[] getRowOffset() {
        return this.rowOffset;
    }

    public int[] getColumnOffset() {
        return this.columnOffset;
    }

    @Override
    public ICell getCell(int column, int row) {
        int r = this.rowOffset[row];
        int c = this.columnOffset[column];
        return this.getSource().getCell(c, r);
    }
}

