/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openl.rules.table.IGridRegion;

public class RegionsPool {
    private Map<Integer, Map<DisjointInterval, IGridRegion>> pool = new HashMap<Integer, Map<DisjointInterval, IGridRegion>>();

    public RegionsPool(List<IGridRegion> regions) {
        if (regions != null) {
            for (IGridRegion region : regions) {
                this.add(region);
            }
        }
    }

    public RegionsPool() {
    }

    public void add(IGridRegion region) {
        for (int row = region.getTop(); row <= region.getBottom(); ++row) {
            Map<DisjointInterval, IGridRegion> regionsMap = this.pool.get(row);
            if (regionsMap == null) {
                regionsMap = new TreeMap<DisjointInterval, IGridRegion>();
                this.pool.put(row, regionsMap);
            }
            regionsMap.put(new DisjointInterval(region.getLeft(), region.getRight()), region);
        }
    }

    public void remove(IGridRegion region) {
        if (region != null) {
            for (int row = region.getTop(); row <= region.getBottom(); ++row) {
                Map<DisjointInterval, IGridRegion> regionsMap = this.pool.get(row);
                regionsMap.remove(new DisjointInterval(region.getLeft(), region.getRight()));
                if (!regionsMap.isEmpty()) continue;
                this.pool.remove(row);
            }
        }
    }

    public void remove(int column, int row) {
        IGridRegion region = this.getRegionContaining(column, row);
        this.remove(region);
    }

    public IGridRegion getRegionContaining(int column, int row) {
        Map<DisjointInterval, IGridRegion> regionsMap = this.pool.get(row);
        if (regionsMap != null) {
            return regionsMap.get(new DisjointInterval(column, column));
        }
        return null;
    }

    private static class DisjointInterval
    implements Comparable<DisjointInterval> {
        private int left;
        private int right;

        public DisjointInterval(int left, int right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int compareTo(DisjointInterval o) {
            if (this.right < o.left) {
                return -1;
            }
            if (this.left > o.right) {
                return 1;
            }
            return 0;
        }
    }
}

