/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.table.properties.def.TablePropertyDefinitionUtils;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.MethodKey;

public final class DimensionPropertiesMethodKey {
    private final IOpenMethod method;
    private int hashCode = 0;

    public DimensionPropertiesMethodKey(IOpenMethod method) {
        this.method = method;
    }

    public IOpenMethod getMethod() {
        return this.method;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DimensionPropertiesMethodKey)) {
            return false;
        }
        DimensionPropertiesMethodKey key = (DimensionPropertiesMethodKey)obj;
        if (!new MethodKey(this.method).equals((Object)new MethodKey(key.getMethod()))) {
            return false;
        }
        Map<String, Object> thisMethodProperties = PropertiesHelper.getTableProperties(this.method).getAllDimensionalProperties();
        Map<String, Object> otherMethodProperties = PropertiesHelper.getTableProperties(key.getMethod()).getAllDimensionalProperties();
        if (thisMethodProperties.size() != otherMethodProperties.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : thisMethodProperties.entrySet()) {
            Object propertyValue1 = entry.getValue();
            Object propertyValue2 = otherMethodProperties.get(entry.getKey());
            if (this.isEmpty(propertyValue1) && this.isEmpty(propertyValue2) || Objects.deepEquals(propertyValue1, propertyValue2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            String[] dimensionalPropertyNames = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames();
            Map<String, Object> methodProperties = PropertiesHelper.getMethodProperties(this.method);
            int hash = new MethodKey(this.method).hashCode();
            if (methodProperties != null) {
                for (String dimensionalPropertyName : dimensionalPropertyNames) {
                    Object property = methodProperties.get(dimensionalPropertyName);
                    hash = 31 * hash + (property instanceof Object[] ? Arrays.deepHashCode((Object[])property) : Objects.hashCode(property));
                }
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new MethodKey(this.method));
        String[] dimensionalPropertyNames = TablePropertyDefinitionUtils.getDimensionalTablePropertiesNames();
        stringBuilder.append('[');
        if (PropertiesHelper.getMethodProperties(this.method) != null) {
            for (int i = 0; i < dimensionalPropertyNames.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(dimensionalPropertyNames[i]).append('=');
                stringBuilder.append(PropertiesHelper.getTableProperties(this.method).getPropertyValueAsString(dimensionalPropertyNames[i]));
            }
        }
        return stringBuilder.append(']').toString();
    }

    private boolean isEmpty(Object propertyValue) {
        if (propertyValue == null) {
            return true;
        }
        if (propertyValue.getClass().isArray()) {
            int length = Array.getLength(propertyValue);
            if (length == 0) {
                return true;
            }
            for (int i = 0; i < length; ++i) {
                if (Array.get(propertyValue, i) == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

