/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.def;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.table.properties.def.DefaultPropertyDefinitions;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;

public final class TablePropertyDefinitionUtils {
    private static final List<TablePropertyDefinition> PROPERTIES_TO_BE_SET_BY_DEFAULT;
    private static final Map<String, Object> PROPERTIES_MAP_TO_BE_SET_BY_DEFAULT;
    private static String[] dimensionalTablePropertiesNames;
    private static List<TablePropertyDefinition> dimensionalTableProperties;

    private TablePropertyDefinitionUtils() {
    }

    public static String[] getDimensionalTablePropertiesNames() {
        if (dimensionalTablePropertiesNames == null) {
            ArrayList<String> names = new ArrayList<String>();
            List<TablePropertyDefinition> dimensionalProperties = TablePropertyDefinitionUtils.getDimensionalTableProperties();
            for (TablePropertyDefinition definition : dimensionalProperties) {
                names.add(definition.getName());
            }
            dimensionalTablePropertiesNames = names.toArray(new String[names.size()]);
        }
        return dimensionalTablePropertiesNames;
    }

    public static List<TablePropertyDefinition> getDimensionalTableProperties() {
        if (dimensionalTableProperties == null) {
            TablePropertyDefinition[] definitions;
            ArrayList<TablePropertyDefinition> dimensionalProperties = new ArrayList<TablePropertyDefinition>();
            for (TablePropertyDefinition definition : definitions = DefaultPropertyDefinitions.getDefaultDefinitions()) {
                if (!definition.isDimensional()) continue;
                dimensionalProperties.add(definition);
            }
            dimensionalTableProperties = Collections.unmodifiableList(dimensionalProperties);
        }
        return dimensionalTableProperties;
    }

    public static String getPropertyName(String displayName) {
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.getDisplayName().equals(displayName)) continue;
            return propDefinition.getName();
        }
        return null;
    }

    public static String getPropertyDisplayName(String name) {
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.getName().equals(name)) continue;
            return propDefinition.getDisplayName();
        }
        return null;
    }

    public static TablePropertyDefinition getPropertyByName(String name) {
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.getName().equals(name)) continue;
            return propDefinition;
        }
        return null;
    }

    public static Class<?> getTypeByPropertyName(String propertyName) {
        TablePropertyDefinition tablePropertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyName);
        if (tablePropertyDefinition != null) {
            return tablePropertyDefinition.getType().getInstanceClass();
        }
        return null;
    }

    public static boolean isPropertyExist(String propertyName) {
        return TablePropertyDefinitionUtils.getPropertyByName(propertyName) != null;
    }

    public static List<TablePropertyDefinition> getPropertiesToBeSetByDefault() {
        return PROPERTIES_TO_BE_SET_BY_DEFAULT;
    }

    public static Map<String, Object> getPropertiesMapToBeSetByDefault() {
        return PROPERTIES_MAP_TO_BE_SET_BY_DEFAULT;
    }

    public static List<TablePropertyDefinition> getSystemProperties() {
        ArrayList<TablePropertyDefinition> result = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.isSystem()) continue;
            result.add(propDefinition);
        }
        return result;
    }

    public static TablePropertyDefinition[] getDefaultDefinitionsByInheritanceLevel(InheritanceLevel inheritanceLevel) {
        ArrayList<TablePropertyDefinition> resultDefinitions = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propertyDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!ArrayUtils.contains((Object[])propertyDefinition.getInheritanceLevel(), (Object)((Object)inheritanceLevel))) continue;
            resultDefinitions.add(propertyDefinition);
        }
        return resultDefinitions.toArray(new TablePropertyDefinition[0]);
    }

    public static TablePropertyDefinition[] getDefaultDefinitionsForTable(String tableType) {
        return TablePropertyDefinitionUtils.getDefaultDefinitionsForTable(tableType, null, false);
    }

    public static TablePropertyDefinition[] getDefaultDefinitionsForTable(String tableType, InheritanceLevel inheritanceLevel, boolean ignoreSystem) {
        ArrayList<TablePropertyDefinition> resultDefinitions = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propertyDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            String name = propertyDefinition.getName();
            if (!PropertiesChecker.isPropertySuitableForTableType(name, tableType) || inheritanceLevel != null && !ArrayUtils.contains((Object[])propertyDefinition.getInheritanceLevel(), (Object)((Object)inheritanceLevel)) || ignoreSystem && propertyDefinition.isSystem()) continue;
            resultDefinitions.add(propertyDefinition);
        }
        return resultDefinitions.toArray(new TablePropertyDefinition[resultDefinitions.size()]);
    }

    public static Map<String, List<TablePropertyDefinition>> groupProperties(TablePropertyDefinition[] properties) {
        LinkedHashMap<String, List<TablePropertyDefinition>> groups = new LinkedHashMap<String, List<TablePropertyDefinition>>();
        for (TablePropertyDefinition property : properties) {
            String groupName = property.getGroup();
            List group = groups.computeIfAbsent(groupName, e -> new ArrayList());
            group.add(property);
        }
        return groups;
    }

    public static XlsNodeTypes[] getSuitableTableTypes(String propertyName) {
        TablePropertyDefinition propDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyName);
        if (propDefinition != null) {
            return propDefinition.getTableType();
        }
        return null;
    }

    public static Class<?> getPropertyTypeByPropertyName(String name) {
        TablePropertyDefinition propDefinition = TablePropertyDefinitionUtils.getPropertyByName(name);
        if (propDefinition != null) {
            return propDefinition.getType().getInstanceClass();
        }
        return null;
    }

    static {
        ArrayList<TablePropertyDefinition> propertiesToBeSetByDefault = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (propDefinition.getDefaultValue() == null) continue;
            propertiesToBeSetByDefault.add(propDefinition);
        }
        PROPERTIES_TO_BE_SET_BY_DEFAULT = Collections.unmodifiableList(propertiesToBeSetByDefault);
        HashMap propertiesMapToBeSetByDefault = new HashMap();
        for (TablePropertyDefinition propertyWithDefaultValue : propertiesToBeSetByDefault) {
            String defaultPropertyName = propertyWithDefaultValue.getName();
            TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(defaultPropertyName);
            Class defaultPropertyValueType = propertyDefinition.getType().getInstanceClass();
            IString2DataConvertor converter = String2DataConvertorFactory.getConvertor(defaultPropertyValueType);
            Object defaultValue = converter.parse(propertyWithDefaultValue.getDefaultValue(), propertyWithDefaultValue.getFormat());
            propertiesMapToBeSetByDefault.put(defaultPropertyName, defaultValue);
        }
        PROPERTIES_MAP_TO_BE_SET_BY_DEFAULT = Collections.unmodifiableMap(propertiesMapToBeSetByDefault);
        dimensionalTablePropertiesNames = null;
        dimensionalTableProperties = null;
    }
}

