/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import org.openl.rules.table.IGridRegion;
import org.openl.rules.tbasic.AlgorithmRow;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.source.IOpenSourceCodeModule;

public class AlgorithmOperationSource {
    private AlgorithmTreeNode sourceNode;
    private String operationFieldName;

    public AlgorithmOperationSource(AlgorithmTreeNode sourceNode, String operationFieldName) {
        this.sourceNode = sourceNode;
        this.operationFieldName = operationFieldName;
    }

    public IGridRegion getGridRegion() {
        IGridRegion sourceRegion = null;
        if (this.operationFieldName != null) {
            sourceRegion = this.sourceNode.getAlgorithmRow().getValueGridRegion(this.operationFieldName);
        }
        if (sourceRegion == null) {
            sourceRegion = this.sourceNode.getAlgorithmRow().getGridRegion();
        }
        return sourceRegion;
    }

    public String getOperationName() {
        return this.sourceNode.getAlgorithmRow().getOperation().getValue();
    }

    public int getRowNumber() {
        return this.sourceNode.getAlgorithmRow().getRowNumber();
    }

    public IOpenSourceCodeModule getSourceModule() {
        return this.sourceNode.getAlgorithmRow().getOperation().asSourceCodeModule();
    }

    public String getSourceUri() {
        return this.sourceNode.getAlgorithmRow().getOperation().asSourceCodeModule().getUri();
    }

    public AlgorithmRow getAlgorithmRow() {
        return this.sourceNode.getAlgorithmRow();
    }

    public String getOperationFieldName() {
        return this.operationFieldName;
    }
}

