/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openl.message.OpenLMessage;
import org.openl.rules.data.PrecisionFieldChain;
import org.openl.rules.testmethod.ITestResultBuilder;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.OpenLUserRuntimeException;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestStatus;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.result.ComparedResult;
import org.openl.rules.testmethod.result.TestResultComparator;
import org.openl.rules.testmethod.result.TestResultComparatorFactory;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;
import org.openl.vm.SimpleVM;

public class BaseTestUnit
implements ITestUnit {
    private final TestDescription test;
    private final Throwable actualError;
    private final TestStatus resultStatus;
    private final long executionTime;
    private final List<ComparedResult> comparisonResults = new ArrayList<ComparedResult>();

    BaseTestUnit(TestDescription test, Object res, Throwable error, long executionTime) {
        this.test = test;
        this.executionTime = executionTime;
        Object expectedResult = test.getExpectedResult();
        String expectedError = test.getExpectedError();
        this.actualError = expectedError != null && expectedResult != null ? new IllegalArgumentException("Ambiguous expectation in the test case. Two expected result has been declared.") : error;
        this.resultStatus = this.compareResult(expectedError, expectedResult, res);
    }

    Throwable getActualError() {
        return this.actualError;
    }

    @Override
    public Object getActualResult() {
        return this.actualError;
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public String getDescription() {
        String descr = this.test.getDescription();
        return descr == null ? "No Description" : descr;
    }

    @Override
    public TestStatus getResultStatus() {
        return this.resultStatus;
    }

    @Override
    public TestDescription getTest() {
        return this.test;
    }

    @Override
    public List<ComparedResult> getComparisonResults() {
        return this.comparisonResults;
    }

    private TestStatus compareResult(String expectedError, Object expectedResult, Object actualResult) {
        if (this.actualError != null) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)this.actualError);
            if (rootCause instanceof OpenLUserRuntimeException) {
                return this.compareMessageAndGetResult(expectedError, rootCause.getMessage(), expectedResult);
            }
            ComparedResult results = new ComparedResult(null, expectedError == null ? expectedResult : expectedError, rootCause == null ? actualResult : rootCause.getMessage(), TestStatus.TR_EXCEPTION);
            this.comparisonResults.add(results);
            return TestStatus.TR_EXCEPTION;
        }
        if (expectedError != null) {
            ComparedResult results = new ComparedResult(null, expectedError, actualResult, TestStatus.TR_NEQ);
            this.comparisonResults.add(results);
            return TestStatus.TR_NEQ;
        }
        return this.compareAndGetResult(expectedResult, actualResult);
    }

    private TestStatus compareMessageAndGetResult(String expectedError, String actualError, Object expectedResult) {
        boolean isEqual;
        Object expectedValue;
        if (expectedResult == null) {
            expectedValue = expectedError;
            isEqual = Objects.equals(expectedError == null ? "" : expectedError, actualError);
        } else {
            isEqual = false;
            expectedValue = expectedResult;
        }
        if (this.writeFailuresOnly() && isEqual) {
            return TestStatus.TR_OK;
        }
        TestStatus status = isEqual ? TestStatus.TR_OK : TestStatus.TR_NEQ;
        ComparedResult results = new ComparedResult(null, expectedValue, actualError, status);
        this.comparisonResults.add(results);
        return status;
    }

    private TestStatus compareAndGetResult(Object expectedResult, Object actualResult) {
        boolean success = true;
        for (IOpenField field : this.test.getFields()) {
            Object actualFieldValue = this.getFieldValueOrNull(actualResult, field);
            Object expectedFieldValue = this.getFieldValueOrNull(expectedResult, field);
            success &= this.isFieldEqual(field, expectedFieldValue, actualFieldValue);
        }
        return success ? TestStatus.TR_OK : TestStatus.TR_NEQ;
    }

    private boolean isFieldEqual(IOpenField field, Object expectedFieldValue, Object actualFieldValue) {
        Double columnDelta = null;
        if (field instanceof PrecisionFieldChain && ((PrecisionFieldChain)field).hasDelta()) {
            columnDelta = ((PrecisionFieldChain)field).getDelta();
        }
        Class clazz = field.getType().getInstanceClass();
        TestResultComparator comparator = TestResultComparatorFactory.getComparator(clazz, columnDelta);
        boolean equal = comparator.isEqual(expectedFieldValue, actualFieldValue);
        if (this.writeFailuresOnly() && equal) {
            return true;
        }
        TestStatus status = equal ? TestStatus.TR_OK : TestStatus.TR_NEQ;
        ComparedResult fieldComparisonResults = new ComparedResult(field.getName(), expectedFieldValue, actualFieldValue, status);
        this.comparisonResults.add(fieldComparisonResults);
        return equal;
    }

    protected boolean writeFailuresOnly() {
        return true;
    }

    private Object getFieldValueOrNull(Object result, IOpenField field) {
        Object fieldValue = null;
        if (result != null) {
            try {
                IRuntimeEnv env = new SimpleVM().getRuntimeEnv();
                fieldValue = field.get(result, env);
            }
            catch (Exception ex) {
                fieldValue = ex;
            }
        }
        return fieldValue;
    }

    @Override
    public Object getExpectedResult() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParameterWithValueDeclaration[] getContextParams(TestUnitsResults objTestResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ComparedResult> getResultParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<OpenLMessage> getErrors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParameterWithValueDeclaration getActualParam() {
        throw new UnsupportedOperationException();
    }

    public static class Builder
    implements ITestResultBuilder {
        private static Builder instance = new Builder();

        private Builder() {
        }

        public static Builder getInstance() {
            return instance;
        }

        @Override
        public ITestUnit build(TestDescription test, Object res, Throwable error, long executionTime) {
            return new BaseTestUnit(test, res, error, executionTime);
        }
    }
}

