/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.CustomizedSXSSFWorkbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestStatus;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.export.BaseExport;
import org.openl.rules.testmethod.export.ParameterExport;
import org.openl.rules.testmethod.export.Styles;

public abstract class ResultExport
extends BaseExport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(OutputStream outputStream, int testsPerPage, TestUnitsResults ... results) throws IOException {
        ArrayList listsWithResults = new ArrayList();
        CustomizedSXSSFWorkbook workbook = new CustomizedSXSSFWorkbook();
        try {
            int i;
            this.styles = new Styles(workbook);
            ParameterExport parameterExport = new ParameterExport(this.styles);
            SXSSFSheet sheet = workbook.createSheet("Result 1");
            listsWithResults.add(new ArrayList());
            sheet.trackAllColumnsForAutoSizing();
            int rowNum = 2;
            for (i = 0; i < results.length; ++i) {
                if (testsPerPage > 0) {
                    int pageNum = i / testsPerPage + 1;
                    int inPage = i % testsPerPage;
                    if (inPage == 0 && pageNum > 1) {
                        this.autoSizeColumns(sheet);
                        sheet = workbook.createSheet("Result " + pageNum);
                        listsWithResults.add(new ArrayList());
                        sheet.trackAllColumnsForAutoSizing();
                        rowNum = 2;
                    }
                }
                rowNum = this.write((Sheet)sheet, results[i], rowNum) + 3;
                ((List)listsWithResults.get(listsWithResults.size() - 1)).add(results[i]);
            }
            this.autoSizeColumns(sheet);
            for (i = 0; i < listsWithResults.size(); ++i) {
                List resultsList = (List)listsWithResults.get(i);
                sheet = workbook.createSheet("Parameters " + (i + 1));
                parameterExport.write(sheet, resultsList);
            }
            workbook.write(outputStream);
            workbook.close();
        }
        finally {
            this.styles = null;
            workbook.dispose();
            listsWithResults.clear();
        }
    }

    private int write(Sheet sheet, TestUnitsResults result, int startRow) {
        int rowNum = this.writeInfo(sheet, result, startRow);
        rowNum = this.writeHeader(sheet, result, rowNum);
        rowNum = this.writeResults(sheet, result, rowNum);
        return rowNum;
    }

    protected abstract int writeInfo(Sheet var1, TestUnitsResults var2, int var3);

    private int writeHeader(Sheet sheet, TestUnitsResults result, int rowNum) {
        Row row = sheet.createRow(rowNum++);
        int colNum = 1;
        this.createCell(row, colNum++, "ID", this.styles.header);
        if (result.hasExpected()) {
            this.createCell(row, colNum++, "Status", this.styles.header);
        }
        if (result.hasDescription()) {
            this.createCell(row, colNum++, "Description", this.styles.header);
        }
        if (result.hasContext()) {
            for (String name : result.getContextColumnDisplayNames()) {
                this.createCell(row, colNum++, name, this.styles.header);
            }
        }
        for (String name : result.getTestDataColumnDisplayNames()) {
            this.createCell(row, colNum++, name, this.styles.header);
        }
        this.writeResultHeader(result, row, colNum);
        return rowNum;
    }

    protected abstract void writeResultHeader(TestUnitsResults var1, Row var2, int var3);

    private int writeResults(Sheet sheet, TestUnitsResults result, int rowNum) {
        boolean hasExpected = result.hasExpected();
        for (ITestUnit testUnit : result.getTestUnits()) {
            TestStatus testStatus = hasExpected ? testUnit.getResultStatus() : TestStatus.TR_OK;
            boolean ok = testStatus == TestStatus.TR_OK;
            Row row = sheet.createRow(rowNum++);
            int colNum = 1;
            this.createCell(row, colNum++, testUnit.getTest().getId(), ok ? this.styles.resultSuccessId : this.styles.resultFailureId);
            if (hasExpected) {
                String status;
                switch (testStatus) {
                    case TR_OK: {
                        status = "Passed";
                        break;
                    }
                    case TR_NEQ: {
                        status = "Failed";
                        break;
                    }
                    case TR_EXCEPTION: {
                        status = "Error";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                this.createCell(row, colNum++, status, ok ? this.styles.resultSuccessStatus : this.styles.resultFailureStatus);
            }
            if (result.hasDescription()) {
                this.createCell(row, colNum++, testUnit.getDescription(), this.styles.resultOther);
            }
            if (result.hasContext()) {
                for (ParameterWithValueDeclaration parameter : testUnit.getContextParams(result)) {
                    this.createCell(row, colNum++, parameter.getValue(), this.styles.resultOther);
                }
            }
            for (ParameterWithValueDeclaration parameter : testUnit.getTest().getExecutionParams()) {
                this.createCell(row, colNum++, parameter, this.styles.resultOther);
            }
            this.writeResult(row, colNum, testUnit);
        }
        return rowNum;
    }

    protected abstract void writeResult(Row var1, int var2, ITestUnit var3);
}

