/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod.result;

import java.util.Collection;
import java.util.Map;
import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.testmethod.result.ArrayComparator;
import org.openl.rules.testmethod.result.CollectionComparator;
import org.openl.rules.testmethod.result.ComparableComparator;
import org.openl.rules.testmethod.result.GenericComparator;
import org.openl.rules.testmethod.result.MapComparator;
import org.openl.rules.testmethod.result.NumberComparator;
import org.openl.rules.testmethod.result.ObjectComparator;
import org.openl.rules.testmethod.result.StringComparator;
import org.openl.rules.testmethod.result.TestResultComparator;

public class TestResultComparatorFactory {
    private TestResultComparatorFactory() {
    }

    public static TestResultComparator getComparator(Class<?> clazz, Double delta) {
        if (clazz == null) {
            GenericComparator.getInstance();
        } else {
            if (clazz.isArray()) {
                return new ArrayComparator(clazz.getComponentType(), delta);
            }
            if (String.class.equals(clazz)) {
                return StringComparator.getInstance();
            }
            if (NumberUtils.isFloatPointType(clazz)) {
                if (delta == null) {
                    return NumberComparator.getInstance();
                }
                return new NumberComparator(delta);
            }
            if (Comparable.class.isAssignableFrom(clazz)) {
                return ComparableComparator.getInstance();
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return CollectionComparator.getInstance();
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return MapComparator.getInstance();
            }
            if (Object.class.equals(clazz)) {
                if (delta == null) {
                    return ObjectComparator.getInstance();
                }
                return new ObjectComparator(delta);
            }
        }
        return GenericComparator.getInstance();
    }
}

