/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types;

import java.util.ArrayList;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.types.IModuleInfo;
import org.openl.types.IOpenMethod;

public final class ValidationMessages {
    private ValidationMessages() {
    }

    public static String getDuplicatedMethodMessage(IOpenMethod existedMethod, IOpenMethod newMethod) {
        String message;
        boolean canBeDispatched;
        String moduleName;
        ArrayList<String> modules = new ArrayList<String>();
        if (newMethod instanceof IModuleInfo && (moduleName = ((IModuleInfo)newMethod).getModuleName()) != null) {
            modules.add(moduleName);
        }
        if (existedMethod instanceof IModuleInfo && (moduleName = ((IModuleInfo)existedMethod).getModuleName()) != null) {
            modules.add(moduleName);
        }
        boolean bl = canBeDispatched = !(existedMethod instanceof TestSuiteMethod);
        if (modules.isEmpty()) {
            message = canBeDispatched ? String.format("Method \"%s\" is already used with the same version, active status, properties set!", existedMethod.getName()) : String.format("Method \"%s\" is already used!", existedMethod.getName());
        } else {
            String modulesString = (String)modules.get(0);
            message = modules.size() > 1 ? (canBeDispatched ? String.format("Method \"%s\" is already used in modules \"%s\" and \"%s\" with the same version, active status, properties set!", existedMethod.getName(), modulesString, modules.get(1)) : String.format("Method \"%s\" is already used in modules \"%s\" and \"%s\"!", existedMethod.getName(), modulesString, modules.get(1))) : (canBeDispatched ? String.format("Method \"%s\" is already used in module \"%s\" with the same version, active status, properties set!", existedMethod.getName(), modulesString) : String.format("Method \"%s\" is already used in module \"%s\"!", existedMethod.getName(), modulesString));
        }
        return message;
    }
}

