/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.exception.OpenLCompilationException;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.properties.DimensionPropertiesMethodKey;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.rules.validation.TablesValidator;
import org.openl.rules.validation.ValidationUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.validation.ValidationResult;

public class ActivePropertyValidator
extends TablesValidator {
    public static final String NO_ACTIVE_TABLE_MESSAGE = "No active table for group of tables. The last version will be used for execution.";
    public static final String ODD_ACTIVE_TABLE_MESSAGE = "There can be only one active table.";

    @Override
    public ValidationResult validateTables(OpenL openl, TableSyntaxNode[] tableSyntaxNodes, IOpenClass openClass) {
        Map<DimensionPropertiesMethodKey, List<TableSyntaxNode>> groupedMethods = this.groupExecutableMethods(tableSyntaxNodes);
        LinkedHashSet<OpenLMessage> messages = new LinkedHashSet<OpenLMessage>();
        for (DimensionPropertiesMethodKey key : groupedMethods.keySet()) {
            List<TableSyntaxNode> methodsGroup = groupedMethods.get(key);
            ArrayList<TableSyntaxNode> activeExecutableMethodTable = new ArrayList<TableSyntaxNode>();
            int activeTableFoundCount = 0;
            for (TableSyntaxNode executableMethodTable : methodsGroup) {
                if (executableMethodTable.getMember() instanceof TestSuiteMethod) {
                    ++activeTableFoundCount;
                    break;
                }
                if (executableMethodTable.getTableProperties() == null || !this.isActive(executableMethodTable)) continue;
                activeExecutableMethodTable.add(executableMethodTable);
                ++activeTableFoundCount;
            }
            if (activeTableFoundCount > 1) {
                for (TableSyntaxNode executableMethodTable : activeExecutableMethodTable) {
                    SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)ODD_ACTIVE_TABLE_MESSAGE, (ISyntaxNode)executableMethodTable);
                    if (openClass.equals(executableMethodTable.getMember().getDeclaringClass())) {
                        executableMethodTable.addError(error);
                    }
                    messages.add(OpenLMessagesUtils.newErrorMessage((OpenLCompilationException)((Object)error)));
                }
            }
            if (activeTableFoundCount != 0) continue;
            for (TableSyntaxNode tsn : methodsGroup) {
                messages.add(OpenLMessagesUtils.newWarnMessage((String)NO_ACTIVE_TABLE_MESSAGE, (ISyntaxNode)tsn));
            }
        }
        return ValidationUtils.withMessages(messages);
    }

    private boolean isActive(TableSyntaxNode executableMethodTable) {
        return Boolean.TRUE.equals(executableMethodTable.getTableProperties().getActive());
    }

    private Map<DimensionPropertiesMethodKey, List<TableSyntaxNode>> groupExecutableMethods(TableSyntaxNode[] tableSyntaxNodes) {
        HashMap<DimensionPropertiesMethodKey, List<TableSyntaxNode>> groupedMethods = new HashMap<DimensionPropertiesMethodKey, List<TableSyntaxNode>>();
        for (TableSyntaxNode tsn : tableSyntaxNodes) {
            if (!(tsn.getMember() instanceof ExecutableRulesMethod)) continue;
            ExecutableRulesMethod executableMethod = (ExecutableRulesMethod)tsn.getMember();
            DimensionPropertiesMethodKey key = new DimensionPropertiesMethodKey((IOpenMethod)executableMethod);
            if (!groupedMethods.containsKey(key)) {
                groupedMethods.put(key, new ArrayList());
            }
            ((List)groupedMethods.get(key)).add(tsn);
        }
        return groupedMethods;
    }
}

