/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.HashSet;
import java.util.Set;
import org.openl.OpenL;
import org.openl.dependency.CompiledDependency;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.validation.ValidationUtils;
import org.openl.rules.validation.properties.dimentional.DispatcherTablesBuilder;
import org.openl.types.IOpenClass;
import org.openl.validation.IOpenLValidator;
import org.openl.validation.ValidationResult;

public abstract class TablesValidator
implements IOpenLValidator {
    private void findAllTableSyntaxNodes(Set<TableSyntaxNode> tableSyntaxNodes, IOpenClass openClass) {
        if (openClass instanceof XlsModuleOpenClass) {
            TableSyntaxNode[] xlsTableSyntaxNodes;
            for (CompiledDependency compiledDependency : ((XlsModuleOpenClass)openClass).getDependencies()) {
                IOpenClass dependencyOpenClass = compiledDependency.getCompiledOpenClass().getOpenClassWithErrors();
                this.findAllTableSyntaxNodes(tableSyntaxNodes, dependencyOpenClass);
            }
            XlsMetaInfo xlsMetaInfo = ((XlsModuleOpenClass)openClass).getXlsMetaInfo();
            for (TableSyntaxNode tableSyntaxNode : xlsTableSyntaxNodes = xlsMetaInfo.getXlsModuleNode().getXlsTableSyntaxNodes()) {
                if (DispatcherTablesBuilder.isDispatcherTable(tableSyntaxNode)) continue;
                tableSyntaxNodes.add(tableSyntaxNode);
            }
        }
    }

    public ValidationResult validate(OpenL openl, IOpenClass openClass) {
        if (openClass instanceof XlsModuleOpenClass) {
            HashSet<TableSyntaxNode> tableSyntaxNodes = new HashSet<TableSyntaxNode>();
            this.findAllTableSyntaxNodes(tableSyntaxNodes, openClass);
            return this.validateTables(openl, tableSyntaxNodes.toArray(new TableSyntaxNode[0]), openClass);
        }
        return ValidationUtils.validationSuccess();
    }

    public abstract ValidationResult validateTables(OpenL var1, TableSyntaxNode[] var2, IOpenClass var3);
}

