/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import org.openl.rules.convertor.IString2DataConvertor;

public class String2LocalDateTimeConvertor
implements IString2DataConvertor<LocalDateTime> {
    private final List<DateTimeFormatter> supportedFormats = new ArrayList<DateTimeFormatter>();

    public String2LocalDateTimeConvertor() {
        this.supportedFormats.add(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        this.supportedFormats.add(DateTimeFormatter.ofPattern("M/dd/yyyy H:mm a"));
    }

    @Override
    public LocalDateTime parse(String data, String format) {
        if (data == null) {
            return null;
        }
        for (DateTimeFormatter dtFormat : this.supportedFormats) {
            try {
                return LocalDateTime.parse(data, dtFormat);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert '%s' to LocalDateTime type", data));
    }
}

