/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.List;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.meta.StringValue;
import org.openl.rules.tbasic.AlgorithmTableParserManager;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.TBasicSpecificationKey;
import org.openl.rules.tbasic.compile.AlgorithmCompiler;
import org.openl.rules.tbasic.compile.AlgorithmCompilerTool;
import org.openl.rules.tbasic.compile.SuitablityAsReturn;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;

public class ReturnAnalyzer {
    private final IOpenClass returnType;
    private final AlgorithmCompiler compiler;

    public ReturnAnalyzer(IOpenClass returnType, AlgorithmCompiler compiler) {
        this.returnType = returnType;
        this.compiler = compiler;
    }

    public SuitablityAsReturn analyze(List<AlgorithmTreeNode> nodesToAnalyze, IBindingContext bindingContext) {
        if (this.returnType != JavaOpenClass.VOID) {
            return this.analyzeSequence(nodesToAnalyze, bindingContext);
        }
        return SuitablityAsReturn.RETURN;
    }

    private SuitablityAsReturn analyzeIFOperation(List<AlgorithmTreeNode> nodesToAnalyze, boolean isMultiline, IBindingContext bindingContext) {
        SuitablityAsReturn result = SuitablityAsReturn.RETURN;
        for (int i = 0; i < 2; ++i) {
            SuitablityAsReturn suitablityOfNode = isMultiline ? this.analyzeSequence(nodesToAnalyze.get(i).getChildren(), bindingContext) : (this.hasTypeAsReturn(nodesToAnalyze.get(i).getAlgorithmRow().getAction(), bindingContext) ? SuitablityAsReturn.SUITABLE : SuitablityAsReturn.NONE);
            result = SuitablityAsReturn.lessSuitable(result, suitablityOfNode);
        }
        return result;
    }

    private SuitablityAsReturn analyzeNode(AlgorithmTreeNode nodeToAnalyze, IBindingContext bindingContext) {
        if (TBasicSpecificationKey.RETURN.toString().equals(nodeToAnalyze.getSpecificationKeyword())) {
            if (this.hasTypeAsReturn(nodeToAnalyze.getAlgorithmRow().getCondition(), bindingContext)) {
                return SuitablityAsReturn.RETURN;
            }
            IOpenSourceCodeModule errorSource = nodeToAnalyze.getAlgorithmRow().getCondition().asSourceCodeModule();
            BindHelper.processError((String)("Incorrect return type. Return type of function declared as '" + this.returnType.getDisplayName(1) + "'"), (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
            return SuitablityAsReturn.NONE;
        }
        if (this.canBeGrouped(nodeToAnalyze)) {
            return SuitablityAsReturn.NONE;
        }
        if (this.hasTypeAsReturn(nodeToAnalyze.getAlgorithmRow().getAction(), bindingContext)) {
            return SuitablityAsReturn.SUITABLE;
        }
        return SuitablityAsReturn.NONE;
    }

    private SuitablityAsReturn analyzeSequence(List<AlgorithmTreeNode> nodesToAnalyze, IBindingContext bindingContext) {
        int linkedNodesGroupSize;
        SuitablityAsReturn result = SuitablityAsReturn.RETURN;
        for (int i = 0; i < nodesToAnalyze.size(); i += linkedNodesGroupSize) {
            linkedNodesGroupSize = AlgorithmCompilerTool.getLinkedNodesGroupSize(nodesToAnalyze, i);
            if (linkedNodesGroupSize == 1) {
                result = this.analyzeNode(nodesToAnalyze.get(i), bindingContext);
            } else {
                List<AlgorithmTreeNode> nodesToAnalyze1 = nodesToAnalyze.subList(i, i + linkedNodesGroupSize);
                SuitablityAsReturn result1 = TBasicSpecificationKey.IF.toString().equals(nodesToAnalyze1.get(0).getSpecificationKeyword()) && TBasicSpecificationKey.ELSE.toString().equals(nodesToAnalyze1.get(1).getSpecificationKeyword()) ? this.analyzeIFOperation(nodesToAnalyze1, nodesToAnalyze1.get(0).getSpecification().isMultiline(), bindingContext) : SuitablityAsReturn.NONE;
                result = result1;
            }
            if (result != SuitablityAsReturn.RETURN || i + linkedNodesGroupSize >= nodesToAnalyze.size()) continue;
            IOpenSourceCodeModule errorSource = nodesToAnalyze.get(i + linkedNodesGroupSize).getAlgorithmRow().getOperation().asSourceCodeModule();
            BindHelper.processError((String)"Unreachable code. Operations after RETURN not allowed.", (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
        }
        return result;
    }

    private boolean canBeGrouped(AlgorithmTreeNode nodeToAnalyze) {
        String currentNodeKeyword = nodeToAnalyze.getSpecificationKeyword();
        String[] operationNamesToGroup = AlgorithmTableParserManager.getInstance().whatOperationsToGroup(currentNodeKeyword);
        return operationNamesToGroup != null;
    }

    public IOpenClass getReturnType() {
        return this.returnType;
    }

    private boolean hasTypeAsReturn(StringValue fieldContent, IBindingContext bindingContext) {
        if (this.returnType == JavaOpenClass.VOID) {
            return fieldContent.getValue().equals("");
        }
        IOpenClass typeOfField = this.compiler.getTypeOfField(fieldContent, bindingContext);
        return this.returnType.equals(typeOfField);
    }
}

