/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.types.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.context.IRulesRuntimeContext;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.types.impl.DefaultPropertiesContextMatcher;
import org.openl.rules.types.impl.DefaultPropertiesIntersectionFinder;
import org.openl.rules.types.impl.DefaultTablePropertiesSorter;
import org.openl.rules.types.impl.IPropertiesContextMatcher;
import org.openl.rules.types.impl.MatchingResult;
import org.openl.rules.validation.properties.dimentional.DispatcherTablesBuilder;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenMethod;

public class MatchingOpenMethodDispatcher
extends OpenMethodDispatcher {
    private static final IPropertiesContextMatcher matcher = new DefaultPropertiesContextMatcher();
    private static final DefaultTablePropertiesSorter prioritySorter = new DefaultTablePropertiesSorter();
    private static final DefaultPropertiesIntersectionFinder intersectionMatcher = new DefaultPropertiesIntersectionFinder();
    private List<IOpenMethod> candidatesSorted;
    private IOpenMethod decisionTableOpenMethod;

    public IOpenMethod getDecisionTableOpenMethod() {
        return this.decisionTableOpenMethod;
    }

    public void setDecisionTableOpenMethod(IOpenMethod decisionTableOpenMethod) {
        this.decisionTableOpenMethod = decisionTableOpenMethod;
    }

    public MatchingOpenMethodDispatcher() {
    }

    public MatchingOpenMethodDispatcher(IOpenMethod method, XlsModuleOpenClass xlsModuleOpenClass) {
        super(method, xlsModuleOpenClass);
    }

    @Override
    public void addMethod(IOpenMethod candidate) {
        super.addMethod(candidate);
        this.candidatesSorted = null;
    }

    @Override
    protected IOpenMethod findMatchingMethod(List<IOpenMethod> candidates, IRuntimeContext context) {
        HashSet<IOpenMethod> selected = new HashSet<IOpenMethod>(candidates);
        this.selectCandidates(selected, (IRulesRuntimeContext)context);
        this.maxMinSelectCandidates(selected, (IRulesRuntimeContext)context);
        switch (selected.size()) {
            case 0: {
                IOpenMethod candidateMethod = candidates.iterator().next();
                throw new OpenLRuntimeException(String.format("No matching methods with name '%3$s' for the context. Details: \n%1$s\nContext: %2$s", this.toString(candidates), context.toString(), candidateMethod.getName()));
            }
            case 1: {
                return (IOpenMethod)selected.iterator().next();
            }
        }
        IOpenMethod method = (IOpenMethod)selected.iterator().next();
        throw new OpenLRuntimeException(String.format("Ambiguous dispatch for method '%3$s'. Details: \n%1$s\nContext: %2$s", this.toString(selected), context.toString(), method.getName()));
    }

    @Override
    public TableSyntaxNode getDispatcherTable() {
        if (this.decisionTableOpenMethod == null) {
            DispatcherTablesBuilder dispatcherTablesBuilder = new DispatcherTablesBuilder(this.getDeclaringClass());
            dispatcherTablesBuilder.build(this);
        }
        if (this.decisionTableOpenMethod != null) {
            return (TableSyntaxNode)this.decisionTableOpenMethod.getInfo().getSyntaxNode();
        }
        throw new IllegalStateException(String.format("There is no dispatcher table for [%s] method.", this.getName()));
    }

    @Override
    public IMemberMetaInfo getInfo() {
        if (this.getCandidates().size() == 1) {
            return this.getCandidates().get(0).getInfo();
        }
        return this.getDispatcherTable().getMember().getInfo();
    }

    /*
     * Enabled aggressive block sorting
     */
    private MethodDispatchingPriority compareMethodProperties(ITableProperties candidateProperties, ITableProperties mostPriorityProperties, List<String> notNullPropertyNames) {
        boolean nested = false;
        boolean contains = false;
        block6: for (String propName : notNullPropertyNames) {
            switch (intersectionMatcher.match(propName, candidateProperties, mostPriorityProperties)) {
                case NESTED: {
                    nested = true;
                    break;
                }
                case CONTAINS: {
                    contains = true;
                    break;
                }
                case EQUALS: 
                case UNKNOWN: {
                    break;
                }
                case NO_INTERSECTION: 
                case PARTLY_INTERSECTS: {
                    nested = false;
                    contains = false;
                    break block6;
                }
            }
        }
        if (nested && !contains) {
            return MethodDispatchingPriority.HIGHER;
        }
        if (contains && !nested) {
            return MethodDispatchingPriority.LOWER;
        }
        return MethodDispatchingPriority.EQUAL;
    }

    private void maxMinSelectCandidates(Set<IOpenMethod> selected, IRulesRuntimeContext context) {
        if (selected.size() > 1) {
            ITableProperties candidateProperties;
            ArrayList notPriorMethods = new ArrayList();
            List<String> notNullPropertyNames = this.getNotNullPropertyNames(context);
            ArrayList<IOpenMethod> mostPriority = new ArrayList<IOpenMethod>();
            ITableProperties mostPriorityProperties = null;
            for (IOpenMethod candidate : selected) {
                if (mostPriority.isEmpty()) {
                    mostPriority.add(candidate);
                    mostPriorityProperties = PropertiesHelper.getTableProperties(candidate);
                    continue;
                }
                candidateProperties = PropertiesHelper.getTableProperties(candidate);
                int cmp = this.compareMaxMinPriorities(candidateProperties, mostPriorityProperties);
                if (cmp < 0) {
                    notPriorMethods.addAll(mostPriority);
                    mostPriority.clear();
                    mostPriority.add(candidate);
                    mostPriorityProperties = PropertiesHelper.getTableProperties(candidate);
                    continue;
                }
                if (cmp == 0) {
                    mostPriority.add(candidate);
                    continue;
                }
                notPriorMethods.add(candidate);
            }
            notPriorMethods.forEach(selected::remove);
            if (selected.size() > 1) {
                notPriorMethods.clear();
                mostPriority.clear();
                for (IOpenMethod candidate : selected) {
                    if (mostPriority.isEmpty() || notNullPropertyNames.isEmpty()) {
                        mostPriority.add(candidate);
                        continue;
                    }
                    candidateProperties = PropertiesHelper.getTableProperties(candidate);
                    int higherCount = 0;
                    int lowerCount = 0;
                    for (IOpenMethod m : mostPriority) {
                        ITableProperties mProperties = PropertiesHelper.getTableProperties(m);
                        MethodDispatchingPriority priority = this.compareMethodProperties(candidateProperties, mProperties, notNullPropertyNames);
                        if (priority == MethodDispatchingPriority.HIGHER) {
                            ++higherCount;
                            continue;
                        }
                        if (priority != MethodDispatchingPriority.LOWER) continue;
                        ++lowerCount;
                    }
                    if (higherCount == mostPriority.size()) {
                        notPriorMethods.addAll(mostPriority);
                        mostPriority.clear();
                        mostPriority.add(candidate);
                        continue;
                    }
                    if (lowerCount == mostPriority.size()) {
                        notPriorMethods.add(candidate);
                        continue;
                    }
                    mostPriority.add(candidate);
                }
            }
            notPriorMethods.forEach(selected::remove);
        }
    }

    private int compareMaxMinPriorities(ITableProperties properties1, ITableProperties properties2) {
        for (Comparator<ITableProperties> comparator : prioritySorter.getMaxMinPriorityRules()) {
            int cmp = comparator.compare(properties1, properties2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    private void selectCandidates(Set<IOpenMethod> selected, IRulesRuntimeContext context) {
        ArrayList<IOpenMethod> nomatched = new ArrayList<IOpenMethod>();
        List<String> notNullPropertyNames = this.getNotNullPropertyNames(context);
        block0: for (IOpenMethod method : selected) {
            ITableProperties props = PropertiesHelper.getTableProperties(method);
            for (String propName : notNullPropertyNames) {
                MatchingResult res = matcher.match(propName, props, context);
                if (!MatchingResult.NO_MATCH.equals((Object)res)) continue;
                nomatched.add(method);
                continue block0;
            }
        }
        nomatched.forEach(selected::remove);
    }

    private String toString(Collection<IOpenMethod> methods) {
        StringBuilder builder = new StringBuilder();
        builder.append("Candidates: {\n");
        boolean g = false;
        for (IOpenMethod method : methods) {
            if (g) {
                builder.append(",\n");
            } else {
                g = true;
            }
            builder.append("{");
            ITableProperties tableProperties = PropertiesHelper.getTableProperties(method);
            boolean f = false;
            for (Map.Entry<String, Object> entry : tableProperties.getAllDimensionalProperties().entrySet()) {
                if (f) {
                    builder.append(", ");
                } else {
                    f = true;
                }
                builder.append(entry.getKey());
                builder.append(": ");
                builder.append(tableProperties.getPropertyValueAsString(entry.getKey()));
            }
            builder.append("}");
        }
        builder.append("\n}\n");
        return builder.toString();
    }

    @Override
    public List<IOpenMethod> getCandidates() {
        if (this.candidatesSorted == null) {
            this.candidatesSorted = prioritySorter.sort(super.getCandidates());
        }
        return this.candidatesSorted;
    }

    private List<String> getNotNullPropertyNames(IRulesRuntimeContext context) {
        ArrayList<String> propNames = new ArrayList<String>();
        if (context.getCurrentDate() != null) {
            propNames.add("effectiveDate");
        }
        if (context.getCurrentDate() != null) {
            propNames.add("expirationDate");
        }
        if (context.getRequestDate() != null) {
            propNames.add("startRequestDate");
        }
        if (context.getRequestDate() != null) {
            propNames.add("endRequestDate");
        }
        if (context.getCaRegion() != null) {
            propNames.add("caRegions");
        }
        if (context.getCaProvince() != null) {
            propNames.add("caProvinces");
        }
        if (context.getCountry() != null) {
            propNames.add("country");
        }
        if (context.getRegion() != null) {
            propNames.add("region");
        }
        if (context.getCurrency() != null) {
            propNames.add("currency");
        }
        if (context.getLang() != null) {
            propNames.add("lang");
        }
        if (context.getLob() != null) {
            propNames.add("lob");
        }
        if (context.getUsRegion() != null) {
            propNames.add("usregion");
        }
        if (context.getUsState() != null) {
            propNames.add("state");
        }
        if (context.getNature() != null) {
            propNames.add("nature");
        }
        return propNames;
    }

    private static enum MethodDispatchingPriority {
        HIGHER,
        LOWER,
        EQUAL;

    }
}

