/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.element;

import java.lang.reflect.Array;
import java.util.Objects;
import org.openl.binding.impl.NodeDescriptionHolder;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.rules.calc.ASpreadsheetField;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.types.IOpenClass;
import org.openl.vm.IRuntimeEnv;

public class SpreadsheetRangeField
extends ASpreadsheetField
implements NodeDescriptionHolder {
    private final int sx;
    private final int sy;
    private final int ex;
    private final int ey;
    private final IOpenCast[][] casts;
    private final Class<?> rangeType;
    private final String rangeName;

    public SpreadsheetRangeField(String name, String rangeName, int sx, int sy, int ex, int ey, IOpenClass rangeType, IOpenCast[][] casts, IOpenClass declaringClass) {
        super(declaringClass, name, rangeType.getArrayType(1));
        this.rangeName = Objects.requireNonNull(rangeName, "rangeName cannot be null");
        this.sx = sx;
        this.sy = sy;
        this.ex = ex;
        this.ey = ey;
        this.casts = casts;
        this.rangeType = rangeType.getInstanceClass();
    }

    public Object get(Object target, IRuntimeEnv env) {
        if (target == null) {
            return this.getType().nullObject();
        }
        int w = this.ex - this.sx + 1;
        int h = this.ey - this.sy + 1;
        int size = w * h;
        SpreadsheetResultCalculator calc = (SpreadsheetResultCalculator)target;
        Object array = Array.newInstance(this.rangeType, size);
        int i = 0;
        for (int x = this.sx; x <= this.ex; ++x) {
            for (int y = this.sy; y <= this.ey; ++y) {
                Object v = calc.getValue(y, x);
                IOpenCast openCast = this.casts[x - this.sx][y - this.sy];
                if (openCast != null && openCast.isImplicit()) {
                    v = openCast.convert(v);
                }
                Array.set(array, i, v);
                ++i;
            }
        }
        return array;
    }

    @Override
    public String getDescription() {
        return this.getType().getDisplayName(0) + " " + this.rangeName;
    }
}

