/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.rules.annotations.Executable;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.dt.DTInfo;
import org.openl.rules.dt.DecisionTableInvoker;
import org.openl.rules.dt.IBaseAction;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.IBaseDecisionRow;
import org.openl.rules.dt.IDecisionTable;
import org.openl.rules.dt.algorithm.DecisionTableAlgorithmBuilder;
import org.openl.rules.dt.algorithm.IDecisionTableAlgorithm;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.lang.xls.binding.AMethodBasedNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ILogicalTable;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.types.impl.CompositeMethod;
import org.openl.vm.IRuntimeEnv;

@Executable
public class DecisionTable
extends ExecutableRulesMethod
implements IDecisionTable {
    private IBaseCondition[] conditionRows;
    private IBaseAction[] actionRows;
    private RuleRow ruleRow;
    private int columns;
    private IDecisionTableAlgorithm algorithm;
    private Invokable invoker;
    private DTInfo dtInfo;
    private ModuleOpenClass module;
    private CustomSpreadsheetResultOpenClass customSpreadsheetResultType;
    private int dim = 0;
    private final List<DeferredChange> deferredChanges = new ArrayList<DeferredChange>();
    private boolean typeCustomSpreadsheetResult;

    public DecisionTable() {
        super(null, null);
    }

    public DecisionTable(IOpenMethodHeader header, AMethodBasedNode boundNode, boolean typeCustomSpreadsheetResult) {
        super(header, boundNode);
        this.initProperties(this.getSyntaxNode().getTableProperties());
        this.typeCustomSpreadsheetResult = typeCustomSpreadsheetResult;
    }

    public boolean isTypeCustomSpreadsheetResult() {
        return this.typeCustomSpreadsheetResult;
    }

    public void setTypeCustomSpreadsheetResult(boolean typeCustomSpreadsheetResult) {
        this.typeCustomSpreadsheetResult = typeCustomSpreadsheetResult;
    }

    public CustomSpreadsheetResultOpenClass getCustomSpreadsheetResultType() {
        return this.customSpreadsheetResultType;
    }

    public void setCustomSpreadsheetResultType(CustomSpreadsheetResultOpenClass customSpreadsheetResultType) {
        this.customSpreadsheetResultType = customSpreadsheetResultType;
    }

    public void setDim(int dim) {
        this.dim = dim;
    }

    public int getDim() {
        return this.dim;
    }

    public IOpenClass getType() {
        if (this.isTypeCustomSpreadsheetResult()) {
            if (this.customSpreadsheetResultType == null) {
                return super.getType();
            }
            if (this.dim > 0) {
                return this.customSpreadsheetResultType.getArrayType(this.dim);
            }
            return this.customSpreadsheetResultType;
        }
        return super.getType();
    }

    public ModuleOpenClass getModule() {
        return this.module;
    }

    @Override
    public IBaseAction[] getActionRows() {
        return this.actionRows;
    }

    public void setActionRows(IAction[] actionRows) {
        this.actionRows = actionRows;
    }

    public IDecisionTableAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    @Override
    public IBaseCondition[] getConditionRows() {
        return this.conditionRows;
    }

    public void setConditionRows(IBaseCondition[] conditionRows) {
        this.conditionRows = conditionRows;
    }

    public String getDisplayName(int mode) {
        IMemberMetaInfo metaInfo = this.getHeader().getInfo();
        if (metaInfo != null) {
            return metaInfo.getDisplayName(mode);
        }
        return this.toString();
    }

    @Override
    public IOpenMethod getMethod() {
        return this;
    }

    @Override
    public int getNumberOfRules() {
        if (this.actionRows.length > 0) {
            return this.actionRows[0].getNumberOfRules();
        }
        return 0;
    }

    @Override
    public String getRuleName(int col) {
        return this.ruleRow == null ? "R" + (col + 1) : this.ruleRow.getRuleName(col);
    }

    public RuleRow getRuleRow() {
        return this.ruleRow;
    }

    public void setRuleRow(RuleRow ruleRow) {
        this.ruleRow = ruleRow;
    }

    @Override
    public ILogicalTable getRuleTable(int ruleIndex) {
        ILogicalTable dt = this.actionRows[0].getDecisionTable();
        int starColumn = dt.getWidth() - this.columns;
        return (ILogicalTable)dt.getColumn(starColumn + ruleIndex);
    }

    public String getSourceUrl() {
        return this.getSyntaxNode().getUri();
    }

    public void bindTable(IBaseCondition[] conditionRows, IBaseAction[] actionRows, RuleRow ruleRow, OpenL openl, ModuleOpenClass module, IBindingContext bindingContext, int columns) throws Exception {
        this.conditionRows = conditionRows;
        this.actionRows = actionRows;
        this.ruleRow = ruleRow;
        this.columns = columns;
        this.module = Objects.requireNonNull(module, "module cannot be null");
        this.prepare(this.getHeader(), openl, bindingContext);
    }

    @Override
    public BindingDependencies getDependencies() {
        RulesBindingDependencies bindingDependencies = new RulesBindingDependencies();
        this.updateDependency(bindingDependencies);
        return bindingDependencies;
    }

    @Override
    protected Object innerInvoke(Object target, Object[] params, IRuntimeEnv env) {
        if (this.invoker == null) {
            this.invoker = new DecisionTableInvoker(this);
        }
        return this.invoker.invoke(target, params, env);
    }

    public boolean shouldFailOnMiss() {
        if (this.getMethodProperties() != null) {
            return (Boolean)this.getMethodProperties().getPropertyValue("failOnMiss");
        }
        return false;
    }

    private void prepare(IOpenMethodHeader header, OpenL openl, IBindingContext bindingContext) throws Exception {
        DecisionTableAlgorithmBuilder algorithmBuilder = new DecisionTableAlgorithmBuilder(this, header, openl);
        this.algorithm = algorithmBuilder.prepareAndBuildAlgorithm(bindingContext);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void updateDependency(BindingDependencies dependencies) {
        CompositeMethod method;
        if (this.conditionRows != null) {
            for (IBaseDecisionRow iBaseDecisionRow : this.conditionRows) {
                method = (CompositeMethod)iBaseDecisionRow.getMethod();
                if (method != null) {
                    method.updateDependency(dependencies);
                }
                this.updateValueDependency((FunctionalRow)iBaseDecisionRow, dependencies);
            }
        }
        if (this.actionRows != null) {
            for (IBaseDecisionRow iBaseDecisionRow : this.actionRows) {
                method = (CompositeMethod)iBaseDecisionRow.getMethod();
                if (method != null) {
                    method.updateDependency(dependencies);
                }
                this.updateValueDependency((FunctionalRow)iBaseDecisionRow, dependencies);
            }
        }
    }

    protected void updateValueDependency(FunctionalRow frow, BindingDependencies dependencies) {
        int len = frow.getNumberOfRules();
        int np = frow.getNumberOfParams();
        for (int ruleN = 0; ruleN < len; ++ruleN) {
            if (frow.isEmpty(ruleN)) continue;
            for (int paramIndex = 0; paramIndex < np; ++paramIndex) {
                Object value = frow.getParamValue(paramIndex, ruleN);
                if (value instanceof CompositeMethod) {
                    ((CompositeMethod)value).updateDependency(dependencies);
                    continue;
                }
                if (!(value instanceof ArrayHolder)) continue;
                ArrayHolder ah = (ArrayHolder)value;
                ah.updateDependency(dependencies);
            }
        }
    }

    public ICondition getCondition(int n) {
        return (ICondition)this.conditionRows[n];
    }

    public IAction getAction(int n) {
        return (IAction)this.actionRows[n];
    }

    public DTInfo getDtInfo() {
        return this.dtInfo;
    }

    public void setDtInfo(DTInfo dtInfo) {
        this.dtInfo = dtInfo;
    }

    @Override
    public int getNumberOfConditions() {
        return this.conditionRows.length;
    }

    public int getNumberOfActions() {
        return this.actionRows.length;
    }

    @Override
    public void clearForExecutionMode() {
        super.clearForExecutionMode();
        if (this.algorithm != null) {
            this.algorithm.cleanParamValuesForIndexedConditions();
        }
        Function<IBaseDecisionRow[], Stream> toStream = row -> Optional.ofNullable(row).map(Stream::of).orElseGet(Stream::empty);
        Stream.concat(toStream.apply(this.actionRows), toStream.apply(this.conditionRows)).forEach(IBaseDecisionRow::removeDebugInformation);
    }

    public List<DeferredChange> getDeferredChanges() {
        return this.deferredChanges;
    }

    public static interface DeferredChange {
        public void apply();
    }
}

