/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ConstructorUsage;
import org.openl.binding.impl.MethodUsage;
import org.openl.binding.impl.NodeUsage;
import org.openl.binding.impl.NodeUsageFactory;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.CompositeSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.CollectionUtils;

public class MetaInfoReaderUtils {
    public static List<CellMetaInfo> getMetaInfo(IOpenSourceCodeModule source, CompositeMethod method) {
        int startIndex = 0;
        if (source instanceof CompositeSourceCodeModule) {
            return MetaInfoReaderUtils.getMetaInfoForCompositeSource(method, (CompositeSourceCodeModule)source, startIndex);
        }
        IOpenSourceCodeModule src = source;
        while (src instanceof SubTextSourceCodeModule) {
            startIndex += src.getStartPosition();
            src = ((SubTextSourceCodeModule)src).getBaseModule();
        }
        if (src instanceof GridCellSourceCodeModule) {
            List<NodeUsage> nodeUsages = MetaInfoReaderUtils.getNodeUsages(method, source.getCode(), startIndex);
            return Collections.singletonList(MetaInfoReaderUtils.getCellMetaInfoOrNull(nodeUsages));
        }
        return Collections.singletonList(null);
    }

    public static List<NodeUsage> getNodeUsages(CompositeMethod method, String sourceString, int startIndex) {
        if (method == null) {
            return Collections.emptyList();
        }
        return NodeUsageFactory.createNodeUsageList((IBoundNode)method.getMethodBodyBoundNode(), sourceString, startIndex);
    }

    private static List<CellMetaInfo> getMetaInfoForCompositeSource(CompositeMethod method, CompositeSourceCodeModule source, int startIndex) {
        List<NodeUsage> nodeUsages = MetaInfoReaderUtils.getNodeUsages(method, source.getCode(), startIndex);
        IOpenSourceCodeModule[] modules = source.getModules();
        int moduleStart = 0;
        ArrayList<CellMetaInfo> metaInfoList = new ArrayList<CellMetaInfo>();
        for (IOpenSourceCodeModule module : modules) {
            int moduleEnd = moduleStart + module.getCode().length();
            if (module instanceof GridCellSourceCodeModule) {
                ArrayList<NodeUsage> currentCellMethodUsages = new ArrayList<NodeUsage>();
                for (NodeUsage usage : nodeUsages) {
                    if (usage.getStart() < moduleStart || usage.getEnd() > moduleEnd) continue;
                    if (usage instanceof ConstructorUsage) {
                        currentCellMethodUsages.add(new ConstructorUsage(((ConstructorUsage)usage).getConstructorNode(), usage.getStart() - moduleStart, usage.getEnd() - moduleStart, ((MethodUsage)usage).getMethod()));
                        continue;
                    }
                    if (usage instanceof MethodUsage) {
                        currentCellMethodUsages.add(new MethodUsage(usage.getStart() - moduleStart, usage.getEnd() - moduleStart, ((MethodUsage)usage).getMethod()));
                        continue;
                    }
                    currentCellMethodUsages.add(new SimpleNodeUsage(usage.getStart() - moduleStart, usage.getEnd() - moduleStart, usage.getDescription(), usage.getUri(), usage.getNodeType()));
                }
                metaInfoList.add(MetaInfoReaderUtils.getCellMetaInfoOrNull(currentCellMethodUsages));
            } else {
                metaInfoList.add(null);
            }
            moduleStart = moduleEnd + 1;
        }
        return metaInfoList;
    }

    private static CellMetaInfo getCellMetaInfoOrNull(List<NodeUsage> methodUsages) {
        if (CollectionUtils.isNotEmpty(methodUsages)) {
            return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, methodUsages);
        }
        return null;
    }
}

