/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.binding;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openl.binding.IBindingContext;
import org.openl.binding.MethodUtil;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.binding.impl.NodeType;
import org.openl.binding.impl.SimpleNodeUsage;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.domain.IDomain;
import org.openl.exception.OpenLCompilationException;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.constants.ConstantOpenField;
import org.openl.rules.convertor.IObjectToDataConvertor;
import org.openl.rules.convertor.ObjectToDataConvertorFactory;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.BaseMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.SubTextSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenIndex;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.DomainUtils;
import org.openl.util.StringPool;
import org.openl.util.StringTool;

public final class RuleRowHelper {
    private static final String COMMENTARY = "//";
    public static final String ARRAY_ELEMENTS_SEPARATOR_ESCAPER = "\\";
    public static final String ARRAY_ELEMENTS_SEPARATOR = ",";
    public static final String CONSTRUCTOR = "constructor";
    private static final Object EMPTY_CELL = new Object();
    private static final Object[] EMPTY_ROW = new Object[0];

    private RuleRowHelper() {
    }

    public static int calculateHeight(ILogicalTable table) {
        int height = table.getHeight();
        int last = -1;
        for (int i = 0; i < height; ++i) {
            String source = ((ILogicalTable)table.getRow(i)).getSource().getCell(0, 0).getStringValue();
            if (source == null || source.trim().length() == 0) continue;
            last = i;
        }
        return last + 1;
    }

    public static String[] extractElementsFromCommaSeparatedArray(ILogicalTable cell) {
        String[] tokens = null;
        String src = cell.getSource().getCell(0, 0).getStringValue();
        if (src != null) {
            tokens = StringTool.splitAndEscape((String)src, (String)ARRAY_ELEMENTS_SEPARATOR, (String)ARRAY_ELEMENTS_SEPARATOR_ESCAPER);
        }
        return tokens;
    }

    public static Object loadCommaSeparatedParam(IOpenClass aggregateType, IOpenClass paramType, String paramName, String ruleName, ILogicalTable cell, OpenlToolAdaptor openlAdaptor) {
        Object arrayValues;
        String[] tokens = RuleRowHelper.extractElementsFromCommaSeparatedArray(cell);
        if (tokens != null) {
            ArrayList<Object> values = new ArrayList<Object>(tokens.length);
            for (String token : tokens) {
                String str = StringPool.intern((String)token);
                Object res = RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, cell, openlAdaptor, str);
                if (res == null) {
                    res = paramType.nullObject();
                }
                values.add(res);
            }
            int valuesArraySize = values.size();
            IAggregateInfo aggregateInfo = aggregateType.getAggregateInfo();
            arrayValues = aggregateInfo.makeIndexedAggregate(paramType, valuesArraySize);
            IOpenIndex index = aggregateInfo.getIndex(aggregateType);
            if (index != null) {
                for (int i = 0; i < valuesArraySize; ++i) {
                    index.setValue(arrayValues, (Object)i, values.get(i));
                }
            } else if (arrayValues instanceof Collection) {
                ((Collection)arrayValues).addAll(values);
            }
        } else {
            arrayValues = aggregateType.getAggregateInfo().makeIndexedAggregate(paramType, 0);
        }
        return arrayValues;
    }

    public static Object loadSingleParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable table, OpenlToolAdaptor openlAdapter) {
        ICell theCell;
        RuleRowHelper.validateSimpleParam(table, openlAdapter.getBindingContext());
        ICell theValueCell = theCell = table.getSource().getCell(0, 0);
        if (theCell.getRegion() != null) {
            theValueCell = theCell.getTopLeftCellFromRegion();
        }
        if (String.class == paramType.getInstanceClass()) {
            String src = theValueCell.getStringValue();
            if (src != null) {
                src = src.length() <= 4 ? src.intern() : src;
            }
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, table, openlAdapter, src);
        }
        if (theValueCell.hasNativeType()) {
            RuleRowHelper.loadNativeValue(paramType, paramName, ruleName, table, openlAdapter, theValueCell);
        }
        String src = theValueCell.getStringValue();
        return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, table, openlAdapter, src);
    }

    private static boolean isCellNumericStringDate(ICell theValueCell, IOpenClass paramType) {
        Class instanceClass = paramType.getInstanceClass();
        int nativeType = theValueCell.getNativeType();
        return ClassUtils.isAssignable((Class)instanceClass, Date.class) && nativeType == 1 && RuleRowHelper.isNumeric(theValueCell.getStringValue());
    }

    public static boolean isNumeric(CharSequence cs) {
        if (cs == null || cs.length() == 0) {
            return false;
        }
        int sz = cs.length();
        int dots = 0;
        for (int i = 0; i < sz; ++i) {
            if (!Character.isDigit(cs.charAt(i))) {
                return false;
            }
            if (cs.charAt(i) != '.' || ++dots <= 1) continue;
            return false;
        }
        return true;
    }

    private static Object loadNativeValue(IOpenClass paramType, String paramName, String ruleName, ILogicalTable table, OpenlToolAdaptor openlAdapter, ICell theValueCell) {
        if (theValueCell.getNativeType() == 0 || RuleRowHelper.isCellNumericStringDate(theValueCell, paramType)) {
            try {
                Object res = RuleRowHelper.loadNativeValue(theValueCell, paramType);
                if (res instanceof IMetaHolder) {
                    RuleRowHelper.setMetaInfo((IMetaHolder)res, table, paramName, ruleName, openlAdapter.getBindingContext());
                }
                if (res != null) {
                    RuleRowHelper.validateValue(res, paramType);
                    return res;
                }
            }
            catch (Exception | LinkageError t) {
                String message = t.getMessage();
                if (message == null) {
                    message = "Cannot load cell value";
                }
                BindHelper.processError((String)message, (Throwable)t, (IOpenSourceCodeModule)new GridCellSourceCodeModule(table.getSource(), openlAdapter.getBindingContext()), (IBindingContext)openlAdapter.getBindingContext());
            }
        }
        return null;
    }

    private static void validateSimpleParam(ILogicalTable table, IBindingContext bindingContext) {
        ICell theCell = table.getSource().getCell(0, 0);
        if (table.getWidth() > 1 || table.getHeight() > 1) {
            for (int i = 0; i < table.getHeight(); ++i) {
                for (int j = 0; j < table.getWidth(); ++j) {
                    if (i == 0 && j == 0) continue;
                    ICell cell = table.getCell(j, i);
                    if (theCell.getAbsoluteRegion().getTop() == cell.getAbsoluteRegion().getTop() && theCell.getAbsoluteRegion().getLeft() == cell.getAbsoluteRegion().getLeft() || cell.getStringValue() == null || cell.getStringValue().startsWith(COMMENTARY)) continue;
                    BindHelper.processError((String)"Table structure is wrong. More than one cell with data found where only one cell is expected.", (IOpenSourceCodeModule)new GridCellSourceCodeModule(table.getSource(), bindingContext), (IBindingContext)bindingContext);
                    return;
                }
            }
        }
    }

    public static Object loadNativeValue(ICell cell, IOpenClass paramType) {
        Object res = null;
        Class expectedType = paramType.getInstanceClass();
        if (cell.getNativeType() == 0 || RuleRowHelper.isCellNumericStringDate(cell, paramType)) {
            if (expectedType == null) {
                return null;
            }
            if (cell.getObjectValue() instanceof Date) {
                IObjectToDataConvertor objectConverter = ObjectToDataConvertorFactory.getConvertor(expectedType, Date.class);
                return objectConverter != ObjectToDataConvertorFactory.NO_Convertor ? objectConverter.convert(cell.getNativeDate()) : null;
            }
            if (ClassUtils.isAssignable((Class)expectedType, BigDecimal.class)) {
                res = String2DataConvertorFactory.parse(expectedType, cell.getStringValue(), null);
            } else {
                double value = cell.getNativeNumber();
                IObjectToDataConvertor objectConverter = ObjectToDataConvertorFactory.getConvertor(expectedType, Double.TYPE);
                if (objectConverter != ObjectToDataConvertorFactory.NO_Convertor) {
                    res = objectConverter.convert(value);
                } else {
                    objectConverter = ObjectToDataConvertorFactory.getConvertor(expectedType, Double.class);
                    if (objectConverter != ObjectToDataConvertorFactory.NO_Convertor) {
                        res = objectConverter.convert(value);
                    } else {
                        objectConverter = ObjectToDataConvertorFactory.getConvertor(expectedType, Date.class);
                        if (objectConverter != ObjectToDataConvertorFactory.NO_Convertor) {
                            Date dateValue = cell.getNativeDate();
                            res = objectConverter.convert(dateValue);
                        } else if ((double)((int)value) == value && (objectConverter = ObjectToDataConvertorFactory.getConvertor(expectedType, Integer.class)) != ObjectToDataConvertorFactory.NO_Convertor) {
                            res = objectConverter.convert((int)value);
                        }
                    }
                }
            }
        }
        return res;
    }

    public static SimpleNodeUsage createConstantNodeUsage(ConstantOpenField constantOpenField, int start, int end) {
        String description = MethodUtil.printType((IOpenClass)constantOpenField.getType()) + " " + constantOpenField.getName() + " = " + constantOpenField.getValueAsString();
        return new SimpleNodeUsage(start, end, description, constantOpenField.getMemberMetaInfo().getSourceUrl(), NodeType.OTHER);
    }

    private static XlsModuleOpenClass getComponentOpenClass(IBindingContext bindingContext) {
        ComponentOpenClass openClass;
        if (bindingContext instanceof ComponentBindingContext && (openClass = ((ComponentBindingContext)bindingContext).getComponentOpenClass()) instanceof XlsModuleOpenClass) {
            return (XlsModuleOpenClass)openClass;
        }
        if (bindingContext instanceof BindingContextDelegator) {
            BindingContextDelegator bindingContextDelegator = (BindingContextDelegator)bindingContext;
            return RuleRowHelper.getComponentOpenClass(bindingContextDelegator.getDelegate());
        }
        return null;
    }

    public static ConstantOpenField findConstantField(IBindingContext bindingContext, String source) {
        IOpenField openField;
        if (source == null) {
            return null;
        }
        XlsModuleOpenClass xlsModuleOpenClass = RuleRowHelper.getComponentOpenClass(bindingContext);
        if (xlsModuleOpenClass != null && (openField = xlsModuleOpenClass.getField(source.trim())) instanceof ConstantOpenField) {
            return (ConstantOpenField)openField;
        }
        return null;
    }

    public static Object castConstantToExpectedType(IBindingContext bindingContext, ConstantOpenField constantOpenField, IOpenClass expectedType) {
        IOpenCast openCast = bindingContext.getCast(constantOpenField.getType(), expectedType);
        if (openCast != null && openCast.isImplicit()) {
            return openCast.convert(constantOpenField.getValue());
        }
        throw new ClassCastException(String.format("Expected value of type '%s'.", expectedType.getName()));
    }

    private static Object loadSingleParam(IOpenClass paramType, String paramName, String ruleName, ILogicalTable cell, OpenlToolAdaptor openlAdaptor, String source) {
        if (source != null && (source = source.trim()).length() != 0) {
            GridCellSourceCodeModule cellSourceCodeModule;
            String message;
            Class expectedType;
            IBindingContext bindingContext = openlAdaptor.getBindingContext();
            if (openlAdaptor.getHeader() != null) {
                IOpenMethodHeader oldHeader = openlAdaptor.getHeader();
                OpenMethodHeader newHeader = new OpenMethodHeader(oldHeader.getName(), paramType, oldHeader.getSignature(), oldHeader.getDeclaringClass());
                openlAdaptor.setHeader((IOpenMethodHeader)newHeader);
                if (source.startsWith("{") && source.endsWith("}")) {
                    GridCellSourceCodeModule srcCode = new GridCellSourceCodeModule(cell.getSource(), bindingContext);
                    return openlAdaptor.makeMethod(srcCode);
                }
                if (source.startsWith("=") && (source.length() > 2 || source.length() == 2 && Character.isLetterOrDigit(source.charAt(1)))) {
                    GridCellSourceCodeModule gridSource = new GridCellSourceCodeModule(cell.getSource(), bindingContext);
                    SubTextSourceCodeModule code = new SubTextSourceCodeModule((IOpenSourceCodeModule)gridSource, 1);
                    return openlAdaptor.makeMethod((IOpenSourceCodeModule)code);
                }
            }
            if ((expectedType = paramType.getInstanceClass()) == null) {
                GridCellSourceCodeModule cellSourceCodeModule2 = new GridCellSourceCodeModule(cell.getSource(), bindingContext);
                BindHelper.processError((String)String.format("Cannot parse cell value '%s'. Undefined cell type.", source), (IOpenSourceCodeModule)cellSourceCodeModule2, (IBindingContext)bindingContext);
                return null;
            }
            Object result = null;
            try {
                ConstantOpenField constantOpenField = RuleRowHelper.findConstantField(bindingContext, source);
                ICell theValueCell = cell.getSource().getCell(0, 0);
                if (constantOpenField != null) {
                    if (!bindingContext.isExecutionMode()) {
                        RuleRowHelper.addConstantMetaInfo(openlAdaptor, constantOpenField, theValueCell);
                    }
                    if (constantOpenField.getValue() != null) {
                        result = RuleRowHelper.castConstantToExpectedType(bindingContext, constantOpenField, paramType);
                    }
                } else if (String.class == paramType.getInstanceClass()) {
                    result = String2DataConvertorFactory.parse(expectedType, source, bindingContext);
                } else {
                    if (theValueCell.hasNativeType()) {
                        result = RuleRowHelper.loadNativeValue(paramType, paramName, ruleName, cell, openlAdaptor, theValueCell);
                    }
                    if (result == null) {
                        result = String2DataConvertorFactory.parse(expectedType, source, bindingContext);
                    }
                }
            }
            catch (Exception | LinkageError e) {
                message = String.format("Cannot parse cell value '%s'. Expected value of type '%s'.", source, paramType.getDisplayName(0));
                cellSourceCodeModule = new GridCellSourceCodeModule(cell.getSource(), bindingContext);
                BindHelper.processError((String)message, (Throwable)e, (IOpenSourceCodeModule)cellSourceCodeModule, (IBindingContext)bindingContext);
            }
            if (result instanceof IMetaHolder) {
                RuleRowHelper.setMetaInfo((IMetaHolder)result, cell, paramName, ruleName, bindingContext);
            }
            try {
                RuleRowHelper.validateValue(result, paramType);
            }
            catch (Exception e) {
                message = String.format("Invalid cell value '%s'", source);
                cellSourceCodeModule = new GridCellSourceCodeModule(cell.getSource(), bindingContext);
                BindHelper.processError((String)message, (Throwable)e, (IOpenSourceCodeModule)cellSourceCodeModule, (IBindingContext)bindingContext);
            }
            return result;
        }
        return null;
    }

    private static void addConstantMetaInfo(OpenlToolAdaptor openlAdapter, ConstantOpenField constantOpenField, ICell theValueCell) {
        MetaInfoReader metaInfoReader = openlAdapter.getTableSyntaxNode().getMetaInfoReader();
        if (metaInfoReader instanceof BaseMetaInfoReader) {
            String[] tokens = StringTool.splitAndEscape((String)theValueCell.getStringValue(), (String)ARRAY_ELEMENTS_SEPARATOR, null);
            String cellValue = theValueCell.getStringValue();
            int startFrom = 0;
            for (String token : tokens) {
                int start = cellValue.indexOf(token, startFrom);
                startFrom = start + token.length();
                if (!token.equals(constantOpenField.getName())) continue;
                int end = start + constantOpenField.getName().length();
                SimpleNodeUsage nodeUsage = RuleRowHelper.createConstantNodeUsage(constantOpenField, start, end);
                ((BaseMetaInfoReader)metaInfoReader).addConstant(theValueCell, nodeUsage);
            }
        }
    }

    public static boolean isFormula(String value) {
        if (value != null) {
            return value.trim().startsWith("=");
        }
        return false;
    }

    public static boolean isFormula(ILogicalTable valuesTable) {
        String stringValue = valuesTable.getSource().getCell(0, 0).getStringValue();
        return RuleRowHelper.isFormula(stringValue);
    }

    public static CellMetaInfo createCellMetaInfo(IdentifierNode identifier, IMetaInfo metaInfo, NodeType nodeType) {
        SimpleNodeUsage nodeUsage = new SimpleNodeUsage(identifier, metaInfo.getDisplayName(0), metaInfo.getSourceUrl(), nodeType);
        return new CellMetaInfo((IOpenClass)JavaOpenClass.STRING, false, Collections.singletonList(nodeUsage));
    }

    private static void setMetaInfo(IMetaHolder holder, ILogicalTable cell, String paramName, String ruleName, IBindingContext bindingContext) {
        if (!bindingContext.isExecutionMode()) {
            ValueMetaInfo valueMetaInfo = new ValueMetaInfo();
            valueMetaInfo.setShortName(paramName);
            valueMetaInfo.setFullName((String)(ruleName == null ? paramName : ruleName + "." + paramName));
            valueMetaInfo.setSource((IOpenSourceCodeModule)new GridCellSourceCodeModule(cell.getSource(), bindingContext));
            holder.setMetaInfo((IMetaInfo)valueMetaInfo);
        }
    }

    public static void validateValue(Object value, IOpenClass paramType) throws OpenLCompilationException {
        IDomain domain = paramType.getDomain();
        if (domain != null) {
            RuleRowHelper.validateDomain(value, (IDomain<Object>)domain, paramType);
        }
    }

    private static void validateDomain(Object value, IDomain<Object> domain, IOpenClass paramType) throws OpenLCompilationException {
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                RuleRowHelper.validateDomain(element, domain, paramType);
            }
        } else if (value instanceof Iterable && !(value instanceof INumberRange)) {
            Iterable list = (Iterable)value;
            for (Object element : list) {
                RuleRowHelper.validateDomain(element, domain, paramType);
            }
        } else {
            try {
                boolean contains = domain.selectObject(value);
                if (!contains) {
                    throw new OpenLCompilationException(String.format("The value '%s' is outside of valid domain '%s'. Valid values: %s", value, paramType.getName(), DomainUtils.toString(domain)));
                }
            }
            catch (RuntimeException e) {
                throw new OpenLCompilationException(e.getMessage(), e.getCause());
            }
        }
    }

    public static Object loadParam(ILogicalTable dataTable, IOpenClass paramType, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, boolean loadSingleParamOnly) {
        boolean oneCellTable;
        if (!loadSingleParamOnly) {
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
        }
        int height = RuleRowHelper.calculateHeight(dataTable = LogicalTableHelper.make1ColumnTable(dataTable));
        boolean bl = oneCellTable = height == 1;
        if (height == 0) {
            return null;
        }
        if (oneCellTable && !paramType.isArray()) {
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
        }
        IOpenClass arrayType = paramType.getAggregateInfo().getComponentType(paramType);
        if (oneCellTable) {
            if (!RuleRowHelper.isFormula(dataTable)) {
                IOpenCast openCast;
                ConstantOpenField constantOpenField;
                String[] tokens = RuleRowHelper.extractElementsFromCommaSeparatedArray((ILogicalTable)dataTable.getRow(0));
                if (tokens != null && tokens.length == 1 && (constantOpenField = RuleRowHelper.findConstantField(openlAdaptor.getBindingContext(), tokens[0])) != null && (openCast = openlAdaptor.getBindingContext().getCast(constantOpenField.getType(), paramType)) != null && openCast.isImplicit()) {
                    if (!openlAdaptor.getBindingContext().isExecutionMode()) {
                        RuleRowHelper.addConstantMetaInfo(openlAdaptor, constantOpenField, ((ILogicalTable)dataTable.getRow(0)).getSource().getCell(0, 0));
                    }
                    return openCast.convert(constantOpenField.getValue());
                }
                return RuleRowHelper.loadCommaSeparatedArrayParams(dataTable, paramName, ruleName, openlAdaptor, paramType, arrayType);
            }
            return RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, dataTable, openlAdaptor);
        }
        return RuleRowHelper.loadSimpleArrayParams(dataTable, paramName, ruleName, openlAdaptor, paramType, arrayType);
    }

    private static Object loadCommaSeparatedArrayParams(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass aggregateType, IOpenClass paramType) {
        ILogicalTable paramSource = (ILogicalTable)dataTable.getRow(0);
        Object params = RuleRowHelper.loadCommaSeparatedParam(aggregateType, paramType, paramName, ruleName, paramSource, openlAdaptor);
        Class<?> paramClass = params.getClass();
        if (paramClass.isArray() && !paramClass.getComponentType().isPrimitive()) {
            return RuleRowHelper.processAsObjectParams(paramType, (Object[])params);
        }
        return params;
    }

    private static Object processAsObjectParams(IOpenClass paramType, Object[] paramsArray) {
        int paramsLength = paramsArray.length;
        Object array = null;
        boolean hasFormulas = false;
        for (int i = 0; i < paramsLength; ++i) {
            if (paramsArray[i] instanceof CompositeMethod) {
                hasFormulas = true;
                break;
            }
            if (array == null) {
                array = paramType.getAggregateInfo().makeIndexedAggregate(paramType, paramsLength);
            }
            Array.set(array, i, paramsArray[i]);
        }
        return hasFormulas ? new ArrayHolder(paramType, paramsArray) : array;
    }

    private static Object loadSimpleArrayParams(ILogicalTable dataTable, String paramName, String ruleName, OpenlToolAdaptor openlAdaptor, IOpenClass aggregateType, IOpenClass paramType) {
        int i;
        boolean hasFormulas = false;
        int height = dataTable.getHeight();
        int width = dataTable.getWidth();
        if (!paramType.isArray() || height == 1 || width == 1) {
            int i2;
            ArrayList<Object> values = new ArrayList<Object>();
            boolean byHeight = height > 1 || width == 1;
            for (i2 = 0; i2 < (byHeight ? height : width); ++i2) {
                ILogicalTable cell = byHeight ? (ILogicalTable)dataTable.getRow(i2) : (ILogicalTable)((ILogicalTable)dataTable.getColumn(i2)).transpose();
                String cellValue = cell.getCell(0, 0).getStringValue();
                if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                    Object parameter = RuleRowHelper.loadSingleParam(paramType, paramName, ruleName, cell, openlAdaptor);
                    if (parameter instanceof CompositeMethod) {
                        hasFormulas = true;
                    }
                    values.add(parameter);
                    continue;
                }
                values.add(EMPTY_CELL);
            }
            while (values.size() > 0 && values.get(values.size() - 1) == EMPTY_CELL) {
                values.remove(values.size() - 1);
            }
            for (i2 = 0; i2 < values.size(); ++i2) {
                if (values.get(i2) != EMPTY_CELL) continue;
                values.set(i2, paramType.nullObject());
            }
            if (hasFormulas) {
                return new ArrayHolder(paramType, values.toArray(new Object[0]));
            }
            IAggregateInfo aggregateInfo = aggregateType.getAggregateInfo();
            Object array = aggregateInfo.makeIndexedAggregate(paramType, values.size());
            IOpenIndex index = aggregateInfo.getIndex(aggregateType);
            for (int i3 = 0; i3 < values.size(); ++i3) {
                index.setValue(array, (Object)i3, values.get(i3));
            }
            return array;
        }
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (i = 0; i < width; ++i) {
            Object[] values1 = new Object[height];
            boolean emptyRow = true;
            for (int j = 0; j < height; ++j) {
                ILogicalTable cell = (ILogicalTable)dataTable.getSubtable(i, j, 1, 1);
                String cellValue = cell.getCell(0, 0).getStringValue();
                if (!StringUtils.isEmpty((CharSequence)cellValue)) {
                    emptyRow = false;
                    Object parameter = RuleRowHelper.loadSingleParam(paramType.getComponentClass(), paramName, ruleName, cell, openlAdaptor);
                    if (parameter instanceof CompositeMethod) {
                        hasFormulas = true;
                    }
                    values1[j] = parameter;
                    continue;
                }
                values1[j] = null;
            }
            if (emptyRow) {
                values.add(EMPTY_ROW);
                continue;
            }
            values.add(values1);
        }
        while (values.size() > 0 && values.get(values.size() - 1) == EMPTY_ROW) {
            values.remove(values.size() - 1);
        }
        for (i = 0; i < values.size(); ++i) {
            if (values.get(i) != EMPTY_ROW) continue;
            values.set(i, new Object[dataTable.getHeight()]);
        }
        if (hasFormulas) {
            return new ArrayHolder(paramType, (Object[][])values.toArray((T[])new Object[0][0]));
        }
        IAggregateInfo aggregateInfo = aggregateType.getAggregateInfo();
        Object array = aggregateInfo.makeIndexedAggregate(paramType, values.size());
        IOpenIndex index = aggregateInfo.getIndex(aggregateType);
        for (int i4 = 0; i4 < values.size(); ++i4) {
            IAggregateInfo aggregateInfo1 = paramType.getAggregateInfo();
            Object array1 = aggregateInfo1.makeIndexedAggregate(paramType.getComponentClass(), dataTable.getHeight());
            IOpenIndex index1 = aggregateInfo1.getIndex(paramType);
            for (int j = 0; j < ((Object[])values.get(i4)).length; ++j) {
                Object v = ((Object[])values.get(i4))[j];
                index1.setValue(array1, (Object)j, v != null ? v : paramType.getComponentClass().nullObject());
            }
            index.setValue(array, (Object)i4, array1);
        }
        return array;
    }
}

