/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openl.binding.IBindingContext;
import org.openl.exception.OpenLCompilationException;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DatatypeArrayMultiRowElementContext;
import org.openl.rules.data.FieldChain;
import org.openl.rules.data.ForeignKeyColumnDescriptor;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITable;
import org.openl.rules.data.ITableModel;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.table.xls.XlsUrlParser;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.util.BiMap;
import org.openl.util.MessageUtils;
import org.openl.vm.IRuntimeEnv;

public class Table
implements ITable {
    private ILogicalTable logicalTable;
    private ITableModel dataModel;
    private String tableName;
    private TableSyntaxNode tableSyntaxNode;
    private Object dataArray;
    private List<DatatypeArrayMultiRowElementContext> dataContextCache;
    private BiMap<Integer, Object> rowIndexMap;
    private BiMap<Integer, String> primaryIndexMap;
    private Map<Integer, Integer> dataIdxToTableRowNum;
    private XlsNodeTypes xlsNodeType;
    private String uri;

    public Table(ITableModel dataModel, ILogicalTable data) {
        this.dataModel = dataModel;
        this.logicalTable = data;
    }

    public Table(String tableName, TableSyntaxNode tsn) {
        this.tableName = tableName;
        this.tableSyntaxNode = tsn;
        this.xlsNodeType = tsn.getNodeType();
        this.uri = tsn.getUri();
    }

    @Override
    public void clearOddDataForExecutionMode() {
        this.tableSyntaxNode = null;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public XlsNodeTypes getXlsNodeType() {
        return this.xlsNodeType;
    }

    @Override
    public void setData(ILogicalTable dataWithHeader) {
        this.logicalTable = dataWithHeader;
    }

    @Override
    public ILogicalTable getData() {
        return this.logicalTable;
    }

    @Override
    public void setModel(ITableModel dataModel) {
        this.dataModel = dataModel;
    }

    @Override
    public String getColumnDisplay(int n) {
        return this.dataModel.getDescriptor(n).getDisplayName();
    }

    @Override
    public int getColumnIndex(String columnName) {
        for (ColumnDescriptor descriptor : this.dataModel.getDescriptors()) {
            if (!descriptor.getName().equals(columnName)) continue;
            return descriptor.getColumnIdx();
        }
        return -1;
    }

    @Override
    public String getColumnName(int n) {
        ColumnDescriptor columnDescriptor = this.dataModel.getDescriptor(n);
        return columnDescriptor != null ? columnDescriptor.getName() : null;
    }

    @Override
    public IOpenClass getColumnType(int n) {
        ColumnDescriptor descriptor = this.dataModel.getDescriptor(n);
        if (!descriptor.isConstructor()) {
            return descriptor.getType();
        }
        return null;
    }

    @Override
    public Object getData(int row) {
        return Array.get(this.dataArray, row);
    }

    @Override
    public Object getDataArray() {
        return this.dataArray;
    }

    @Override
    public ITableModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public IGridTable getHeaderTable() {
        return ((ILogicalTable)this.logicalTable.getRow(0)).getSource();
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public int getNumberOfColumns() {
        return this.dataModel.getDescriptors().length;
    }

    @Override
    public ColumnDescriptor getColumnDescriptor(int i) {
        return this.dataModel.getDescriptor(i);
    }

    @Override
    public int getNumberOfRows() {
        return this.logicalTable.getHeight() - 1;
    }

    @Override
    public synchronized String getPrimaryIndexKey(int row) {
        if (this.primaryIndexMap == null) {
            return null;
        }
        return (String)this.primaryIndexMap.get((Object)row);
    }

    @Override
    public Integer getRowIndex(Object target) {
        return (Integer)this.rowIndexMap.getKey(target);
    }

    @Override
    public IGridTable getRowTable(int row) {
        return ((ILogicalTable)this.logicalTable.getRow(row + 1)).getSource();
    }

    @Override
    public int getSize() {
        return Array.getLength(this.dataArray);
    }

    @Override
    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }

    @Override
    public Object getValue(int col, int row) {
        int startRows = this.getStartRowForData();
        int idx = row - startRows;
        Object rowObject = this.rowIndexMap == null ? Array.get(this.dataArray, idx) : this.rowIndexMap.get((Object)idx);
        return this.dataModel.getDescriptor(col).getColumnValue(rowObject);
    }

    @Override
    public Map<String, Integer> makeUniqueIndex(int colIdx, IBindingContext cxt) {
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        if (this.dataIdxToTableRowNum == null || this.dataIdxToTableRowNum.isEmpty()) {
            return Collections.emptyMap();
        }
        for (Map.Entry<Integer, Integer> entry : this.dataIdxToTableRowNum.entrySet()) {
            IGridTable gridTable = ((ILogicalTable)this.logicalTable.getSubtable(colIdx, entry.getValue(), 1, 1)).getSource();
            String key = gridTable.getCell(0, 0).getStringValue();
            if (key == null) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)"Empty key in an unique index.", (IOpenSourceCodeModule)new GridCellSourceCodeModule(gridTable));
                cxt.addError(error);
                break;
            }
            if (index.containsKey(key = key.trim())) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)MessageUtils.getDuplicatedKeyIndexErrorMessage((String)key), (IOpenSourceCodeModule)new GridCellSourceCodeModule(gridTable));
                cxt.addError(error);
                break;
            }
            index.put(key, entry.getKey());
        }
        return Collections.unmodifiableMap(index);
    }

    @Override
    public List<Object> getUniqueValues(int colIdx) throws SyntaxNodeException {
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.dataIdxToTableRowNum == null || this.dataIdxToTableRowNum.isEmpty()) {
            return Collections.emptyList();
        }
        for (Map.Entry<Integer, Integer> entry : this.dataIdxToTableRowNum.entrySet()) {
            IGridTable gridTable = ((ILogicalTable)this.logicalTable.getSubtable(colIdx, entry.getValue(), 1, 1)).getSource();
            Object value = gridTable.getCell(0, 0).getObjectValue();
            if (value == null) {
                throw SyntaxNodeExceptionUtils.createError((String)"Empty key in an unique index.", (IOpenSourceCodeModule)new GridCellSourceCodeModule(gridTable));
            }
            if (values.contains(value)) {
                throw SyntaxNodeExceptionUtils.createError((String)MessageUtils.getDuplicatedKeyIndexErrorMessage((String)String.valueOf(value)), (IOpenSourceCodeModule)new GridCellSourceCodeModule(gridTable));
            }
            values.add(value);
        }
        return values;
    }

    @Override
    public void populate(IDataBase dataBase, IBindingContext bindingContext) throws Exception {
        int rows = this.logicalTable.getHeight();
        int columns = this.logicalTable.getWidth();
        boolean hasError = this.validateOnErrors(bindingContext, dataBase, columns);
        if (hasError) {
            return;
        }
        int dataArrayLength = Array.getLength(this.dataArray);
        for (int i = 0; i < dataArrayLength; ++i) {
            IRuntimeEnv env = bindingContext.getOpenL().getVm().getRuntimeEnv();
            Object target = Array.get(this.dataArray, i);
            env.pushThis(target);
            int rowNum = this.dataIdxToTableRowNum.get(i);
            int height = i + 1 < dataArrayLength ? this.dataIdxToTableRowNum.get(i + 1) - rowNum : rows - rowNum;
            DatatypeArrayMultiRowElementContext context = this.getCachedContext(i);
            if (context == null) {
                context = new DatatypeArrayMultiRowElementContext();
            }
            env.pushLocalFrame(new Object[]{context});
            for (int j = 0; j < columns; ++j) {
                ForeignKeyColumnDescriptor fkDescriptor;
                ColumnDescriptor descriptor = this.dataModel.getDescriptor(j);
                if (!(descriptor instanceof ForeignKeyColumnDescriptor) || !(fkDescriptor = (ForeignKeyColumnDescriptor)descriptor).isReference()) continue;
                try {
                    if (descriptor.isConstructor()) {
                        target = fkDescriptor.getLiteralByForeignKey(this.dataModel.getType(), (ILogicalTable)this.logicalTable.getSubtable(j, rowNum, 1, height), dataBase, bindingContext);
                        continue;
                    }
                    fkDescriptor.populateLiteralByForeignKey(target, (ILogicalTable)this.logicalTable.getSubtable(j, rowNum, 1, height), dataBase, bindingContext, env);
                    continue;
                }
                catch (SyntaxNodeException e) {
                    bindingContext.addError(e);
                }
            }
            env.popLocalFrame();
            env.popThis();
        }
        this.dataContextCache = null;
    }

    private boolean validateOnErrors(IBindingContext bindingContext, IDataBase dataBase, int columns) {
        boolean hasError = false;
        for (int j = 0; j < columns; ++j) {
            ForeignKeyColumnDescriptor fkDescriptor;
            SyntaxNodeException ex = null;
            ColumnDescriptor descriptor = this.dataModel.getDescriptor(j);
            if (descriptor instanceof ForeignKeyColumnDescriptor && (fkDescriptor = (ForeignKeyColumnDescriptor)descriptor).isReference()) {
                IdentifierNode foreignKeyTable = fkDescriptor.getForeignKeyTable();
                IdentifierNode foreignKey = fkDescriptor.getForeignKey();
                String foreignKeyTableName = foreignKeyTable.getIdentifier();
                ITable foreignTable = dataBase.getTable(foreignKeyTableName);
                if (foreignTable == null) {
                    String message = MessageUtils.getTableNotFoundErrorMessage((String)foreignKeyTableName);
                    ex = SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)foreignKeyTable);
                } else if (foreignKey != null) {
                    String columnName = foreignKey.getIdentifier();
                    int foreignKeyIndex = foreignTable.getColumnIndex(columnName);
                    if (foreignKeyIndex == -1) {
                        String message = MessageUtils.getColumnNotFoundErrorMessage((String)columnName);
                        ex = SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)foreignKey);
                    } else {
                        foreignTable.getColumnDescriptor(foreignKeyIndex).getUniqueIndex(foreignTable, foreignKeyIndex, bindingContext);
                    }
                } else {
                    SyntaxNodeException[] errors;
                    int foreignKeyIndex = 0;
                    ITableModel dataModel = foreignTable.getDataModel();
                    ColumnDescriptor d1 = dataModel.getDescriptors()[0];
                    if (!d1.isPrimaryKey()) {
                        ColumnDescriptor firstColDescriptor = dataModel.getDescriptor(0);
                        if (firstColDescriptor.isPrimaryKey()) {
                            foreignKeyIndex = descriptor.getColumnIdx();
                        }
                        foreignTable.getColumnDescriptor(foreignKeyIndex).getUniqueIndex(foreignTable, foreignKeyIndex, bindingContext);
                    }
                    for (SyntaxNodeException error : errors = bindingContext.getErrors()) {
                        String sourceLocation = error.getSourceLocation();
                        if (sourceLocation == null || !foreignTable.getTableSyntaxNode().getUriParser().intersects(new XlsUrlParser(sourceLocation))) continue;
                        String message = MessageUtils.getForeignTableCompilationErrorsMessage((String)foreignKeyTableName);
                        ex = SyntaxNodeExceptionUtils.createError((String)message, null, (ISyntaxNode)foreignKeyTable);
                    }
                }
            }
            if (ex == null) continue;
            bindingContext.addError(ex);
            hasError = true;
        }
        return hasError;
    }

    @Override
    public void preLoad(OpenlToolAdaptor openlAdapter) throws Exception {
        int rows = this.logicalTable.getHeight();
        int startRow = this.getStartRowForData();
        if (this.tableSyntaxNode.getNodeType() == XlsNodeTypes.XLS_DATA && this.isSupportMultirow()) {
            ArrayList<Object> resultContainer = new ArrayList<Object>();
            ArrayList<DatatypeArrayMultiRowElementContext> dataContexts = new ArrayList<DatatypeArrayMultiRowElementContext>();
            this.processMultirowDataTable(resultContainer, openlAdapter, dataContexts, startRow, rows);
            this.dataArray = Array.newInstance(this.dataModel.getInstanceClass(), resultContainer.size());
            for (int i = 0; i < resultContainer.size(); ++i) {
                Array.set(this.dataArray, i, resultContainer.get(i));
            }
            this.dataContextCache = Collections.unmodifiableList(dataContexts);
        } else {
            this.dataArray = Array.newInstance(this.dataModel.getInstanceClass(), rows - startRow);
            for (int rowNum = startRow; rowNum < rows; ++rowNum) {
                this.processRow(openlAdapter, startRow, rowNum);
            }
        }
    }

    private boolean isSupportMultirow() {
        if (this.dataModel.getDescriptors().length > 0) {
            for (ColumnDescriptor descriptor : this.dataModel.getDescriptors()) {
                if (!descriptor.isSupportMultirows()) continue;
                return true;
            }
        }
        return false;
    }

    private void processMultirowDataTable(List<Object> resultContainer, OpenlToolAdaptor openlAdapter, List<DatatypeArrayMultiRowElementContext> dataContexts, int startRow, int rows) throws OpenLCompilationException {
        TreeMap<ColumnDescriptor.ColumnGroupKey, List> descriptorGroups = new TreeMap<ColumnDescriptor.ColumnGroupKey, List>();
        for (ColumnDescriptor descriptor : this.dataModel.getDescriptors()) {
            ColumnDescriptor.ColumnGroupKey key = descriptor.getGroupKey();
            List descriptorsByKey = descriptorGroups.computeIfAbsent(key, k -> new ArrayList());
            if (descriptor.getField() == null || descriptor.isReference()) continue;
            descriptorsByKey.add(descriptor);
        }
        try {
            this.parseRowsAndPopulateRootLiteral(resultContainer, dataContexts, new ArrayList<List<ColumnDescriptor>>(descriptorGroups.values()), openlAdapter, startRow, rows);
        }
        catch (SyntaxNodeException e) {
            openlAdapter.getBindingContext().addError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRowsAndPopulateRootLiteral(List<Object> resultContainer, List<DatatypeArrayMultiRowElementContext> dataContexts, List<List<ColumnDescriptor>> allDescriptors, OpenlToolAdaptor openlAdapter, int startRow, int rows) throws OpenLCompilationException {
        List<ColumnDescriptor> descriptors = allDescriptors.get(0);
        Object[][] rowValues = new Object[rows - startRow][descriptors.size()];
        for (int rowNum = startRow; rowNum < rows; ++rowNum) {
            for (int colNum = 0; colNum < descriptors.size(); ++colNum) {
                ColumnDescriptor descriptor = descriptors.get(colNum);
                ILogicalTable valuesTable = LogicalTableHelper.make1ColumnTable((ILogicalTable)this.logicalTable.getSubtable(descriptor.getColumnIdx(), rowNum, 1, 1));
                Object prevRes = ColumnDescriptor.PREV_RES_EMPTY;
                int width = valuesTable.getSource().getWidth();
                for (int i = 0; i < valuesTable.getSource().getHeight(); ++i) {
                    ILogicalTable logicalTable = LogicalTableHelper.make1ColumnTable((ILogicalTable)LogicalTableHelper.logicalTable((IGridTable)valuesTable.getSource().getSubtable(0, i, width, i + 1)).getSubtable(0, 0, width, 1));
                    Object res = descriptor.parseCellValue(logicalTable, openlAdapter);
                    if (descriptor.isSameValue(res, prevRes)) continue;
                    rowValues[rowNum - startRow][colNum] = res;
                    prevRes = res;
                }
            }
        }
        IRuntimeEnv env = openlAdapter.getOpenl().getVm().getRuntimeEnv();
        for (int rowNum = 0; rowNum < rowValues.length; ++rowNum) {
            int height = 1;
            Object[] thisRow = rowValues[rowNum];
            if (thisRow == null) continue;
            Object literal = this.createLiteral();
            this.addToRowIndex(rowNum, literal);
            for (int j = rowNum + 1; j < rowValues.length; ++j) {
                Object[] nextRow = rowValues[j];
                boolean isSameRow = true;
                for (int k = 0; k < thisRow.length && (isSameRow = descriptors.get(k).isSameValue(nextRow[k], thisRow[k])); ++k) {
                }
                if (!isSameRow) break;
                rowValues[j] = null;
                this.addToRowIndex(j, literal);
                ++height;
            }
            DatatypeArrayMultiRowElementContext context = new DatatypeArrayMultiRowElementContext();
            env.pushLocalFrame(new Object[]{context});
            env.pushThis(literal);
            try {
                for (List<ColumnDescriptor> allDescriptor : allDescriptors) {
                    this.parseRowsAndPopulateLiteral(literal, allDescriptor, openlAdapter, env, rowNum + startRow, height);
                }
                this.bindDataIndexWithTableRowNum(resultContainer.size(), rowNum + startRow);
                resultContainer.add(literal);
                dataContexts.add(context);
                continue;
            }
            finally {
                env.popThis();
                env.popLocalFrame();
            }
        }
    }

    private void parseRowsAndPopulateLiteral(Object literal, List<ColumnDescriptor> descriptors, OpenlToolAdaptor openlAdapter, IRuntimeEnv env, int rowNum, int height) throws OpenLCompilationException {
        if (descriptors.isEmpty()) {
            return;
        }
        DatatypeArrayMultiRowElementContext context = (DatatypeArrayMultiRowElementContext)env.getLocalFrame()[0];
        Object[][] rowValues = null;
        for (int colNum = 0; colNum < descriptors.size(); ++colNum) {
            ColumnDescriptor descriptor = descriptors.get(colNum);
            ILogicalTable valuesTable = LogicalTableHelper.make1ColumnTable((ILogicalTable)this.logicalTable.getSubtable(descriptor.getColumnIdx(), rowNum, 1, height));
            if (rowValues == null) {
                rowValues = new Object[valuesTable.getSource().getHeight()][descriptors.size()];
            }
            int width = valuesTable.getSource().getWidth();
            for (int i = 0; i < valuesTable.getSource().getHeight(); ++i) {
                ILogicalTable logicalTable = LogicalTableHelper.make1ColumnTable((ILogicalTable)LogicalTableHelper.logicalTable((IGridTable)valuesTable.getSource().getSubtable(0, i, width, i + 1)).getSubtable(0, 0, width, 1));
                rowValues[i][colNum] = descriptor.parseCellValue(logicalTable, openlAdapter);
            }
        }
        ColumnDescriptor pkDescriptor = descriptors.get(0);
        Object prevRow = null;
        boolean shouldSkipMergingSameValues = !pkDescriptor.isPrimaryKey() && !pkDescriptor.isDeclaredClassSupportMultirow();
        for (int i = 0; i < rowValues.length; ++i) {
            int k;
            boolean isSameRow;
            void thisRow = rowValues[i];
            context.setRow(i);
            if (prevRow == null || shouldSkipMergingSameValues) {
                isSameRow = false;
            } else if (pkDescriptor.isPrimaryKey()) {
                isSameRow = pkDescriptor.isSameValue(thisRow[0], prevRow[0]);
            } else {
                isSameRow = true;
                for (k = 0; k < ((void)thisRow).length && (isSameRow = descriptors.get(k).isSameValue(thisRow[k], prevRow[k])); ++k) {
                }
            }
            context.setRowValueIsTheSameAsPrevious(isSameRow);
            for (k = 0; k < ((void)thisRow).length; ++k) {
                ColumnDescriptor descriptor = descriptors.get(k);
                void thisValue = thisRow[k];
                if (descriptor.isValuesAnArray()) {
                    Object currentValue = descriptor.getFieldValue(literal, env);
                    int thisLen = Array.getLength(thisValue);
                    if (currentValue == null || Array.getLength(currentValue) == 0) {
                        descriptor.setFieldValue(literal, thisLen == 0 ? null : thisValue, env);
                        continue;
                    }
                    if (thisLen == 0) continue;
                    int currentLen = Array.getLength(currentValue);
                    Object newArray = Array.newInstance(thisValue.getClass().getComponentType(), currentLen + thisLen);
                    System.arraycopy(currentValue, 0, newArray, 0, currentLen);
                    System.arraycopy(thisValue, 0, newArray, currentLen, thisLen);
                    descriptor.setFieldValue(literal, newArray, env);
                    continue;
                }
                descriptor.setFieldValue(literal, thisValue, env);
            }
            prevRow = thisRow;
        }
    }

    private Object createLiteral() throws OpenLCompilationException {
        if (this.dataModel.getInstanceClass().isArray()) {
            int dim = 0;
            Class<?> type = this.dataModel.getInstanceClass();
            while (type.isArray()) {
                type = type.getComponentType();
                ++dim;
            }
            return Array.newInstance(type, new int[dim]);
        }
        Object literal = this.dataModel.newInstance();
        if (literal == null) {
            throw new OpenLCompilationException(String.format("Cannot create an instance of '%s'.", this.dataModel.getName()));
        }
        return literal;
    }

    private void processRow(OpenlToolAdaptor openlAdapter, int startRow, int rowNum) throws OpenLCompilationException {
        boolean constructor = this.isConstructor();
        Object literal = null;
        int rowIndex = rowNum - startRow;
        if (!constructor) {
            literal = this.createLiteral();
            this.addToRowIndex(rowIndex, literal);
        }
        IRuntimeEnv env = openlAdapter.getOpenl().getVm().getRuntimeEnv();
        env.pushLocalFrame(new Object[]{new DatatypeArrayMultiRowElementContext()});
        boolean hasError = false;
        Set<Object> fieldWithValue = new HashSet();
        if (Objects.equals(this.tableSyntaxNode.getType(), XlsNodeTypes.XLS_TEST_METHOD.toString())) {
            hasError = Arrays.stream(this.dataModel.getDescriptors()).anyMatch(m -> m.getName().startsWith("_error_"));
            fieldWithValue = Arrays.stream(this.dataModel.getDescriptors()).filter(d -> {
                ILogicalTable lTable = (ILogicalTable)this.logicalTable.getSubtable(d.getColumnIdx(), rowNum, 1, 1);
                boolean nonEmptyResCell = lTable.getHeight() != 1 || lTable.getWidth() != 1 || lTable.getCell(0, 0).getStringValue() != null && d.getField() != null;
                return nonEmptyResCell && d.getField().getName().startsWith("_res_") && d.getField() instanceof FieldChain && ((FieldChain)d.getField()).getFields().length > 1;
            }).map(d -> {
                FieldChain fieldChain = (FieldChain)d.getField();
                return FieldChain.makeNames(Arrays.copyOfRange(fieldChain.getFields(), 0, fieldChain.getFields().length - 1));
            }).collect(Collectors.toSet());
        }
        for (ColumnDescriptor columnDescriptor : this.dataModel.getDescriptors()) {
            FieldChain fieldChain;
            boolean hasValue = false;
            if (columnDescriptor.getField() instanceof FieldChain && (fieldChain = (FieldChain)columnDescriptor.getField()).getFields().length > 1) {
                String fieldName = FieldChain.makeNames(Arrays.copyOfRange(fieldChain.getFields(), 0, fieldChain.getFields().length - 1));
                hasValue = fieldWithValue.contains(fieldName);
            }
            literal = this.processColumn(columnDescriptor, openlAdapter, constructor, rowNum, literal, env, hasError, hasValue);
        }
        env.popLocalFrame();
        if (literal == null) {
            literal = this.dataModel.getType().nullObject();
        }
        int idx = rowNum - startRow;
        this.bindDataIndexWithTableRowNum(idx, rowNum);
        Array.set(this.dataArray, idx, literal);
    }

    private void bindDataIndexWithTableRowNum(Integer idx, Integer rowNum) {
        if (this.dataIdxToTableRowNum == null) {
            this.dataIdxToTableRowNum = new HashMap<Integer, Integer>();
        }
        this.dataIdxToTableRowNum.put(idx, rowNum);
    }

    private Object processColumn(ColumnDescriptor columnDescriptor, OpenlToolAdaptor openlAdapter, boolean constructor, int rowNum, Object literal, IRuntimeEnv env, boolean hasError, boolean hasValue) throws SyntaxNodeException {
        if (columnDescriptor != null && !columnDescriptor.isReference()) {
            if (constructor) {
                literal = columnDescriptor.getLiteral(this.dataModel.getType(), (ILogicalTable)this.logicalTable.getSubtable(columnDescriptor.getColumnIdx(), rowNum, 1, 1), openlAdapter);
            } else {
                try {
                    ILogicalTable lTable = (ILogicalTable)this.logicalTable.getSubtable(columnDescriptor.getColumnIdx(), rowNum, 1, 1);
                    if (lTable.getHeight() != 1 || lTable.getWidth() != 1 || lTable.getCell(0, 0).getStringValue() != null) {
                        return columnDescriptor.populateLiteral(literal, lTable, openlAdapter, env, false);
                    }
                    if (columnDescriptor.getField() != null && columnDescriptor.getField().getName().startsWith("_res_") && !columnDescriptor.isValuesAnArray() && !hasError && hasValue) {
                        return columnDescriptor.populateLiteral(literal, lTable, openlAdapter, env, true);
                    }
                }
                catch (SyntaxNodeException ex) {
                    openlAdapter.getBindingContext().addError(ex);
                }
            }
        }
        return literal;
    }

    @Override
    public synchronized void setPrimaryIndexKey(int row, String value) {
        Integer oldRow;
        if (this.primaryIndexMap == null) {
            this.primaryIndexMap = new BiMap();
        }
        if ((oldRow = (Integer)this.primaryIndexMap.getKey((Object)value)) != null && row != oldRow) {
            throw new OpenLRuntimeException(String.format("Duplicated key: %s in rows %s and %s.", value, oldRow, row));
        }
        this.primaryIndexMap.put((Object)row, (Object)value);
    }

    @Override
    public Object findObject(int columnIndex, String skey, IBindingContext cxt) {
        ColumnDescriptor descriptor = this.dataModel.getDescriptor(columnIndex);
        Map<String, Integer> index = descriptor.getUniqueIndex(this, columnIndex, cxt);
        Integer found = index.get(skey);
        if (found == null) {
            return null;
        }
        return Array.get(this.dataArray, found);
    }

    private void addToRowIndex(int rowIndex, Object target) {
        if (this.rowIndexMap == null) {
            this.rowIndexMap = new BiMap();
        }
        this.rowIndexMap.put((Object)rowIndex, target);
    }

    private int getStartRowForData() {
        if (this.dataModel.hasColumnTitleRow()) {
            return 1;
        }
        return 0;
    }

    private boolean isConstructor() {
        for (ColumnDescriptor columnDescriptor : this.dataModel.getDescriptors()) {
            if (!columnDescriptor.isConstructor()) continue;
            return true;
        }
        return false;
    }

    private DatatypeArrayMultiRowElementContext getCachedContext(int i) {
        if (this.dataContextCache == null || this.dataContextCache.isEmpty()) {
            return null;
        }
        return this.dataContextCache.get(i);
    }
}

