/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.base.INamedThing;
import org.openl.binding.IBindingContext;
import org.openl.binding.IMemberBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.component.ComponentBindingContext;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLManager;
import org.openl.rules.binding.RulesModuleBindingContextHelper;
import org.openl.rules.dt.DTColumnsDefinitionField;
import org.openl.rules.dt.DecisionTableUtils;
import org.openl.rules.dt.data.DecisionTableDataType;
import org.openl.rules.dt.element.ConditionHelper;
import org.openl.rules.fuzzy.OpenLFuzzyUtils;
import org.openl.rules.lang.xls.binding.ATableBoundNode;
import org.openl.rules.lang.xls.binding.DTColumnsDefinition;
import org.openl.rules.lang.xls.binding.ExpressionIdentifier;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DtColumnsDefinitionMetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.table.ICell;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.code.IParsedCode;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.MethodSignature;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public abstract class ADtColumnsDefinitionTableBoundNode
extends ATableBoundNode
implements IMemberBoundNode {
    private String tableName;
    private final OpenL openl;
    private IBindingContext bindingContext;
    private XlsModuleOpenClass xlsModuleOpenClass;
    private final Map<DTColumnsDefinition, PreBindDetails> definitions = new HashMap<DTColumnsDefinition, PreBindDetails>();
    private boolean initialized = false;
    private static final int[] DEFAULT_HEADER_INDEXES = new int[]{0, 1, 2, 3};
    private static final int INPUTS_INDEX = 0;
    private static final int EXPRESSION_INDEX = 1;
    private static final int PARAMETER_INDEX = 2;
    private static final int TITLE_INDEX = 3;

    public ADtColumnsDefinitionTableBoundNode(TableSyntaxNode tableSyntaxNode, OpenL openl) {
        super(tableSyntaxNode);
        this.openl = Objects.requireNonNull(openl, "openl cannot be null");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preBind(XlsModuleOpenClass module, IBindingContext bindingContext) {
        this.xlsModuleOpenClass = module;
        this.bindingContext = Objects.requireNonNull(bindingContext, "bindingContext cannot be null");
        TableSyntaxNode tsn = this.getTableSyntaxNode();
        ILogicalTable tableBody = tsn.getTableBody();
        if (tableBody == null) {
            return;
        }
        int[] tableStructure = ADtColumnsDefinitionTableBoundNode.getTableStructure(tableBody);
        int w = tableStructure.length;
        if (w != 4 && (w = (tableStructure = ADtColumnsDefinitionTableBoundNode.getTableStructure(tableBody = (ILogicalTable)tableBody.transpose())).length) != 4) {
            BindHelper.processError((String)"Wrong table structure: Expected 4 columns table: <Inputs> <Expression> <Parameter> <Title>.", (ISyntaxNode)this.getTableSyntaxNode(), (IBindingContext)bindingContext);
            return;
        }
        int i = 0;
        int[] headerIndexes = this.getHeaderIndexes(tableBody, tableStructure);
        if (headerIndexes != DEFAULT_HEADER_INDEXES) {
            i = tableBody.getSource().getCell(0, 0).getHeight();
        } else {
            ILogicalTable tableBodyT = (ILogicalTable)tableBody.transpose();
            int[] tableStructureT = ADtColumnsDefinitionTableBoundNode.getTableStructure(tableBodyT);
            if (tableStructureT.length == 4) {
                int[] headerIndexesT = this.getHeaderIndexes(tableBodyT, tableStructureT);
                i = tableBodyT.getSource().getCell(0, 0).getHeight();
                tableBody = tableBodyT;
                tableStructure = tableStructureT;
                headerIndexes = headerIndexesT;
            }
        }
        int h = tableBody.getSource().getHeight();
        ILogicalTable tableBody1 = tableBody;
        int[] tableStructure1 = tableStructure;
        int[] headerIndexes1 = headerIndexes;
        while (i < h) {
            IOpenMethodHeader header;
            String signatureCode1 = tableBody.getSource().getCell(tableStructure[headerIndexes[0]], i).getStringValue();
            ICell inputsCell = tableBody.getSource().getCell(tableStructure[headerIndexes[0]], i);
            if (StringUtils.isEmpty((CharSequence)signatureCode1)) {
                signatureCode1 = "";
            }
            String signatureCode = signatureCode1;
            boolean finished = false;
            String prefix = JavaOpenClass.VOID.getName() + " " + RandomStringUtils.random((int)16, (boolean)true, (boolean)false) + "(";
            String headerCode = prefix + signatureCode + ")";
            boolean inputParametersCompilationFailed = false;
            try {
                bindingContext.pushErrors();
                StringSourceCodeModule headerCodeSourceCodeModule = new StringSourceCodeModule(headerCode, null);
                header = OpenLManager.makeMethodHeader((OpenL)this.getOpenl(), (IOpenSourceCodeModule)headerCodeSourceCodeModule, (IBindingContext)bindingContext);
                if (header == null) {
                    inputParametersCompilationFailed = true;
                } else if (!bindingContext.isExecutionMode()) {
                    this.addMetaInfoForInputs(header, inputsCell, headerCode, prefix.length());
                }
            }
            finally {
                bindingContext.popErrors();
            }
            if (inputParametersCompilationFailed) {
                IGridTable pCodeTable = (IGridTable)tableBody1.getSource().getSubtable(tableStructure[headerIndexes[0]], i, 1, 1);
                GridCellSourceCodeModule pGridCellSourceCodeModule = new GridCellSourceCodeModule(pCodeTable, bindingContext);
                BindHelper.processError((String)"Invalid input parameters.", (IOpenSourceCodeModule)pGridCellSourceCodeModule, (IBindingContext)bindingContext);
            }
            IGridTable expressionTable = (IGridTable)tableBody.getSource().getSubtable(tableStructure[headerIndexes[1]], i, 1, 1);
            ICell expressionCell = tableBody.getSource().getCell(tableStructure[headerIndexes[1]], i);
            int j = 0;
            int j1 = 0;
            HashMap<String, List<IParameterDeclaration>> parameters = new HashMap<String, List<IParameterDeclaration>>();
            ArrayList<IParameterDeclaration> parametersForMergedTitle = new ArrayList<IParameterDeclaration>();
            HashSet<String> uniqueSetOfParameters = new HashSet<String>();
            HashSet<String> uniqueSetOfTitles = new HashSet<String>();
            String title = null;
            Boolean singleParameter = null;
            GridCellSourceCodeModule pGridCellSourceCodeModule = null;
            int d = expressionTable.getCell(0, 0).getHeight();
            while (j < d) {
                String errMsg;
                if (pGridCellSourceCodeModule != null && parametersForMergedTitle.size() == 1 && parametersForMergedTitle.get(0) == null) {
                    String errMsg2 = "Parameter cell format: <type> or <type> <name>";
                    BindHelper.processError((String)errMsg2, pGridCellSourceCodeModule, (IBindingContext)bindingContext);
                    finished = true;
                    break;
                }
                IGridTable pCodeTable = (IGridTable)tableBody1.getSource().getSubtable(tableStructure1[headerIndexes1[2]], i + j, 1, 1);
                if (singleParameter == null) {
                    singleParameter = j + pCodeTable.getCell(0, 0).getHeight() >= d;
                }
                pGridCellSourceCodeModule = new GridCellSourceCodeModule(pCodeTable, bindingContext);
                IParameterDeclaration parameterDeclaration = null;
                String code = pGridCellSourceCodeModule.getCode();
                if (StringUtils.isNotBlank((CharSequence)code) && (parameterDeclaration = OpenLManager.makeParameterDeclaration((OpenL)this.openl, (IOpenSourceCodeModule)pGridCellSourceCodeModule, (IBindingContext)bindingContext)) == null) {
                    errMsg = "Parameter cell format: <type> or <type> <name>";
                    BindHelper.processError((String)errMsg, (IOpenSourceCodeModule)pGridCellSourceCodeModule, (IBindingContext)bindingContext);
                    finished = true;
                    break;
                }
                if (!parametersForMergedTitle.isEmpty() && parameterDeclaration == null) {
                    errMsg = "Parameter cell format: <type> or <type> <name>";
                    BindHelper.processError((String)errMsg, (IOpenSourceCodeModule)pGridCellSourceCodeModule, (IBindingContext)bindingContext);
                    finished = true;
                    break;
                }
                parametersForMergedTitle.add(parameterDeclaration);
                if (parameterDeclaration != null) {
                    if (parameterDeclaration.getName() != null) {
                        if (uniqueSetOfParameters.contains(parameterDeclaration.getName())) {
                            String errorMessage = "Parameter '" + parameterDeclaration.getName() + "' is already defined.";
                            BindHelper.processError((String)errorMessage, (IOpenSourceCodeModule)pGridCellSourceCodeModule, (IBindingContext)bindingContext);
                            finished = true;
                            break;
                        }
                        uniqueSetOfParameters.add(parameterDeclaration.getName());
                    }
                    if (!bindingContext.isExecutionMode()) {
                        ICell parameterCell = tableBody1.getSource().getCell(tableStructure1[headerIndexes1[2]], i + j);
                        this.addMetaInfoForParameter(parameterDeclaration, parameterCell);
                    }
                }
                if (j1 <= j) {
                    GridCellSourceCodeModule tGridCellSourceCodeModule;
                    IGridTable tCodeTable = (IGridTable)tableBody1.getSource().getSubtable(tableStructure1[headerIndexes1[3]], i + j, 1, 1);
                    String title1 = tCodeTable.getCell(0, 0).getStringValue();
                    if (StringUtils.isEmpty((CharSequence)title1)) {
                        tGridCellSourceCodeModule = new GridCellSourceCodeModule(tCodeTable, bindingContext);
                        BindHelper.processError((String)"Title cannot be empty.", (IOpenSourceCodeModule)tGridCellSourceCodeModule, (IBindingContext)bindingContext);
                        finished = true;
                        break;
                    }
                    title = OpenLFuzzyUtils.toTokenString(title1);
                    if (uniqueSetOfTitles.contains(title)) {
                        tGridCellSourceCodeModule = new GridCellSourceCodeModule(tCodeTable, bindingContext);
                        BindHelper.processError((String)("Title '" + title1 + "' is already defined."), (IOpenSourceCodeModule)tGridCellSourceCodeModule, (IBindingContext)bindingContext);
                        finished = true;
                        break;
                    }
                    uniqueSetOfTitles.add(title);
                    j1 += tCodeTable.getCell(0, 0).getHeight();
                }
                if (j1 > (j += pCodeTable.getCell(0, 0).getHeight()) && j < d) continue;
                parameters.put(title, parametersForMergedTitle);
                parametersForMergedTitle = new ArrayList();
            }
            if (!finished && header != null) {
                this.createAndAddDefinition(header, parameters, expressionTable, expressionCell);
            }
            i += expressionTable.getCell(0, 0).getHeight();
        }
    }

    public void addTo(ModuleOpenClass openClass) {
        if (!this.initialized) {
            ComponentBindingContext dtHeaderBindingContext = this.buildDtHeaderBindingContext(this.bindingContext);
            for (Map.Entry<DTColumnsDefinition, PreBindDetails> entry : this.definitions.entrySet()) {
                this.compileAndAddDefinition(entry.getKey(), entry.getValue(), dtHeaderBindingContext, this.bindingContext);
            }
            this.initialized = true;
        }
    }

    private ComponentBindingContext buildDtHeaderBindingContext(IBindingContext bindingContext) {
        DecisionTableDataType decisionTableDataType = new DecisionTableDataType(null, "DecisionTableDataType", this.openl, true);
        for (DTColumnsDefinition dtColumnsDefinition : this.getXlsModuleOpenClass().getXlsDefinitions().getDtColumnsDefinitions()) {
            for (String title : dtColumnsDefinition.getTitles()) {
                for (IParameterDeclaration parameter : dtColumnsDefinition.getParameters(title)) {
                    if (parameter == null || parameter.getName() == null) continue;
                    DTColumnsDefinitionField dtColumnsDefinitionField = new DTColumnsDefinitionField(parameter.getName(), parameter.getType(), (IOpenClass)decisionTableDataType, dtColumnsDefinition, title);
                    decisionTableDataType.addDecisionTableField(dtColumnsDefinitionField);
                }
            }
        }
        return new ComponentBindingContext(bindingContext, (ComponentOpenClass)decisionTableDataType);
    }

    public OpenL getOpenl() {
        return this.openl;
    }

    protected Object evaluateRuntime(IRuntimeEnv env) {
        return null;
    }

    protected XlsModuleOpenClass getXlsModuleOpenClass() {
        return this.xlsModuleOpenClass;
    }

    public IOpenClass getType() {
        return JavaOpenClass.VOID;
    }

    public void removeDebugInformation(IBindingContext cxt) {
        this.definitions.clear();
    }

    protected abstract DTColumnsDefinition createDefinition(IOpenMethodHeader var1, String var2, List<ExpressionIdentifier> var3, Map<String, List<IParameterDeclaration>> var4);

    protected final void createAndAddDefinition(IOpenMethodHeader header, Map<String, List<IParameterDeclaration>> parameters, IGridTable expressionTable, ICell expressionCell) {
        GridCellSourceCodeModule expressionCellSourceCodeModule = new GridCellSourceCodeModule(expressionTable, this.bindingContext);
        IParsedCode parsedCode = this.openl.getParser().parseAsMethodBody((IOpenSourceCodeModule)expressionCellSourceCodeModule);
        DTColumnsDefinition dtColumnsDefinition = this.createDefinition(header, expressionCell.getStringValue() != null ? expressionCell.getStringValue() : "", parsedCode.getErrors().length == 0 ? DecisionTableUtils.extractIdentifiers(parsedCode.getTopNode()) : Collections.emptyList(), parameters);
        dtColumnsDefinition.setCompositeMethodInitializer(() -> this.addTo(this.getXlsModuleOpenClass()));
        this.definitions.put(dtColumnsDefinition, new PreBindDetails(parsedCode, expressionCellSourceCodeModule, expressionCell, header));
        this.getXlsModuleOpenClass().getXlsDefinitions().addDtColumnsDefinition(dtColumnsDefinition);
    }

    private int[] getHeaderIndexes(ILogicalTable tableBody, int[] tableStructure) {
        int[] headerIndexes = new int[4];
        int k = 0;
        for (int j = 0; j < tableStructure.length; ++j) {
            String d = tableBody.getSource().getCell(tableStructure[j], 0).getStringValue();
            if ("Title".equalsIgnoreCase(d)) {
                headerIndexes[3] = j;
                ++k;
                continue;
            }
            if ("Parameter".equalsIgnoreCase(d)) {
                headerIndexes[2] = j;
                ++k;
                continue;
            }
            if ("Expression".equalsIgnoreCase(d)) {
                headerIndexes[1] = j;
                ++k;
                continue;
            }
            if (!"Inputs".equalsIgnoreCase(d)) continue;
            headerIndexes[0] = j;
            ++k;
        }
        if (k == 4) {
            return headerIndexes;
        }
        return DEFAULT_HEADER_INDEXES;
    }

    private static int[] getTableStructure(ILogicalTable originalTable) {
        int w = originalTable.getSource().getWidth();
        int h = originalTable.getSource().getHeight();
        ArrayList<Integer> t = new ArrayList<Integer>();
        for (int i = 0; i < w; i += originalTable.getSource().getCell(i, h - 1).getWidth()) {
            t.add(i);
        }
        return ArrayUtils.toPrimitive((Integer[])t.toArray(new Integer[0]));
    }

    private boolean isParameterUsed(CompositeMethod compositeMethod, Collection<IParameterDeclaration> parameters) {
        List<ExpressionIdentifier> identifierNodes = DecisionTableUtils.extractIdentifiers(compositeMethod.getMethodBodyBoundNode() != null ? compositeMethod.getMethodBodyBoundNode().getSyntaxNode() : null);
        for (ExpressionIdentifier identifierNode : identifierNodes) {
            for (IParameterDeclaration parameterDeclaration : parameters) {
                if (parameterDeclaration == null || !Objects.equals(identifierNode.getIdentifier(), parameterDeclaration.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void finalizeBind(IBindingContext bindingContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileAndAddDefinition(DTColumnsDefinition dtColumnsDefinition, PreBindDetails preBindDetail, ComponentBindingContext dtHeaderBindingContext, IBindingContext bindingContext) {
        Set<String> externalParameters;
        CompositeMethod compositeMethod;
        IParameterDeclaration[] allParameterDeclarations = dtColumnsDefinition.getParameters().stream().filter(e -> e != null && e.getName() != null).collect(Collectors.toList()).toArray(IParameterDeclaration.EMPTY);
        MethodSignature newSignature = ((MethodSignature)preBindDetail.header.getSignature()).merge(allParameterDeclarations);
        RulesModuleBindingContextHelper.compileAllTypesInSignature((IMethodSignature)newSignature, bindingContext);
        DecisionTableDataType decisionTableDataType = (DecisionTableDataType)dtHeaderBindingContext.getComponentOpenClass();
        try {
            compositeMethod = OpenLManager.makeMethodWithUnknownType((OpenL)this.getOpenl(), (IOpenSourceCodeModule)preBindDetail.expressionCellSourceCodeModule, (String)preBindDetail.header.getName(), (IMethodSignature)newSignature, (IOpenClass)this.getXlsModuleOpenClass(), (IBindingContext)dtHeaderBindingContext);
            externalParameters = decisionTableDataType.getUsedFields().stream().map(INamedThing::getName).collect(Collectors.toSet());
        }
        finally {
            decisionTableDataType.resetLowerCasedUsedFields();
        }
        dtColumnsDefinition.setExternalParameters(externalParameters);
        dtColumnsDefinition.setCompositeMethod(compositeMethod);
        this.validate(preBindDetail.header, dtColumnsDefinition.getParameters(), preBindDetail.expressionCellSourceCodeModule, compositeMethod, bindingContext);
        if (!bindingContext.isExecutionMode()) {
            this.addMetaInfoForExpression(compositeMethod, preBindDetail.expressionCell);
        }
    }

    private void validate(IOpenMethodHeader header, Collection<IParameterDeclaration> parameters, GridCellSourceCodeModule expressionCellSourceCodeModule, CompositeMethod compositeMethod, IBindingContext bindingContext) {
        if (StringUtils.isBlank((CharSequence)expressionCellSourceCodeModule.getCode())) {
            if (this.isConditions()) {
                BindHelper.processError((String)"Expression is required for a condition.", (IOpenSourceCodeModule)expressionCellSourceCodeModule, (IBindingContext)bindingContext);
                return;
            }
            if (this.isActions()) {
                BindHelper.processError((String)"Expression is required for an action.", (IOpenSourceCodeModule)expressionCellSourceCodeModule, (IBindingContext)bindingContext);
                return;
            }
        }
        if (this.isConditions() && compositeMethod.getType().getInstanceClass() != Boolean.TYPE && compositeMethod.getType().getInstanceClass() != Boolean.class) {
            if (this.isSimplifiedSyntaxUsed(expressionCellSourceCodeModule.getCode(), header.getSignature())) {
                this.validateConditionType(compositeMethod, expressionCellSourceCodeModule, parameters, bindingContext);
            } else if (this.isParameterUsed(compositeMethod, parameters)) {
                BindHelper.processError((String)"Condition expression must return a boolean type.", (IOpenSourceCodeModule)expressionCellSourceCodeModule, (IBindingContext)bindingContext);
            } else {
                this.validateConditionType(compositeMethod, expressionCellSourceCodeModule, parameters, bindingContext);
            }
        }
    }

    private void validateConditionType(CompositeMethod compositeMethod, GridCellSourceCodeModule expressionCellSourceCodeModule, Collection<IParameterDeclaration> parameters, IBindingContext cxt) {
        IOpenClass parameterType = null;
        int parameterCount = 0;
        for (IParameterDeclaration paramType : parameters) {
            ++parameterCount;
            if (paramType == null) continue;
            if (parameterType == null) {
                parameterType = paramType.getType();
                continue;
            }
            if (Objects.equals(parameterType, paramType.getType())) continue;
            BindHelper.processError((String)"Condition expression must return a boolean type.", (IOpenSourceCodeModule)expressionCellSourceCodeModule, (IBindingContext)cxt);
            return;
        }
        if (parameterCount > 2) {
            BindHelper.processError((String)"Condition expression type is incompatible with condition parameter type.", (IOpenSourceCodeModule)expressionCellSourceCodeModule, (IBindingContext)cxt);
            return;
        }
        if (parameterType != null) {
            boolean f2;
            boolean f1 = ConditionHelper.findConditionCasts(parameterType, compositeMethod.getType(), cxt).atLeastOneExists();
            boolean bl = f2 = parameterType.isArray() && ConditionHelper.findConditionCasts(parameterType.getComponentClass(), compositeMethod.getType(), cxt).atLeastOneExists();
            if (!f1 && !f2) {
                BindHelper.processError((String)"Condition expression type is incompatible with condition parameter type.", (IOpenSourceCodeModule)expressionCellSourceCodeModule, (IBindingContext)cxt);
            }
        }
    }

    private boolean isSimplifiedSyntaxUsed(String code, IMethodSignature signature) {
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            if (!Objects.equals(code, signature.getParameterName(i))) continue;
            return true;
        }
        return false;
    }

    private void addMetaInfoForExpression(CompositeMethod compositeMethod, ICell cell) {
        MetaInfoReader metaInfoReader = this.getTableSyntaxNode().getMetaInfoReader();
        if (metaInfoReader instanceof DtColumnsDefinitionMetaInfoReader) {
            DtColumnsDefinitionMetaInfoReader dtColumnsDefinitionMetaInfoReader = (DtColumnsDefinitionMetaInfoReader)metaInfoReader;
            dtColumnsDefinitionMetaInfoReader.addExpression(cell.getAbsoluteColumn(), cell.getAbsoluteRow(), compositeMethod, cell.getStringValue());
        }
    }

    private void addMetaInfoForInputs(IOpenMethodHeader header, ICell cell, String text, int from) {
        MetaInfoReader metaInfoReader = this.getTableSyntaxNode().getMetaInfoReader();
        if (metaInfoReader instanceof DtColumnsDefinitionMetaInfoReader) {
            DtColumnsDefinitionMetaInfoReader dtColumnsDefinitionMetaInfoReader = (DtColumnsDefinitionMetaInfoReader)metaInfoReader;
            dtColumnsDefinitionMetaInfoReader.addInput(cell.getAbsoluteColumn(), cell.getAbsoluteRow(), header, text, from);
        }
    }

    private void addMetaInfoForParameter(IParameterDeclaration parameterDeclaration, ICell cell) {
        MetaInfoReader metaInfoReader = this.getTableSyntaxNode().getMetaInfoReader();
        if (metaInfoReader instanceof DtColumnsDefinitionMetaInfoReader) {
            DtColumnsDefinitionMetaInfoReader dtColumnsDefinitionMetaInfoReader = (DtColumnsDefinitionMetaInfoReader)metaInfoReader;
            dtColumnsDefinitionMetaInfoReader.addParameter(cell.getAbsoluteColumn(), cell.getAbsoluteRow(), parameterDeclaration, cell.getStringValue());
        }
    }

    protected abstract boolean isConditions();

    protected abstract boolean isActions();

    protected abstract boolean isReturns();

    private static class PreBindDetails {
        private final IParsedCode parsedCode;
        private final GridCellSourceCodeModule expressionCellSourceCodeModule;
        private final ICell expressionCell;
        private final IOpenMethodHeader header;

        public PreBindDetails(IParsedCode parsedCode, GridCellSourceCodeModule expressionCellSourceCodeModule, ICell expressionCell, IOpenMethodHeader header) {
            this.parsedCode = parsedCode;
            this.expressionCellSourceCodeModule = expressionCellSourceCodeModule;
            this.expressionCell = expressionCell;
            this.header = header;
        }
    }
}

