/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.Arrays;

abstract class DTHeader {
    final int[] methodParameterIndexes;
    final int column;
    final int row;
    final String statement;
    final int width;
    final int widthForMerge;
    final boolean horizontal;

    DTHeader(int[] methodParameterIndexes, String statement, int column, int row, int width, int widthForMerge, boolean horizontal) {
        this.methodParameterIndexes = methodParameterIndexes;
        this.statement = statement;
        this.column = column;
        this.row = row;
        this.width = width;
        this.widthForMerge = widthForMerge;
        this.horizontal = horizontal;
    }

    abstract boolean isCondition();

    boolean isHCondition() {
        return this.isCondition() && this.horizontal;
    }

    abstract boolean isAction();

    abstract boolean isReturn();

    abstract boolean isRule();

    int getWidth() {
        return this.width;
    }

    String getStatement() {
        return this.statement;
    }

    boolean isMethodParameterUsed() {
        return this.getMethodParameterIndexes().length != 0;
    }

    int[] getMethodParameterIndexes() {
        return this.methodParameterIndexes;
    }

    int getMethodParameterIndex() {
        if (this.methodParameterIndexes != null && this.methodParameterIndexes.length == 1) {
            return this.methodParameterIndexes[0];
        }
        throw new IllegalStateException();
    }

    int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public int getWidthForMerge() {
        return this.widthForMerge;
    }

    private String getTypeString() {
        if (this.isCondition()) {
            return "CONDITION";
        }
        if (this.isAction()) {
            return "ACTION";
        }
        if (this.isReturn()) {
            return "RETURN";
        }
        if (this.isRule()) {
            return "RULE";
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "DTHeader [type=" + this.getTypeString() + " methodParameterIndexes=" + Arrays.toString(this.methodParameterIndexes) + ", column=" + this.column + ", width=" + this.getWidth() + " statement=" + this.statement + "] horizontal=" + this.isHCondition();
    }
}

