/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.Objects;
import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLSystemProperties;
import org.openl.rules.binding.RulesModuleBindingContextHelper;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.DecisionTableLoader;
import org.openl.rules.lang.xls.binding.AMethodBasedNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.DecisionTableMetaInfoReader;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;

public class DecisionTableBoundNode
extends AMethodBasedNode {
    private IBindingContext bindingContext;
    private boolean initialized = false;

    public DecisionTableBoundNode(TableSyntaxNode tableSyntaxNode, OpenL openl, IOpenMethodHeader header, ModuleOpenClass module) {
        super(tableSyntaxNode, openl, header, module);
    }

    @Override
    protected ExecutableRulesMethod createMethodShell() {
        IOpenClass type = this.getType();
        int dim = 0;
        while (type.isArray()) {
            type = type.getComponentClass();
            ++dim;
        }
        boolean isTypeCustomSpreadsheetResult = type instanceof SpreadsheetResultOpenClass && OpenLSystemProperties.isCustomSpreadsheetTypesSupported(this.bindingContext.getExternalParams());
        DecisionTable decisionTable = new DecisionTable(this.getHeader(), this, isTypeCustomSpreadsheetResult);
        if (decisionTable.isTypeCustomSpreadsheetResult()) {
            decisionTable.setDim(dim);
            decisionTable.setCustomSpreadsheetResultType((CustomSpreadsheetResultOpenClass)this.bindingContext.findType("org.openl.this", "SpreadsheetResult" + decisionTable.getName()));
            try {
                RulesModuleBindingContextHelper.compileAllTypesInSignature(this.getHeader().getSignature(), this.bindingContext);
                new DecisionTableLoader().loadAndBind(this.getTableSyntaxNode(), decisionTable, this.getOpenl(), this.getModule(), this.bindingContext);
            }
            catch (Exception e) {
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((Throwable)e, (ISyntaxNode)this.getTableSyntaxNode());
                this.bindingContext.addError(error);
            }
            this.initialized = true;
        }
        return decisionTable;
    }

    @Override
    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        super.finalizeBind(bindingContext);
        if (!this.initialized && this.getDecisionTable() != null) {
            RulesModuleBindingContextHelper.compileAllTypesInSignature(this.getHeader().getSignature(), bindingContext);
            new DecisionTableLoader().loadAndBind(this.getTableSyntaxNode(), this.getDecisionTable(), this.getOpenl(), this.getModule(), bindingContext);
        }
    }

    public final DecisionTable getDecisionTable() {
        return (DecisionTable)this.getMethod();
    }

    public void updateDependency(BindingDependencies dependencies) {
        this.getDecisionTable().updateDependency(dependencies);
    }

    public void preBind(IBindingContext bindingContext) throws SyntaxNodeException {
        this.bindingContext = Objects.requireNonNull(bindingContext, "bindingContext cannot be null");
        if (!bindingContext.isExecutionMode()) {
            this.getTableSyntaxNode().setMetaInfoReader(new DecisionTableMetaInfoReader(this));
        }
    }
}

