/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.exception.AmbiguousFieldException;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.engine.OpenLManager;
import org.openl.engine.OpenLSystemProperties;
import org.openl.rules.OpenlToolAdaptor;
import org.openl.rules.binding.RuleRowHelper;
import org.openl.rules.binding.RulesModuleBindingContextHelper;
import org.openl.rules.calc.AnySpreadsheetResultOpenClass;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.element.ArrayHolder;
import org.openl.rules.dt.element.IDecisionRow;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.IStorageBuilder;
import org.openl.rules.dt.storage.StorageFactory;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;
import org.openl.rules.table.SimpleLogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.NullOpenClass;
import org.openl.types.NullParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.MethodSignature;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;

public abstract class FunctionalRow
implements IDecisionRow {
    private static final String NO_PARAM = "P";
    private static final Object[] NO_PARAMS = new Object[0];
    private final String name;
    private final int row;
    protected CompositeMethod method;
    protected IOpenClass ruleExecutionType;
    protected IParameterDeclaration[] params;
    protected BitSet paramInitialized;
    protected Set<String> paramsUniqueNames;
    protected IStorage<?>[] storage;
    private ILogicalTable decisionTable;
    private ILogicalTable paramsTable;
    private ILogicalTable codeTable;
    private ILogicalTable infoTable;
    private ILogicalTable presentationTable;
    private final DTScale.RowScale scale;
    private int noParamsIndex = 0;
    private Boolean hasFormulas = null;

    FunctionalRow(String name, int row, ILogicalTable decisionTable, DTScale.RowScale scale) {
        this.name = name;
        this.row = row;
        this.decisionTable = decisionTable;
        this.paramsTable = (ILogicalTable)decisionTable.getSubtable(2, row, 1, 1);
        this.codeTable = (ILogicalTable)decisionTable.getSubtable(1, row, 1, 1);
        this.infoTable = (ILogicalTable)decisionTable.getSubtable(0, row, 1, 1);
        this.presentationTable = (ILogicalTable)decisionTable.getSubtable(3, row, 1, 1);
        this.scale = scale;
        this.params = new IParameterDeclaration[this.paramsTable.getHeight()];
        this.paramInitialized = new BitSet(this.paramsTable.getHeight());
        this.paramsUniqueNames = new HashSet<String>();
    }

    @Override
    public ILogicalTable getInfoTable() {
        return this.infoTable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public CompositeMethod getMethod() {
        return this.method;
    }

    @Override
    public IParameterDeclaration[] getParams() {
        return this.params;
    }

    @Override
    public void clearParamValues() {
        this.storage = null;
    }

    @Override
    public IOpenSourceCodeModule getSourceCodeModule() {
        return Optional.ofNullable(this.method).map(CompositeMethod::getMethodBodyBoundNode).map(IBoundNode::getSyntaxNode).map(ISyntaxNode::getModule).orElse(null);
    }

    @Override
    public int getNumberOfParams() {
        return this.getParams().length;
    }

    @Override
    public ILogicalTable getDecisionTable() {
        return this.decisionTable;
    }

    @Override
    public String[] getParamPresentation() {
        int length = this.paramsTable.getHeight();
        String[] result = new String[length];
        int fromHeight = 0;
        for (int i = 0; i < result.length; ++i) {
            int gridHeight = ((ILogicalTable)this.paramsTable.getRow(i)).getSource().getHeight();
            IGridTable singleParamGridTable = (IGridTable)this.presentationTable.getSource().getRows(fromHeight, fromHeight + gridHeight - 1);
            result[i] = singleParamGridTable.getCell(0, 0).getStringValue();
            fromHeight += gridHeight;
        }
        return result;
    }

    @Override
    public boolean hasDeclaredParams() {
        boolean res = false;
        for (int i = 0; i < this.paramsTable.getHeight(); ++i) {
            ILogicalTable paramTable = (ILogicalTable)this.paramsTable.getRow(i);
            GridCellSourceCodeModule source = new GridCellSourceCodeModule(paramTable.getSource());
            if (!StringUtils.isNotBlank((CharSequence)source.getCode())) continue;
            res = true;
        }
        return res;
    }

    @Override
    public void prepare(DecisionTable table, IOpenClass methodType, IMethodSignature signature, OpenL openl, IBindingContext bindingContext, RuleRow ruleRow, IOpenClass ruleExecutionType, TableSyntaxNode tableSyntaxNode) throws Exception {
        this.ruleExecutionType = ruleExecutionType;
        IOpenSourceCodeModule source = this.getExpressionSource(tableSyntaxNode, signature, methodType, null, openl, bindingContext);
        this.prepareParams(null, signature, methodType, source, openl, bindingContext);
        OpenlToolAdaptor openlAdaptor = new OpenlToolAdaptor(openl, bindingContext, tableSyntaxNode);
        OpenMethodHeader header = new OpenMethodHeader(this.name, null, signature, null);
        openlAdaptor.setHeader((IOpenMethodHeader)header);
        this.prepareParamValues(table, openlAdaptor, ruleRow, bindingContext);
        MethodSignature newSignature = ((MethodSignature)signature).merge(this.params);
        OpenMethodHeader methodHeader = new OpenMethodHeader(null, methodType, (IMethodSignature)newSignature, null);
        this.method = OpenLManager.makeMethod((OpenL)openl, (IOpenSourceCodeModule)source, (IOpenMethodHeader)methodHeader, (IBindingContext)bindingContext);
        if (bindingContext.isExecutionMode()) {
            this.decisionTable = null;
            this.paramsTable = null;
            this.codeTable = null;
            this.infoTable = null;
            this.presentationTable = null;
        }
    }

    protected void prepareParams(IOpenClass declaringClass, IMethodSignature signature, IOpenClass methodType, IOpenSourceCodeModule methodSource, OpenL openl, IBindingContext bindingContext) throws Exception {
        int length = this.paramsTable.getHeight();
        for (int i = 0; i < length; ++i) {
            if (this.paramInitialized.get(i)) continue;
            ILogicalTable paramTable = (ILogicalTable)this.paramsTable.getRow(i);
            GridCellSourceCodeModule source = new GridCellSourceCodeModule(paramTable.getSource(), bindingContext);
            IParameterDeclaration parameterDeclaration = this.getParameterDeclaration(source, methodSource, signature, declaringClass, methodType, length == 1, openl, bindingContext);
            if (parameterDeclaration == null) {
                this.params[i] = NullParameterDeclaration.the;
                continue;
            }
            String paramName = parameterDeclaration.getName();
            if (!this.paramsUniqueNames.add(paramName)) {
                BindHelper.processError((String)("Duplicated parameter name: " + paramName), (IOpenSourceCodeModule)source, (IBindingContext)bindingContext);
            }
            this.params[i] = parameterDeclaration;
            this.paramInitialized.set(i);
        }
    }

    @Override
    public void prepareParams(OpenL openl, IBindingContext bindingContext) {
        for (int i = 0; i < this.paramsTable.getHeight(); ++i) {
            IParameterDeclaration pd;
            ILogicalTable paramTable;
            GridCellSourceCodeModule paramSource;
            String code;
            if (this.paramInitialized.get(i) || StringUtils.isBlank((CharSequence)(code = (paramSource = new GridCellSourceCodeModule((paramTable = (ILogicalTable)this.paramsTable.getRow(i)).getSource(), bindingContext)).getCode())) || (pd = OpenLManager.makeParameterDeclaration((OpenL)openl, (IOpenSourceCodeModule)paramSource, (IBindingContext)bindingContext)) == null || pd.getName() == null) continue;
            this.params[i] = pd;
            if (!this.paramsUniqueNames.add(this.params[i].getName())) {
                BindHelper.processError((String)("Duplicated parameter name: " + this.params[i].getName()), (IOpenSourceCodeModule)paramSource, (IBindingContext)bindingContext);
            }
            this.paramInitialized.set(i);
        }
    }

    private void prepareParamValues(DecisionTable decisionTable, OpenlToolAdaptor ota, RuleRow ruleRow, IBindingContext bindingContext) {
        int i;
        int len = this.nValues();
        boolean[] paramIndexed = this.getParamIndexed(this.params);
        IStorageBuilder<?>[] builders = this.makeStorageBuilders(len, this.params);
        int actualStorageSize = this.scale.getActualSize(len);
        for (i = 0; i < actualStorageSize; ++i) {
            int ruleN = this.scale.getLogicalIndex(i);
            this.loadParamsFromColumn(ota, ruleRow, this.params, paramIndexed, ruleN, builders);
        }
        this.storage = new IStorage[builders.length];
        for (i = 0; i < builders.length; ++i) {
            this.storage[i] = builders[i].optimizeAndBuild();
            IOpenClass paramType = this.params[i].getType();
            int paramDim = 0;
            while (paramType.isArray()) {
                paramType = paramType.getComponentClass();
                ++paramDim;
            }
            if (paramType.getInstanceClass() != SpreadsheetResult.class || !OpenLSystemProperties.isCustomSpreadsheetTypesSupported(bindingContext.getExternalParams())) continue;
            HashSet<CustomSpreadsheetResultOpenClass> customSpreadsheetResultOpenClasses = new HashSet<CustomSpreadsheetResultOpenClass>();
            boolean anySpreadsheetResult = false;
            for (int j = 0; j < this.storage[i].size(); ++j) {
                Object o;
                int n;
                int n2;
                Object[] objectArray;
                Object[] values;
                if (this.storage[i].getValue(j) instanceof CompositeMethod) {
                    anySpreadsheetResult = this.processCompositeMethod((CompositeMethod)this.storage[i].getValue(j), customSpreadsheetResultOpenClasses, paramDim, anySpreadsheetResult);
                    if (!anySpreadsheetResult) continue;
                    break;
                }
                if (!(this.storage[i].getValue(j) instanceof ArrayHolder)) continue;
                ArrayHolder arrayHolder = (ArrayHolder)this.storage[i].getValue(j);
                if (paramDim > 1 && arrayHolder.is2DimArray()) {
                    objectArray = values = arrayHolder.get2DimValues();
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        Object o2;
                        Object value;
                        Object object = value = objectArray[n];
                        int n3 = ((Object)object).length;
                        for (int k = 0; !(k >= n3 || (o2 = object[k]) instanceof CompositeMethod && (anySpreadsheetResult = this.processCompositeMethod((CompositeMethod)o2, customSpreadsheetResultOpenClasses, paramDim - 2, anySpreadsheetResult))); ++k) {
                        }
                    }
                    continue;
                }
                if (paramDim <= 0) continue;
                objectArray = values = arrayHolder.getValues();
                n2 = objectArray.length;
                for (n = 0; !(n >= n2 || (o = objectArray[n]) instanceof CompositeMethod && (anySpreadsheetResult = this.processCompositeMethod((CompositeMethod)o, customSpreadsheetResultOpenClasses, paramDim - 1, anySpreadsheetResult))); ++n) {
                }
            }
            Object newType = null;
            if (anySpreadsheetResult) {
                newType = AnySpreadsheetResultOpenClass.INSTANCE;
            } else if (!customSpreadsheetResultOpenClasses.isEmpty()) {
                newType = ((XlsModuleOpenClass)decisionTable.getModule()).buildOrGetCombinedSpreadsheetResult(customSpreadsheetResultOpenClasses.toArray(new CustomSpreadsheetResultOpenClass[0]));
            }
            if (newType == null) continue;
            if (paramDim > 0) {
                newType = newType.getArrayType(paramDim);
            }
            this.params[i] = new ParameterDeclaration((IOpenClass)newType, this.params[i].getName(), this.params[i].getModule());
        }
    }

    private boolean processCompositeMethod(CompositeMethod o, Set<CustomSpreadsheetResultOpenClass> customSpreadsheetResultOpenClasses, int expectedDim, boolean anySpreadsheetResult) {
        IOpenClass methodBodyType = o.getBodyType();
        int methodTypeDim = 0;
        while (methodBodyType.isArray()) {
            methodBodyType = methodBodyType.getComponentClass();
            ++methodTypeDim;
        }
        if (methodTypeDim == expectedDim) {
            if (methodBodyType instanceof SpreadsheetResultOpenClass && ((SpreadsheetResultOpenClass)methodBodyType).getModule() != null) {
                customSpreadsheetResultOpenClasses.add(((SpreadsheetResultOpenClass)methodBodyType).toCustomSpreadsheetResultOpenClass());
            } else if (methodBodyType instanceof CustomSpreadsheetResultOpenClass) {
                customSpreadsheetResultOpenClasses.add((CustomSpreadsheetResultOpenClass)methodBodyType);
            } else if (methodBodyType instanceof AnySpreadsheetResultOpenClass || methodBodyType instanceof SpreadsheetResultOpenClass && ((SpreadsheetResultOpenClass)methodBodyType).getModule() == null) {
                return true;
            }
        }
        return anySpreadsheetResult;
    }

    private IStorageBuilder<?>[] makeStorageBuilders(int len, IParameterDeclaration[] paramDecl) {
        int nparams = paramDecl.length;
        IStorageBuilder[] builders = new IStorageBuilder[nparams];
        for (int i = 0; i < builders.length; ++i) {
            builders[i] = StorageFactory.makeStorageBuilder(len, this.scale);
        }
        return builders;
    }

    private void loadParamsFromColumn(OpenlToolAdaptor ota, RuleRow ruleRow, IParameterDeclaration[] paramDecl, boolean[] paramIndexed, int ruleN, IStorageBuilder<?>[] builders) {
        IGridTable paramGridColumn = this.getValueCell(ruleN).getSource();
        int fromHeight = 0;
        boolean executionMode = ota.getBindingContext().isExecutionMode();
        Object ruleName = null;
        if (!executionMode) {
            ruleName = ruleRow == null ? "R" + (ruleN + 1) : ruleRow.getRuleName(ruleN);
        }
        for (int j = 0; j < paramDecl.length; ++j) {
            Object loadedValue;
            IOpenClass paramType;
            if (paramDecl[j] == null || (paramType = paramDecl[j].getType()) == NullOpenClass.the) continue;
            int gridHeight = ((ILogicalTable)this.paramsTable.getRow(j)).getSource().getHeight();
            IGridTable singleParamGridTable = (IGridTable)paramGridColumn.getRows(fromHeight, fromHeight + gridHeight - 1);
            if (paramDecl[j].getName() == null) {
                loadedValue = RuleRowHelper.loadParam(LogicalTableHelper.logicalTable(singleParamGridTable), paramType, paramDecl[j].getName(), (String)ruleName, ota, paramIndexed[j]);
            } else {
                OpenlToolAdaptor paramOta = new OpenlToolAdaptor(ota.getOpenl(), (IBindingContext)new OtaBindingContext(ota.getBindingContext(), paramDecl[j].getName()), ota.getTableSyntaxNode());
                paramOta.setHeader(ota.getHeader());
                loadedValue = RuleRowHelper.loadParam(LogicalTableHelper.logicalTable(singleParamGridTable), paramType, paramDecl[j].getName(), (String)ruleName, paramOta, paramIndexed[j]);
            }
            builders[j].writeObject(loadedValue, ruleN);
            fromHeight += gridHeight;
        }
    }

    private boolean[] getParamIndexed(IParameterDeclaration[] paramDecl) {
        boolean[] paramIndexed = new boolean[paramDecl.length];
        for (int i = 0; i < paramIndexed.length; ++i) {
            paramIndexed[i] = paramDecl[i].getType().getAggregateInfo().isAggregate(paramDecl[i].getType());
        }
        return paramIndexed;
    }

    Object[] mergeParams(Object target, Object[] dtParams, IRuntimeEnv env, int ruleN) {
        if (dtParams == null) {
            dtParams = NO_PARAMS;
        }
        Object[] newParams = new Object[dtParams.length + this.getNumberOfParams()];
        System.arraycopy(dtParams, 0, newParams, 0, dtParams.length);
        this.loadValues(newParams, dtParams.length, ruleN, target, dtParams, env);
        return newParams;
    }

    @Override
    public ILogicalTable getValueCell(int column) {
        return (ILogicalTable)this.decisionTable.getSubtable(column + 4, this.row, 1, 1);
    }

    public ILogicalTable getCodeTable() {
        return this.codeTable;
    }

    public ILogicalTable getParamsTable() {
        return this.paramsTable;
    }

    public int nValues() {
        return this.decisionTable.getWidth() - 4;
    }

    private String makeParamName() {
        ++this.noParamsIndex;
        return (NO_PARAM + this.noParamsIndex).intern();
    }

    protected IOpenSourceCodeModule getExpressionSource(TableSyntaxNode tableSyntaxNode, IMethodSignature signature, IOpenClass methodType, IOpenClass declaringClass, OpenL openl, IBindingContext bindingContext) throws Exception {
        return new GridCellSourceCodeModule(this.codeTable.getSource(), bindingContext);
    }

    private IParameterDeclaration getParameterDeclaration(IOpenSourceCodeModule paramSource, IOpenSourceCodeModule methodSource, IMethodSignature signature, IOpenClass declaringClass, IOpenClass methodType, boolean allowEmpty, OpenL openl, IBindingContext bindingContext) {
        String code = paramSource.getCode();
        if (StringUtils.isBlank((CharSequence)code)) {
            if (allowEmpty) {
                try {
                    OpenMethodHeader methodHeader = new OpenMethodHeader(null, methodType, signature, declaringClass);
                    RulesModuleBindingContextHelper.compileAllTypesInSignature(methodHeader.getSignature(), bindingContext);
                    CompositeMethod method = OpenLManager.makeMethod((OpenL)openl, (IOpenSourceCodeModule)methodSource, (IOpenMethodHeader)methodHeader, (IBindingContext)bindingContext);
                    IOpenClass type = method.getMethodBodyBoundNode().getType();
                    if (type != NullOpenClass.the) {
                        return new ParameterDeclaration(type, this.makeParamName(), paramSource);
                    }
                    String message = "Cannot recognize type of local parameter for expression";
                    BindHelper.processError((String)message, (IOpenSourceCodeModule)methodSource, (IBindingContext)bindingContext);
                }
                catch (Exception | LinkageError ex) {
                    BindHelper.processError((String)"Cannot compile expression", (Throwable)ex, (IOpenSourceCodeModule)methodSource, (IBindingContext)bindingContext);
                }
            } else {
                String errMsg = "Parameter cell format: <type> <name>";
                BindHelper.processError((String)errMsg, (IOpenSourceCodeModule)paramSource, (IBindingContext)bindingContext);
            }
            return new ParameterDeclaration((IOpenClass)NullOpenClass.the, this.makeParamName(), paramSource);
        }
        IParameterDeclaration parameterDeclaration = OpenLManager.makeParameterDeclaration((OpenL)openl, (IOpenSourceCodeModule)paramSource, (IBindingContext)bindingContext);
        if (parameterDeclaration == null) {
            String errMsg = "Parameter cell format: <type> <name>";
            BindHelper.processError((String)errMsg, (IOpenSourceCodeModule)paramSource, (IBindingContext)bindingContext);
            return null;
        }
        if (parameterDeclaration.getName() == null) {
            return new ParameterDeclaration(parameterDeclaration.getType(), this.makeParamName());
        }
        return parameterDeclaration;
    }

    @Override
    public Object getParamValue(int paramIndex, int ruleN) {
        return this.storage[paramIndex].getValue(ruleN);
    }

    @Override
    public boolean isEmpty(int ruleN) {
        for (IStorage<?> aStorage : this.storage) {
            if (aStorage.isSpace(ruleN)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasFormula(int ruleN) {
        if (this.storage != null) {
            for (IStorage<?> aStorage : this.storage) {
                if (!aStorage.isFormula(ruleN)) continue;
                return true;
            }
        } else {
            IGridTable paramGridColumn = this.getValueCell(ruleN).getSource();
            return RuleRowHelper.isFormula(new SimpleLogicalTable(paramGridColumn));
        }
        return false;
    }

    @Override
    public int getNumberOfRules() {
        return this.storage == null || this.storage.length == 0 ? 0 : this.storage[0].size();
    }

    @Override
    public void loadValues(Object[] dest, int offset, int ruleN, Object target, Object[] tableParams, IRuntimeEnv env) {
        for (int i = 0; i < dest.length - offset; ++i) {
            Object value = this.storage[i].getValue(ruleN);
            if (value instanceof IOpenMethod) {
                value = ((IOpenMethod)value).invoke(target, tableParams, env);
            } else if (value instanceof ArrayHolder) {
                value = ((ArrayHolder)value).invoke(target, tableParams, env);
            }
            dest[i + offset] = value;
        }
    }

    @Override
    public boolean hasFormulas() {
        if (this.hasFormulas == null) {
            this.hasFormulas = this.initHasFormulas();
        }
        return this.hasFormulas;
    }

    private boolean initHasFormulas() {
        if (this.storage != null) {
            for (IStorage<?> aStorage : this.storage) {
                if (aStorage.getInfo().getNumberOfFormulas() <= 0) continue;
                return true;
            }
        } else {
            int len = this.nValues();
            int actualStorageSize = this.scale.getActualSize(len);
            for (int i = 0; i < actualStorageSize; ++i) {
                int ruleN = this.scale.getLogicalIndex(i);
                if (!this.hasFormula(ruleN)) continue;
                return true;
            }
        }
        return false;
    }

    public IStorage<?>[] getStorage() {
        return this.storage;
    }

    public Object getStorageValue(int paramNum, int ruleNum) {
        if (this.storage == null) {
            return null;
        }
        return this.storage[paramNum].getValue(ruleNum);
    }

    @Override
    public void removeDebugInformation() {
        Optional.ofNullable(this.method).ifPresent(CompositeMethod::removeDebugInformation);
    }

    @Override
    public boolean isEqual(int rule1, int rule2) {
        int n = this.getNumberOfParams();
        for (int i = 0; i < n; ++i) {
            Object p2;
            Object p1 = this.getParamValue(i, rule1);
            if (p1 == (p2 = this.getParamValue(i, rule2)) || p1 == null || p1.equals(p2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name + " : " + this.codeTable;
    }

    private static class OtaBindingContext
    extends BindingContextDelegator {
        private final String paramName;

        public OtaBindingContext(IBindingContext delegate, String paramName) {
            super(delegate);
            this.paramName = Objects.requireNonNull(paramName, "paramName cannot be null");
        }

        public IOpenField findVar(String namespace, String name, boolean strictMatch) throws AmbiguousFieldException {
            if (strictMatch && this.paramName.equals(name) || !strictMatch && this.paramName.equalsIgnoreCase(name)) {
                return null;
            }
            return super.findVar(namespace, name, strictMatch);
        }
    }
}

