/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.type;

import java.util.Date;
import org.openl.rules.dt.type.IRangeAdaptor;
import org.openl.rules.helpers.DateRange;

public class DateRangeAdaptor
implements IRangeAdaptor<DateRange, Long> {
    private DateRangeAdaptor() {
    }

    public static IRangeAdaptor<DateRange, Long> getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public Long getMax(DateRange range) {
        if (range == null) {
            return null;
        }
        long max = range.getUpperBound();
        if (max != Long.MAX_VALUE) {
            ++max;
        }
        return max;
    }

    @Override
    public Long getMin(DateRange range) {
        if (range == null) {
            return null;
        }
        return range.getLowerBound();
    }

    @Override
    public Long adaptValueType(Object value) {
        return value == null ? null : Long.valueOf(((Date)value).getTime());
    }

    @Override
    public boolean useOriginalSource() {
        return false;
    }

    private static final class InstanceHolder {
        private static final DateRangeAdaptor INSTANCE = new DateRangeAdaptor();

        private InstanceHolder() {
        }
    }
}

