/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openl.exception.OpenLRuntimeException;

public abstract class ARangeParser<T> {
    ARangeParser() {
    }

    abstract RangeParser[] getRangeParsers();

    public ParseStruct<T> parse(String range) {
        if (range != null) {
            for (RangeParser parser : this.getRangeParsers()) {
                try {
                    ParseStruct res = parser.parse(range);
                    if (res == null) continue;
                    return res;
                }
                catch (RuntimeException e) {
                    throw new OpenLRuntimeException("Failed to parse a range: " + range, (Throwable)e);
                }
            }
        }
        throw new OpenLRuntimeException("Failed to parse a range: " + range);
    }

    public static final class ParseStruct<T> {
        final T min;
        final T max;
        final BoundType leftBoundType;
        final BoundType rightBoundType;

        ParseStruct(T min, T max) {
            this(min, max, BoundType.INCLUDING, BoundType.INCLUDING);
        }

        ParseStruct(T min, T max, BoundType leftBoundType, BoundType rightBoundType) {
            this.min = min;
            this.max = max;
            this.leftBoundType = leftBoundType;
            this.rightBoundType = rightBoundType;
        }

        public static enum BoundType {
            INCLUDING,
            EXCLUDING;

        }
    }

    static interface RangeParser<T> {
        public ParseStruct<T> parse(String var1);
    }

    static interface RangeBoundAdapter<T> {
        public T adaptValue(String var1);

        public T getMinLeftBound();

        public T getMaxRightBound();
    }

    private static abstract class AParser<T>
    implements RangeParser<T> {
        private final Pattern pattern;
        final RangeBoundAdapter<T> adapter;

        AParser(Pattern pattern, RangeBoundAdapter<T> adapter) {
            this.pattern = pattern;
            this.adapter = adapter;
        }

        @Override
        public ParseStruct<T> parse(String range) {
            Matcher m = this.pattern.matcher(range);
            if (!m.matches()) {
                return null;
            }
            return this.doParse(m);
        }

        abstract ParseStruct<T> doParse(Matcher var1);
    }

    static final class RangeWithMoreLessParser<T>
    extends AParser<T> {
        RangeWithMoreLessParser(Pattern pattern, RangeBoundAdapter<T> converter) {
            super(pattern, converter);
        }

        @Override
        public ParseStruct<T> doParse(Matcher m) {
            ParseStruct.BoundType rightBoundType;
            ParseStruct.BoundType leftBoundType;
            Object max;
            Object min;
            String firstBound = m.group(1);
            Object first = this.adapter.adaptValue(m.group(2));
            String secondBound = m.group(3);
            Object second = this.adapter.adaptValue(m.group(4));
            if (firstBound.startsWith("<")) {
                if (secondBound.startsWith("<")) {
                    return null;
                }
                min = second;
                max = first;
                leftBoundType = ">".equals(secondBound) ? ParseStruct.BoundType.EXCLUDING : ParseStruct.BoundType.INCLUDING;
                rightBoundType = "<".equals(firstBound) ? ParseStruct.BoundType.EXCLUDING : ParseStruct.BoundType.INCLUDING;
            } else {
                if (secondBound.startsWith(">")) {
                    return null;
                }
                min = first;
                max = second;
                leftBoundType = ">".equals(firstBound) ? ParseStruct.BoundType.EXCLUDING : ParseStruct.BoundType.INCLUDING;
                rightBoundType = "<".equals(secondBound) ? ParseStruct.BoundType.EXCLUDING : ParseStruct.BoundType.INCLUDING;
            }
            return new ParseStruct(min, max, leftBoundType, rightBoundType);
        }
    }

    static final class MoreLessParser<T>
    extends AParser<T> {
        private static final Pattern LESS_THAN_PATTERN = Pattern.compile("less\\s+than");
        private static final Pattern MORE_THAN_PATTERN = Pattern.compile("more\\s+than");

        MoreLessParser(Pattern pattern, RangeBoundAdapter<T> converter) {
            super(pattern, converter);
        }

        @Override
        public ParseStruct<T> doParse(Matcher m) {
            String q = m.group(1);
            Object o = this.adapter.adaptValue(m.group(2));
            if ("<".equals(q) || LESS_THAN_PATTERN.matcher(q).matches()) {
                return new ParseStruct(this.adapter.getMinLeftBound(), o, ParseStruct.BoundType.INCLUDING, ParseStruct.BoundType.EXCLUDING);
            }
            if (q.length() > 1 && q.charAt(0) == '<') {
                return new ParseStruct(this.adapter.getMinLeftBound(), o);
            }
            if (">".equals(q) || MORE_THAN_PATTERN.matcher(q).matches()) {
                return new ParseStruct(o, this.adapter.getMaxRightBound(), ParseStruct.BoundType.EXCLUDING, ParseStruct.BoundType.INCLUDING);
            }
            if (q.length() > 1 && q.charAt(0) == '>') {
                return new ParseStruct(o, this.adapter.getMaxRightBound());
            }
            return null;
        }
    }

    static final class VerbalParser<T>
    extends AParser<T> {
        private static final Pattern OR_LESS_PATTERN = Pattern.compile("or\\s+less");

        VerbalParser(Pattern pattern, RangeBoundAdapter<T> converter) {
            super(pattern, converter);
        }

        @Override
        public ParseStruct<T> doParse(Matcher m) {
            Object s = this.adapter.adaptValue(m.group(1));
            String suffix = m.group(2);
            if (OR_LESS_PATTERN.matcher(suffix).matches()) {
                return new ParseStruct(this.adapter.getMinLeftBound(), s);
            }
            return new ParseStruct(s, this.adapter.getMaxRightBound());
        }
    }

    static final class BracketsParser<T>
    extends AParser<T> {
        BracketsParser(Pattern pattern, RangeBoundAdapter<T> converter) {
            super(pattern, converter);
        }

        @Override
        public ParseStruct<T> doParse(Matcher m) {
            String rb;
            Object o1 = this.adapter.adaptValue(m.group(2));
            Object o2 = this.adapter.adaptValue(m.group(3));
            String lb = m.group(1);
            ParseStruct.BoundType leftBoundType = ParseStruct.BoundType.INCLUDING;
            ParseStruct.BoundType rightBoundType = ParseStruct.BoundType.INCLUDING;
            if (lb.charAt(0) == '(') {
                leftBoundType = ParseStruct.BoundType.EXCLUDING;
            }
            if ((rb = m.group(4)).charAt(0) == ')') {
                rightBoundType = ParseStruct.BoundType.EXCLUDING;
            }
            return new ParseStruct(o1, o2, leftBoundType, rightBoundType);
        }
    }

    static final class MinMaxParser<T>
    extends AParser<T> {
        MinMaxParser(Pattern pattern, RangeBoundAdapter<T> converter) {
            super(pattern, converter);
        }

        @Override
        ParseStruct<T> doParse(Matcher m) {
            Object o1 = this.adapter.adaptValue(m.group(1));
            Object o2 = this.adapter.adaptValue(m.group(3));
            String delim = m.group(2);
            if ("...".equals(delim) || "\u2026".equals(delim)) {
                return new ParseStruct(o1, o2, ParseStruct.BoundType.EXCLUDING, ParseStruct.BoundType.EXCLUDING);
            }
            return new ParseStruct(o1, o2);
        }
    }

    static final class SimpleParser<T>
    extends AParser<T> {
        SimpleParser(Pattern pattern, RangeBoundAdapter<T> converter) {
            super(pattern, converter);
        }

        @Override
        ParseStruct<T> doParse(Matcher m) {
            Object o = this.adapter.adaptValue(m.group(1));
            return new ParseStruct(o, o);
        }
    }
}

