/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.openl.rules.helpers.ARangeParser;
import org.openl.rules.helpers.DateRangeParser;

public class DateRange {
    private static final int TO_DATE_RANGE_CAST_DISTANCE = 38;
    private final long lowerBound;
    private final long upperBound;
    private final ARangeParser.ParseStruct.BoundType lowerBoundType;
    private final ARangeParser.ParseStruct.BoundType upperBoundType;

    public DateRange(Date bound) {
        this(bound, bound, ARangeParser.ParseStruct.BoundType.INCLUDING, ARangeParser.ParseStruct.BoundType.INCLUDING);
    }

    public DateRange(Date lowerBound, Date upperBound) {
        this(lowerBound, upperBound, ARangeParser.ParseStruct.BoundType.INCLUDING, ARangeParser.ParseStruct.BoundType.INCLUDING);
    }

    DateRange(Date lowerBound, Date upperBound, ARangeParser.ParseStruct.BoundType lowerBoundType, ARangeParser.ParseStruct.BoundType upperBoundType) {
        assert (lowerBound != null);
        assert (upperBound != null);
        this.lowerBoundType = lowerBoundType;
        this.upperBoundType = upperBoundType;
        long localLowerBound = lowerBound.getTime();
        if (this.lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            ++localLowerBound;
        }
        long localUpperBound = upperBound.getTime();
        if (this.upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            --localUpperBound;
        }
        this.lowerBound = localLowerBound;
        this.upperBound = localUpperBound;
    }

    public DateRange(String source) {
        ARangeParser.ParseStruct range = DateRangeParser.getInstance().parse(source);
        this.lowerBoundType = range.leftBoundType;
        this.upperBoundType = range.rightBoundType;
        Long lowerBound = (Long)range.min;
        if (this.lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            lowerBound = lowerBound + 1L;
        }
        Long upperBound = (Long)range.max;
        if (this.upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            upperBound = upperBound - 1L;
        }
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException(String.format("%s must be greater or equal than %s", range.max, range.min));
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public Long getLowerBound() {
        return this.lowerBound;
    }

    public Long getUpperBound() {
        return this.upperBound;
    }

    public ARangeParser.ParseStruct.BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    public ARangeParser.ParseStruct.BoundType getUpperBoundType() {
        return this.upperBoundType;
    }

    public boolean contains(Date d) {
        if (d == null) {
            return false;
        }
        long x = d.getTime();
        return this.lowerBound <= x && x <= this.upperBound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRange dateRange = (DateRange)o;
        return this.lowerBound == dateRange.lowerBound && this.upperBound == dateRange.upperBound && this.lowerBoundType == dateRange.lowerBoundType && this.upperBoundType == dateRange.upperBoundType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lowerBound, this.upperBound, this.lowerBoundType, this.upperBoundType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (Long.MIN_VALUE == this.lowerBound) {
            sb.append(this.upperBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING ? "<= " : "< ");
            sb.append(DateRangeParser.dateTimeFormatter.format(this.getDateUpperBound()));
        } else if (Long.MAX_VALUE == this.upperBound) {
            sb.append(this.lowerBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING ? ">= " : "> ");
            sb.append(DateRangeParser.dateTimeFormatter.format(this.getDateLowerBound()));
        } else {
            sb.append(this.lowerBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING ? (char)'[' : '(');
            sb.append(DateRangeParser.dateTimeFormatter.format(this.getDateLowerBound()));
            sb.append("; ");
            sb.append(DateRangeParser.dateTimeFormatter.format(this.getDateUpperBound()));
            sb.append(this.upperBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING ? (char)']' : ')');
        }
        return sb.toString();
    }

    private LocalDateTime getDateUpperBound() {
        long time = this.upperBound;
        if (this.upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            ++time;
        }
        return Instant.ofEpochMilli(time).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private LocalDateTime getDateLowerBound() {
        long time = this.lowerBound;
        if (this.lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
            --time;
        }
        return Instant.ofEpochMilli(time).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static DateRange autocast(Date x, DateRange y) {
        return new DateRange(x);
    }

    public static int distance(Date x, DateRange y) {
        return 38;
    }

    public static DateRange autocast(Calendar x, DateRange y) {
        return new DateRange(x.getTime());
    }

    public static int distance(Calendar x, DateRange y) {
        return 38;
    }

    public static DateRange autocast(long x, DateRange y) {
        return new DateRange(new Date(x));
    }

    public static int distance(long x, DateRange y) {
        return 38;
    }
}

