/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import org.openl.rules.helpers.DoubleRangeParser;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.helpers.IntRange;
import org.openl.util.RangeWithBounds;

@XmlRootElement
public class DoubleRange
implements INumberRange {
    private static final int TO_DOUBLE_RANGE_CAST_DISTANCE = 38;
    private double lowerBound;
    private double upperBound;
    private RangeWithBounds.BoundType lowerBoundType;
    private RangeWithBounds.BoundType upperBoundType;

    public DoubleRange(double range) {
        this(range, range);
    }

    public DoubleRange(double lowerBound, double upperBound) {
        this(lowerBound, upperBound, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
    }

    public DoubleRange(double lowerBound, double upperBound, RangeWithBounds.BoundType lowerBoundType, RangeWithBounds.BoundType upperBoundType) {
        if (lowerBound > upperBound) {
            throw new IllegalArgumentException(String.format("%s must be greater or equal than %s.", upperBound, lowerBound));
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerBoundType = lowerBoundType;
        this.upperBoundType = upperBoundType;
    }

    public DoubleRange() {
        this.lowerBound = 0.0;
        this.upperBound = 0.0;
    }

    public DoubleRange(String range) {
        RangeWithBounds res = DoubleRange.getRangeWithBounds(range);
        this.lowerBound = res.getMin().doubleValue();
        this.lowerBoundType = res.getLeftBoundType();
        this.upperBound = res.getMax().doubleValue();
        this.upperBoundType = res.getRightBoundType();
        if (DoubleRange.isTruncated(res.getMin(), this.lowerBound)) {
            throw new IllegalArgumentException("lowerBound value is truncated");
        }
        if (DoubleRange.isTruncated(res.getMax(), this.upperBound)) {
            throw new IllegalArgumentException("upperBound value is truncated");
        }
    }

    private static RangeWithBounds getRangeWithBounds(String range) {
        return DoubleRangeParser.getInstance().parse(range);
    }

    protected static boolean isTruncated(Number from, double to) {
        return from instanceof BigDecimal && Double.isInfinite(to);
    }

    public int compareLowerBound(DoubleRange range) {
        if (this.lowerBound < range.lowerBound) {
            return -1;
        }
        if (this.lowerBound == range.lowerBound) {
            if (this.lowerBoundType == RangeWithBounds.BoundType.INCLUDING && range.lowerBoundType == RangeWithBounds.BoundType.EXCLUDING) {
                return -1;
            }
            if (this.lowerBoundType == range.lowerBoundType) {
                return 0;
            }
        }
        return 1;
    }

    public int compareUpperBound(DoubleRange range) {
        if (this.upperBound < range.upperBound) {
            return -1;
        }
        if (this.upperBound == range.upperBound) {
            if (this.upperBoundType == RangeWithBounds.BoundType.INCLUDING && range.upperBoundType == RangeWithBounds.BoundType.EXCLUDING) {
                return -1;
            }
            if (this.upperBoundType == range.upperBoundType) {
                return 0;
            }
        }
        return 1;
    }

    public boolean contains(double x) {
        if (this.lowerBound < x && x < this.upperBound) {
            return true;
        }
        if (x == this.lowerBound && this.lowerBoundType == RangeWithBounds.BoundType.INCLUDING) {
            return true;
        }
        return x == this.upperBound && this.upperBoundType == RangeWithBounds.BoundType.INCLUDING;
    }

    public boolean contains(DoubleRange range) {
        return this.compareLowerBound(range) <= 0 && this.compareUpperBound(range) >= 0;
    }

    @Override
    public boolean contains(Number n) {
        if (n instanceof Float) {
            return this.contains(Double.parseDouble(n.toString()));
        }
        return n != null && this.contains(n.doubleValue());
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound, this.lowerBoundType, this.upperBoundType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleRange)) {
            return false;
        }
        DoubleRange that = (DoubleRange)o;
        return Double.compare(that.lowerBound, this.lowerBound) == 0 && Double.compare(that.upperBound, this.upperBound) == 0 && this.lowerBoundType == that.lowerBoundType && this.upperBoundType == that.upperBoundType;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public DoubleRange intersect(DoubleRange range) {
        int lowerBoundComaring = this.compareLowerBound(range);
        int upperBoundComaring = this.compareUpperBound(range);
        double lowerBound = lowerBoundComaring > 0 ? this.lowerBound : range.lowerBound;
        RangeWithBounds.BoundType lowerBoundType = lowerBoundComaring > 0 ? this.lowerBoundType : range.lowerBoundType;
        double upperBound = upperBoundComaring < 0 ? this.upperBound : range.upperBound;
        RangeWithBounds.BoundType upperBoundType = upperBoundComaring < 0 ? this.upperBoundType : range.upperBoundType;
        return lowerBound > upperBound ? null : new DoubleRange(lowerBound, upperBound, lowerBoundType, upperBoundType);
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public RangeWithBounds.BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    public void setLowerBoundType(RangeWithBounds.BoundType lowerBoundType) {
        this.lowerBoundType = lowerBoundType;
    }

    public RangeWithBounds.BoundType getUpperBoundType() {
        return this.upperBoundType;
    }

    public void setUpperBoundType(RangeWithBounds.BoundType upperBoundType) {
        this.upperBoundType = upperBoundType;
    }

    public String toString() {
        if (this.lowerBound == Double.NEGATIVE_INFINITY) {
            return (this.upperBoundType == RangeWithBounds.BoundType.INCLUDING ? "<=" : "<") + this.upperBound;
        }
        if (this.upperBound == Double.POSITIVE_INFINITY) {
            return (this.lowerBoundType == RangeWithBounds.BoundType.INCLUDING ? ">=" : ">") + this.lowerBound;
        }
        StringBuilder builder = new StringBuilder();
        if (this.lowerBoundType == RangeWithBounds.BoundType.INCLUDING) {
            builder.append('[');
        } else {
            builder.append('(');
        }
        builder.append(this.lowerBound).append("; ").append(this.upperBound);
        if (this.upperBoundType == RangeWithBounds.BoundType.INCLUDING) {
            builder.append(']');
        } else {
            builder.append(')');
        }
        return builder.toString();
    }

    public static DoubleRange autocast(byte x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(byte x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(short x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(short x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(int x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(int x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(long x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(long x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(float x, DoubleRange y) {
        return new DoubleRange(new BigDecimal(String.valueOf(x)).doubleValue());
    }

    public static int distance(float x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(double x, DoubleRange y) {
        return new DoubleRange(x);
    }

    public static int distance(double x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange cast(BigInteger x, DoubleRange y) {
        return new DoubleRange(x.doubleValue());
    }

    public static int distance(BigInteger x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange cast(BigDecimal x, DoubleRange y) {
        return new DoubleRange(x.doubleValue());
    }

    public static int distance(BigDecimal x, DoubleRange y) {
        return 38;
    }

    public static DoubleRange autocast(IntRange x, DoubleRange y) {
        return new DoubleRange(x.getMin(), x.getMax());
    }
}

