/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.helpers.BaseRangeParser;
import org.openl.rules.helpers.RangeParser;
import org.openl.util.RangeWithBounds;
import org.openl.util.StringUtils;

public class DoubleRangeParser {
    private static final DoubleRangeParser INSTANCE = new DoubleRangeParser();
    private static final String DOUBLE_PATTERN = "\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)";
    protected static final RangeParser[] PARSERS = new RangeParser[]{new SimpleRangeParser(), new RangeWithBracketsParser(), new PrefixRangeParser(), new SuffixRangeParser(), new NumberParser(), new RangeWithMoreLessSymbolsParser(), new VerboseRangeParser()};
    private static final int MAX_RANGE_POSSIBLE_LENGTH = 200;

    protected DoubleRangeParser() {
    }

    public static DoubleRangeParser getInstance() {
        return INSTANCE;
    }

    public RangeWithBounds parse(String range) {
        if (range != null && range.length() <= 200) {
            try {
                range = range.trim();
                for (RangeParser parser : PARSERS) {
                    RangeWithBounds value = parser.parse(range);
                    if (value == null) continue;
                    return value;
                }
            }
            catch (RuntimeException e) {
                throw new OpenLRuntimeException("Failed to parse double range.", (Throwable)e);
            }
        }
        throw new OpenLRuntimeException("Failed to parse double range.");
    }

    private static final class VerboseRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("(less\\s+than|more\\s+than)?\\s*\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)\\s*(and\\s+more|or\\s+less)?\\s*(less\\s+than|more\\s+than)?\\s*\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)\\s*(and\\s+more|or\\s+less)?");

        private VerboseRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String group2 = matcher.group(2);
            String group6 = matcher.group(6);
            String group3 = matcher.group(3);
            String group7 = matcher.group(7);
            this.minNumber = group2;
            this.maxNumber = group6;
            this.minMultiplier = group3;
            this.maxMultiplier = group7;
            double first = this.parseDoubleWithMultiplier(group2, group3);
            double second = this.parseDoubleWithMultiplier(group6, group7);
            String firstBound1 = matcher.group(1);
            String firstBound2 = matcher.group(4);
            String secondBound1 = matcher.group(5);
            String secondBound2 = matcher.group(8);
            String firstBound = this.mergeBoundParts(firstBound1, firstBound2);
            String secondBound = this.mergeBoundParts(secondBound1, secondBound2);
            if (StringUtils.isEmpty((CharSequence)firstBound) || StringUtils.isEmpty((CharSequence)secondBound)) {
                return null;
            }
            firstBound = this.replaceVerboseToSymbol(firstBound);
            secondBound = this.replaceVerboseToSymbol(secondBound);
            return this.getRangeWithBounds(first, second, firstBound, secondBound);
        }

        private String replaceVerboseToSymbol(String bound) {
            return bound.replaceAll("less\\s+than", "<").replaceAll("more\\s+than", ">").replaceAll("or\\s+less", "<=").replaceAll("and\\s+more", ">=");
        }

        private String mergeBoundParts(String part1, String part2) {
            if (StringUtils.isNotEmpty((CharSequence)part1) && StringUtils.isNotEmpty((CharSequence)part2)) {
                return null;
            }
            return StringUtils.isEmpty((CharSequence)part1) ? part2 : part1;
        }
    }

    private static final class RangeWithMoreLessSymbolsParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("(<=?|>=?)\\s*\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)\\s*(<=?|>=?)\\s*\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)");

        private RangeWithMoreLessSymbolsParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String group2 = matcher.group(2);
            String group5 = matcher.group(5);
            String group3 = matcher.group(3);
            String group6 = matcher.group(6);
            this.minNumber = group2;
            this.maxNumber = group5;
            this.minMultiplier = group3;
            this.maxMultiplier = group6;
            double first = this.parseDoubleWithMultiplier(group2, group3);
            double second = this.parseDoubleWithMultiplier(group5, group6);
            String firstBound = matcher.group(1);
            String secondBound = matcher.group(4);
            return this.getRangeWithBounds(first, second, firstBound, secondBound);
        }
    }

    private static final class RangeWithBracketsParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("([\\[\\(])\\s*\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)\\s*([-;\u2026]|\\.{3}|\\.{2}?)\\s*\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)\\s*([\\]\\)])");

        private RangeWithBracketsParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String group2 = matcher.group(2);
            String group3 = matcher.group(3);
            String group5 = matcher.group(5);
            String group6 = matcher.group(6);
            this.minNumber = group2;
            this.maxNumber = group5;
            this.minMultiplier = group3;
            this.maxMultiplier = group6;
            double min = this.parseDoubleWithMultiplier(group2, group3);
            double max = this.parseDoubleWithMultiplier(group5, group6);
            RangeWithBounds.BoundType minBound = "[".equals(matcher.group(1)) ? RangeWithBounds.BoundType.INCLUDING : RangeWithBounds.BoundType.EXCLUDING;
            RangeWithBounds.BoundType maxBound = "]".equals(matcher.group(7)) ? RangeWithBounds.BoundType.INCLUDING : RangeWithBounds.BoundType.EXCLUDING;
            return new RangeWithBounds((Number)min, (Number)max, minBound, maxBound);
        }
    }

    private static final class SimpleRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)\\s*([-;\u2026]|\\.{3}|\\.{2}?)\\s*\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)");

        private SimpleRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String group1 = matcher.group(1);
            String group4 = matcher.group(4);
            String group2 = matcher.group(2);
            String group5 = matcher.group(5);
            String separator = matcher.group(3);
            this.minNumber = group1;
            this.maxNumber = group4;
            this.maxMultiplier = group5;
            this.minMultiplier = group2;
            double min = this.parseDoubleWithMultiplier(group1, group2);
            double max = this.parseDoubleWithMultiplier(group4, group5);
            RangeWithBounds.BoundType boundType = "\u2026".equals(separator) || "...".equals(separator) ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
            return new RangeWithBounds((Number)min, (Number)max, boundType, boundType);
        }
    }

    private static final class SuffixRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)\\s*(\\+|and\\s+more|or\\s+less)");
        private static final Pattern OR_LESS_PATTERN = Pattern.compile("or\\s+less");

        private SuffixRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String number = matcher.group(1);
            String multiplier = matcher.group(2);
            double value = this.parseDoubleWithMultiplier(number, multiplier);
            String suffix = matcher.group(3);
            if (OR_LESS_PATTERN.matcher(suffix).matches()) {
                this.maxNumber = number;
                this.maxMultiplier = multiplier;
                return new RangeWithBounds(this.getMin(value), (Number)value, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            this.minNumber = number;
            this.minMultiplier = multiplier;
            return new RangeWithBounds((Number)value, this.getMax(value), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
    }

    private static final class PrefixRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("(<=?|>=?|less\\s+than|more\\s+than)\\s*\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)");
        private static final Pattern LESS_THAN_PATTERN = Pattern.compile("less\\s+than");
        private static final Pattern MORE_THAN_PATTERN = Pattern.compile("more\\s+than");

        private PrefixRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String prefix = matcher.group(1);
            String number = matcher.group(2);
            String multiplier = matcher.group(3);
            double value = this.parseDoubleWithMultiplier(number, multiplier);
            if ("<".equals(prefix) || LESS_THAN_PATTERN.matcher(prefix).matches()) {
                this.maxNumber = number;
                this.maxMultiplier = multiplier;
                return new RangeWithBounds(this.getMin(value), (Number)value, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.EXCLUDING);
            }
            if ("<=".equals(prefix)) {
                this.maxNumber = number;
                this.maxMultiplier = multiplier;
                return new RangeWithBounds(this.getMin(value), (Number)value, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            if (">".equals(prefix) || MORE_THAN_PATTERN.matcher(prefix).matches()) {
                this.minNumber = number;
                this.minMultiplier = multiplier;
                return new RangeWithBounds((Number)value, this.getMax(value), RangeWithBounds.BoundType.EXCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            if (">=".equals(prefix)) {
                this.minNumber = number;
                this.minMultiplier = multiplier;
                return new RangeWithBounds((Number)value, this.getMax(value), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            throw new IllegalArgumentException("Incorrect prefix");
        }
    }

    private static final class NumberParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("\\$?(-?(?:(?:\\d{1,30},?){0,30})?\\.?\\d{1,30})([KMB]?)");

        private NumberParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String number = matcher.group(1);
            String multiplier = matcher.group(2);
            this.minNumber = this.maxNumber = number;
            this.minMultiplier = this.maxMultiplier = multiplier;
            double value = this.parseDoubleWithMultiplier(number, multiplier);
            return new RangeWithBounds((Number)value, (Number)value);
        }
    }
}

