/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openl.exception.OpenLRuntimeException;
import org.openl.rules.helpers.BaseRangeParser;
import org.openl.rules.helpers.RangeParser;
import org.openl.util.RangeWithBounds;
import org.openl.util.StringUtils;

public class IntRangeParser {
    private static final IntRangeParser INSTANCE = new IntRangeParser();
    private static final String INT_PATTERN = "\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)";
    protected final RangeParser[] PARSERS = new RangeParser[]{new SimpleRangeParser(), new RangeWithBracketsParser(), new PrefixRangeParser(), new SuffixRangeParser(), new NumberParser(), new RangeWithMoreLessSymbolsParser(), new VerboseRangeParser()};
    private static final int MAX_RANGE_POSSIBLE_LENGTH = 100;

    protected IntRangeParser() {
    }

    public static IntRangeParser getInstance() {
        return INSTANCE;
    }

    public RangeWithBounds parse(String range) {
        if (range != null && range.length() <= 100) {
            try {
                range = range.trim();
                for (RangeParser parser : this.PARSERS) {
                    RangeWithBounds value = parser.parse(range);
                    if (value == null) continue;
                    return value;
                }
            }
            catch (RuntimeException e) {
                throw new OpenLRuntimeException("Failed to parse int range.", (Throwable)e);
            }
        }
        throw new OpenLRuntimeException("Failed to parse int range.");
    }

    private static final class VerboseRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("(less\\s+than|more\\s+than)?\\s*\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)\\s*(and\\s+more|or\\s+less)?\\s*(less\\s+than|more\\s+than)?\\s*\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)\\s*(and\\s+more|or\\s+less)?");

        private VerboseRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String group2 = matcher.group(2);
            String group6 = matcher.group(6);
            String group3 = matcher.group(3);
            String group7 = matcher.group(7);
            this.minNumber = group2;
            this.maxNumber = group6;
            this.minMultiplier = group3;
            this.maxMultiplier = group7;
            long first = this.parseIntWithMultiplier(group2, group3);
            long second = this.parseIntWithMultiplier(group6, group7);
            String firstBound1 = matcher.group(1);
            String firstBound2 = matcher.group(4);
            String secondBound1 = matcher.group(5);
            String secondBound2 = matcher.group(8);
            String firstBound = this.mergeBoundParts(firstBound1, firstBound2);
            String secondBound = this.mergeBoundParts(secondBound1, secondBound2);
            if (StringUtils.isEmpty((CharSequence)firstBound) || StringUtils.isEmpty((CharSequence)secondBound)) {
                return null;
            }
            firstBound = this.replaceVerboseToSymbol(firstBound);
            secondBound = this.replaceVerboseToSymbol(secondBound);
            return this.getRangeWithBounds(first, second, firstBound, secondBound);
        }

        private String replaceVerboseToSymbol(String bound) {
            return bound.replaceAll("less\\s+than", "<").replaceAll("more\\s+than", ">").replaceAll("or\\s+less", "<=").replaceAll("and\\s+more", ">=");
        }

        private String mergeBoundParts(String part1, String part2) {
            if (StringUtils.isNotEmpty((CharSequence)part1) && StringUtils.isNotEmpty((CharSequence)part2)) {
                return null;
            }
            return StringUtils.isEmpty((CharSequence)part1) ? part2 : part1;
        }
    }

    private static final class RangeWithMoreLessSymbolsParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("(<=?|>=?)\\s*\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)\\s*(<=?|>=?)\\s*\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)");

        private RangeWithMoreLessSymbolsParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String group2 = matcher.group(2);
            String group5 = matcher.group(5);
            String group3 = matcher.group(3);
            String group6 = matcher.group(6);
            this.minNumber = group2;
            this.maxNumber = group5;
            this.minMultiplier = group3;
            this.maxMultiplier = group6;
            long first = this.parseIntWithMultiplier(group2, group3);
            long second = this.parseIntWithMultiplier(group5, group6);
            String firstBound = matcher.group(1);
            String secondBound = matcher.group(4);
            return this.getRangeWithBounds(first, second, firstBound, secondBound);
        }
    }

    private static final class RangeWithBracketsParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("([\\[\\(])\\s*\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)\\s*([-;\u2026]|\\.{3}|\\.{2}?)\\s*\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)\\s*([\\]\\)])");

        private RangeWithBracketsParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String gruop2 = matcher.group(2);
            String gruop5 = matcher.group(5);
            String gruop3 = matcher.group(3);
            String gruop6 = matcher.group(6);
            this.minNumber = gruop2;
            this.maxNumber = gruop5;
            this.minMultiplier = gruop3;
            this.maxMultiplier = gruop6;
            long min = this.parseIntWithMultiplier(gruop2, gruop3);
            long max = this.parseIntWithMultiplier(gruop5, gruop6);
            RangeWithBounds.BoundType minBound = "[".equals(matcher.group(1)) ? RangeWithBounds.BoundType.INCLUDING : RangeWithBounds.BoundType.EXCLUDING;
            RangeWithBounds.BoundType maxBound = "]".equals(matcher.group(7)) ? RangeWithBounds.BoundType.INCLUDING : RangeWithBounds.BoundType.EXCLUDING;
            return new RangeWithBounds((Number)min, (Number)max, minBound, maxBound);
        }
    }

    private static final class SimpleRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)\\s*([-;\u2026]|\\.{3}|\\.{2}?)\\s*\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)");

        private SimpleRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            String group4 = matcher.group(4);
            String group5 = matcher.group(5);
            String separator = matcher.group(3);
            this.minNumber = group1;
            this.maxNumber = group4;
            this.minMultiplier = group2;
            this.maxMultiplier = group5;
            long min = this.parseIntWithMultiplier(group1, group2);
            long max = this.parseIntWithMultiplier(group4, group5);
            RangeWithBounds.BoundType boundType = "\u2026".equals(separator) || "...".equals(separator) ? RangeWithBounds.BoundType.EXCLUDING : RangeWithBounds.BoundType.INCLUDING;
            return new RangeWithBounds((Number)min, (Number)max, boundType, boundType);
        }
    }

    private static final class SuffixRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)\\s*(\\+|and\\s+more|or\\s+less)");
        private static final Pattern OR_LESS_PATTERN = Pattern.compile("or\\s+less");

        private SuffixRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String number = matcher.group(1);
            String multiplier = matcher.group(2);
            long value = this.parseIntWithMultiplier(number, multiplier);
            String suffix = matcher.group(3);
            if (OR_LESS_PATTERN.matcher(suffix).matches()) {
                this.maxNumber = number;
                this.maxMultiplier = multiplier;
                return new RangeWithBounds(this.getMin(value), (Number)value, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            this.minNumber = number;
            this.minMultiplier = multiplier;
            return new RangeWithBounds((Number)value, this.getMax(value), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
        }
    }

    private static final class PrefixRangeParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("(<=?|>=?|less\\s+than|more\\s+than)\\s*\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)");
        private static final Pattern LESS_THAN_PATTERN = Pattern.compile("less\\s+than");
        private static final Pattern MORE_THAN_PATTERN = Pattern.compile("more\\s+than");

        private PrefixRangeParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String prefix = matcher.group(1);
            String number = matcher.group(2);
            String multiplier = matcher.group(3);
            long value = this.parseIntWithMultiplier(number, multiplier);
            if ("<".equals(prefix) || LESS_THAN_PATTERN.matcher(prefix).matches()) {
                this.maxNumber = number;
                this.maxMultiplier = multiplier;
                return new RangeWithBounds(this.getMin(value), (Number)value, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.EXCLUDING);
            }
            if ("<=".equals(prefix)) {
                this.maxNumber = number;
                this.maxMultiplier = multiplier;
                return new RangeWithBounds(this.getMin(value), (Number)value, RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            if (">".equals(prefix) || MORE_THAN_PATTERN.matcher(prefix).matches()) {
                this.minNumber = number;
                this.minMultiplier = multiplier;
                return new RangeWithBounds((Number)value, this.getMax(value), RangeWithBounds.BoundType.EXCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            if (">=".equals(prefix)) {
                this.minNumber = number;
                this.minMultiplier = multiplier;
                return new RangeWithBounds((Number)value, this.getMax(value), RangeWithBounds.BoundType.INCLUDING, RangeWithBounds.BoundType.INCLUDING);
            }
            throw new IllegalArgumentException("Incorrect prefix");
        }
    }

    private static final class NumberParser
    extends BaseRangeParser {
        private static final Pattern PATTERN = Pattern.compile("\\$?(-?(?:\\d{1,19},){0,19}\\d{1,19})([KMB]?)");

        private NumberParser() {
        }

        @Override
        public RangeWithBounds parse(String range) {
            Matcher matcher = PATTERN.matcher(range);
            if (!matcher.matches()) {
                return null;
            }
            String number = matcher.group(1);
            String multiplier = matcher.group(2);
            this.minNumber = this.maxNumber = number;
            this.minMultiplier = this.maxMultiplier = multiplier;
            long value = this.parseIntWithMultiplier(number, multiplier);
            return new RangeWithBounds((Number)value, (Number)value);
        }
    }
}

