/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.util.Objects;
import javax.xml.bind.annotation.XmlRootElement;
import org.openl.binding.impl.NumericComparableString;
import org.openl.rules.helpers.ARangeParser;
import org.openl.rules.helpers.StringRangeParser;

@XmlRootElement
public class StringRange {
    private static final int TO_STRING_RANGE_CAST_DISTANCE = 38;
    private final NumericComparableString lowerBound;
    private final NumericComparableString upperBound;
    private final ARangeParser.ParseStruct.BoundType lowerBoundType;
    private final ARangeParser.ParseStruct.BoundType upperBoundType;

    StringRange(String lowerBound, String upperBound) {
        this(lowerBound, upperBound, ARangeParser.ParseStruct.BoundType.INCLUDING, ARangeParser.ParseStruct.BoundType.INCLUDING);
    }

    StringRange(String lowerBound, String upperBound, ARangeParser.ParseStruct.BoundType lowerBoundType, ARangeParser.ParseStruct.BoundType upperBoundType) {
        this.lowerBound = NumericComparableString.valueOf((String)lowerBound);
        this.upperBound = NumericComparableString.valueOf((String)upperBound);
        this.lowerBoundType = lowerBoundType;
        this.upperBoundType = upperBoundType;
        this.validate();
    }

    public StringRange(String source) {
        ARangeParser.ParseStruct range = StringRangeParser.getInstance().parse(source);
        this.lowerBound = NumericComparableString.valueOf((String)((String)range.min));
        this.lowerBoundType = range.leftBoundType;
        this.upperBound = NumericComparableString.valueOf((String)((String)range.max));
        this.upperBoundType = range.rightBoundType;
        this.validate();
    }

    private void validate() {
        if (this.lowerBoundType == null || this.upperBoundType == null) {
            throw new IllegalArgumentException("Bound types must be initialized.");
        }
        if (this.lowerBound == null || this.upperBound == null) {
            throw new IllegalArgumentException("All bounds must be initialized.");
        }
        if (this.lowerBound.compareTo(this.upperBound) > 0) {
            throw new IllegalArgumentException("Left bound must be lower than right.");
        }
    }

    public NumericComparableString getLowerBound() {
        return this.lowerBound;
    }

    public ARangeParser.ParseStruct.BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    public NumericComparableString getUpperBound() {
        return this.upperBound;
    }

    public ARangeParser.ParseStruct.BoundType getUpperBoundType() {
        return this.upperBoundType;
    }

    public boolean contains(NumericComparableString s) {
        if (s == null) {
            return false;
        }
        int lowerComparison = this.lowerBound.compareTo(s);
        int upperComparison = this.upperBound.compareTo(s);
        if (lowerComparison < 0 && upperComparison > 0) {
            return true;
        }
        if (lowerComparison == 0 && this.lowerBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING) {
            return true;
        }
        return upperComparison == 0 && this.upperBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING;
    }

    public boolean contains(CharSequence s) {
        return this.contains(s == null ? null : NumericComparableString.valueOf((String)s.toString()));
    }

    public int compareUpperBound(StringRange range) {
        if (this.upperBound.compareTo(range.upperBound) < 0) {
            return -1;
        }
        if (this.upperBound.compareTo(range.upperBound) == 0) {
            if (this.upperBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING && range.upperBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
                return -1;
            }
            if (this.upperBoundType == range.upperBoundType) {
                return 0;
            }
        }
        return 1;
    }

    public int compareLowerBound(StringRange range) {
        if (this.lowerBound.compareTo(range.lowerBound) < 0) {
            return -1;
        }
        if (this.lowerBound.compareTo(range.lowerBound) == 0) {
            if (this.lowerBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING && range.lowerBoundType == ARangeParser.ParseStruct.BoundType.EXCLUDING) {
                return -1;
            }
            if (this.lowerBoundType == range.lowerBoundType) {
                return 0;
            }
        }
        return 1;
    }

    public boolean contains(StringRange range) {
        return this.compareLowerBound(range) <= 0 && this.compareUpperBound(range) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringRange that = (StringRange)o;
        return Objects.equals(this.lowerBound.getValue(), that.lowerBound.getValue()) && Objects.equals(this.upperBound.getValue(), that.upperBound.getValue()) && this.lowerBoundType == that.lowerBoundType && this.upperBoundType == that.upperBoundType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lowerBound, this.upperBound, this.lowerBoundType, this.upperBoundType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (StringRangeParser.MIN_VALUE.equals(this.lowerBound.getValue())) {
            sb.append(this.upperBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING ? "<= " : "< ");
            sb.append(this.upperBound);
        } else if (StringRangeParser.MAX_VALUE.equals(this.upperBound.getValue())) {
            sb.append(this.lowerBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING ? ">= " : "> ");
            sb.append(this.lowerBound);
        } else {
            sb.append(this.lowerBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING ? (char)'[' : '(');
            sb.append(this.lowerBound);
            sb.append("; ");
            sb.append(this.upperBound);
            sb.append(this.upperBoundType == ARangeParser.ParseStruct.BoundType.INCLUDING ? (char)']' : ')');
        }
        return sb.toString();
    }

    public static StringRange autocast(String x, StringRange y) {
        return new StringRange(x);
    }

    public static int distance(String x, StringRange y) {
        return 38;
    }

    public static StringRange cast(char[] x, StringRange y) {
        return new StringRange(String.valueOf(x));
    }

    public static int distance(char[] x, StringRange y) {
        return 38;
    }
}

