/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.syntax.OpenlSyntaxNode;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.syntax.WorkbookSyntaxNode;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.NaryNode;

public class XlsModuleSyntaxNode
extends NaryNode {
    private final OpenlSyntaxNode openlNode;
    private final Set<String> imports;
    private TableSyntaxNode[] tableSyntaxNodes;

    public XlsModuleSyntaxNode(WorkbookSyntaxNode[] nodes, IOpenSourceCodeModule module, OpenlSyntaxNode openlNode, Collection<String> imports) {
        super(XlsNodeTypes.XLS_MODULE.toString(), null, (ISyntaxNode[])nodes, module);
        this.openlNode = openlNode;
        this.imports = new HashSet<String>(imports);
    }

    public Collection<String> getImports() {
        return Collections.unmodifiableSet(this.imports);
    }

    public void addImport(String value) {
        this.imports.add(value);
    }

    public OpenlSyntaxNode getOpenlNode() {
        return this.openlNode;
    }

    public WorkbookSyntaxNode[] getWorkbookSyntaxNodes() {
        return (WorkbookSyntaxNode[])this.getNodes();
    }

    public TableSyntaxNode[] getXlsTableSyntaxNodes() {
        if (this.tableSyntaxNodes == null) {
            this.buildXlsTableSyntaxNodes();
        } else {
            int expectedSize = 0;
            for (WorkbookSyntaxNode wbsn : this.getWorkbookSyntaxNodes()) {
                expectedSize += wbsn.getTableSyntaxNodes().length;
            }
            if (expectedSize != this.tableSyntaxNodes.length) {
                this.buildXlsTableSyntaxNodes();
            }
        }
        return this.tableSyntaxNodes;
    }

    private void buildXlsTableSyntaxNodes() {
        ArrayList tsnodes = new ArrayList();
        for (WorkbookSyntaxNode wbsn : this.getWorkbookSyntaxNodes()) {
            Collections.addAll(tsnodes, wbsn.getTableSyntaxNodes());
        }
        this.tableSyntaxNodes = tsnodes.toArray(TableSyntaxNode.EMPTY_ARRAY);
    }
}

