/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openl.binding.exception.DuplicatedFieldException;
import org.openl.binding.impl.module.WrapModuleSpecificTypes;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.DatatypeOpenConstructor;
import org.openl.rules.lang.xls.types.DatatypeOpenField;
import org.openl.rules.lang.xls.types.DatatypeOpenMethod;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.BelongsToModuleOpenClass;
import org.openl.types.impl.DynamicArrayAggregateInfo;
import org.openl.types.impl.MethodKey;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.types.java.JavaOpenMethod;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatypeOpenClass
extends ADynamicClass
implements BelongsToModuleOpenClass,
WrapModuleSpecificTypes {
    private static final Logger LOG = LoggerFactory.getLogger(DatatypeOpenClass.class);
    private IOpenClass superClass;
    private final String javaName;
    private final String packageName;
    private TableSyntaxNode tableSyntaxNode;
    private byte[] bytecode;
    private XlsModuleOpenClass module;
    private volatile Map<String, IOpenField> fields;
    private volatile Map<String, IOpenField> staticFields;
    private static final Map<MethodKey, IOpenMethod> OBJECT_CLASS_METHODS;

    public DatatypeOpenClass(String name, String packageName) {
        super(name, null);
        this.javaName = StringUtils.isBlank((CharSequence)packageName) ? name : packageName + "." + name;
        this.packageName = packageName;
    }

    public String getExternalRefName() {
        if (this.module == null) {
            throw new IllegalStateException("moduleName is not defined");
        }
        return "`" + this.module.getModuleName() + "`." + this.getName();
    }

    public void setModule(XlsModuleOpenClass module) {
        this.module = module;
    }

    public XlsModuleOpenClass getModule() {
        return this.module;
    }

    public IAggregateInfo getAggregateInfo() {
        return DynamicArrayAggregateInfo.aggregateInfo;
    }

    public IOpenClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(IOpenClass superClass) {
        this.superClass = superClass;
    }

    public Collection<IOpenClass> superClasses() {
        if (this.superClass != null) {
            return Collections.singletonList(this.superClass);
        }
        return Collections.emptyList();
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isArray() {
        return false;
    }

    protected LinkedHashMap<String, IOpenField> fieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new LinkedHashMap();
        }
        return (LinkedHashMap)this.fieldMap;
    }

    public Collection<IOpenField> getFields() {
        this.ensureFieldsInitialized();
        return Collections.unmodifiableCollection(this.fields.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFieldsInitialized() {
        if (this.fields == null || this.staticFields == null) {
            DatatypeOpenClass datatypeOpenClass = this;
            synchronized (datatypeOpenClass) {
                if (this.fields == null || this.staticFields == null) {
                    this.initializeFields();
                }
            }
        }
    }

    private void initializeFields() {
        LinkedHashMap<String, IOpenField> fields = new LinkedHashMap<String, IOpenField>();
        LinkedHashMap<String, IOpenField> staticFields = new LinkedHashMap<String, IOpenField>();
        Collection<IOpenClass> superClasses = this.superClasses();
        for (IOpenClass superClassValue : superClasses) {
            for (IOpenField field : superClassValue.getFields()) {
                fields.put(field.getName(), field);
            }
        }
        ((LinkedHashMap)this.fieldMap()).forEach(fields::putIfAbsent);
        staticFields.put("class", (IOpenField)new JavaOpenClass.JavaClassClassField(this.instanceClass, (IOpenClass)this));
        this.fields = fields;
        this.staticFields = staticFields;
        Optional.ofNullable(this.superClass).map(IOpenClass::getIndexField).ifPresent(arg_0 -> ((DatatypeOpenClass)this).setIndexField(arg_0));
    }

    public void addField(IOpenField field) throws DuplicatedFieldException {
        this.fields = null;
        super.addField(field);
        this.invalidateInternalData();
    }

    public Collection<IOpenField> getDeclaredFields() {
        return Collections.unmodifiableCollection(((LinkedHashMap)this.fieldMap()).values());
    }

    public Object newInstance(IRuntimeEnv env) {
        Object instance = null;
        try {
            instance = this.getInstanceClass().newInstance();
        }
        catch (Exception e) {
            LOG.error("{}", (Object)this, (Object)e);
        }
        return instance;
    }

    public IOpenClass getComponentClass() {
        return null;
    }

    public String toString() {
        return this.javaName;
    }

    private IOpenMethod wrapDatatypeOpenMethod(IOpenMethod method) {
        if (method instanceof JavaOpenMethod) {
            JavaOpenMethod javaOpenMethod = (JavaOpenMethod)method;
            Method javaMethod = javaOpenMethod.getJavaMethod();
            for (IOpenField field : ((LinkedHashMap)this.fieldMap()).values()) {
                if (!(field instanceof DatatypeOpenField)) continue;
                DatatypeOpenField datatypeOpenField = (DatatypeOpenField)field;
                if (datatypeOpenField.getGetter().equals(javaMethod)) {
                    return new DatatypeOpenMethod(javaOpenMethod, (IOpenClass)this, javaOpenMethod.getParameterTypes(), field.getType());
                }
                if (!datatypeOpenField.getSetter().equals(javaMethod)) continue;
                IOpenClass[] parameterTypes = new IOpenClass[]{field.getType()};
                return new DatatypeOpenMethod(javaOpenMethod, (IOpenClass)this, parameterTypes, javaOpenMethod.getType());
            }
        }
        return method;
    }

    protected Map<MethodKey, IOpenMethod> initMethodMap() {
        Map methods = super.initMethodMap();
        HashMap<MethodKey, IOpenMethod> methodMap = new HashMap<MethodKey, IOpenMethod>(OBJECT_CLASS_METHODS);
        for (Map.Entry m : methods.entrySet()) {
            IOpenMethod m1 = this.wrapDatatypeOpenMethod((IOpenMethod)m.getValue());
            if (m1 != m.getValue()) {
                methodMap.put(new MethodKey(m1), m1);
                continue;
            }
            methodMap.put((MethodKey)m.getKey(), (IOpenMethod)m.getValue());
        }
        return methodMap;
    }

    protected Map<MethodKey, IOpenMethod> initConstructorMap() {
        Map constructors = super.initConstructorMap();
        HashMap<MethodKey, IOpenMethod> constructorMap = new HashMap<MethodKey, IOpenMethod>(1);
        for (Map.Entry constructor : constructors.entrySet()) {
            IOpenMethod wrapped = this.wrapDatatypeOpenConstructor((MethodKey)constructor.getKey(), (IOpenMethod)constructor.getValue());
            if (wrapped == constructor.getValue()) {
                constructorMap.put((MethodKey)constructor.getKey(), (IOpenMethod)constructor.getValue());
                continue;
            }
            constructorMap.put(new MethodKey(wrapped), wrapped);
        }
        return constructorMap;
    }

    private IOpenMethod wrapDatatypeOpenConstructor(MethodKey mk, IOpenMethod method) {
        if (method instanceof JavaOpenConstructor) {
            JavaOpenConstructor javaOpenConstructor = (JavaOpenConstructor)method;
            if (javaOpenConstructor.getNumberOfParameters() == 0) {
                return new DatatypeOpenConstructor(javaOpenConstructor, (IOpenClass)this);
            }
            MethodKey candidate = new MethodKey((IOpenClass[])this.getFields().stream().map(IOpenMember::getType).toArray(IOpenClass[]::new));
            if (mk.equals((Object)candidate)) {
                ParameterDeclaration[] parameters = (ParameterDeclaration[])this.getFields().stream().map(f -> new ParameterDeclaration(f.getType(), f.getName())).toArray(ParameterDeclaration[]::new);
                return new DatatypeOpenConstructor(javaOpenConstructor, (IOpenClass)this, (IParameterDeclaration[])parameters);
            }
        }
        return method;
    }

    public String getDisplayName(int mode) {
        if (mode == 2) {
            return this.getPackageName() + "." + this.getName();
        }
        return this.getName();
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    public void setBytecode(byte[] bytecode) {
        this.bytecode = bytecode;
    }

    public TableSyntaxNode getTableSyntaxNode() {
        return this.tableSyntaxNode;
    }

    public void setTableSyntaxNode(TableSyntaxNode tableSyntaxNode) {
        this.tableSyntaxNode = tableSyntaxNode;
    }

    public IOpenField getStaticField(String fname) {
        this.ensureFieldsInitialized();
        return this.staticFields.get(fname);
    }

    public Collection<IOpenField> getStaticFields() {
        this.ensureFieldsInitialized();
        return this.staticFields.values();
    }

    public IOpenField getStaticField(String name, boolean strictMatch) {
        this.ensureFieldsInitialized();
        Optional<String> first = this.staticFields.keySet().stream().filter(f -> f.equalsIgnoreCase(name)).findFirst();
        return first.map(s -> this.staticFields.get(s)).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateInternalData() {
        super.invalidateInternalData();
        DatatypeOpenClass datatypeOpenClass = this;
        synchronized (datatypeOpenClass) {
            this.fields = null;
            this.staticFields = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DatatypeOpenClass that = (DatatypeOpenClass)((Object)o);
        return Objects.equals((Object)this.module, (Object)that.module);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.module != null ? this.module.hashCode() : 0);
        return result;
    }

    static {
        HashMap<MethodKey, IOpenMethod> objectClassMethods = new HashMap<MethodKey, IOpenMethod>();
        for (IOpenMethod m : JavaOpenClass.OBJECT.getMethods()) {
            objectClassMethods.put(new MethodKey(m), m);
        }
        OBJECT_CLASS_METHODS = Collections.unmodifiableMap(objectClassMethods);
    }
}

