/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.Objects;
import org.openl.exception.OpenLUserDetailedRuntimeException;
import org.openl.util.print.NicePrinter;

public class TestError {
    private String message;
    private String code;
    private Object body;
    private boolean oldStyle;

    public TestError(String message) {
        this.message = message;
        this.oldStyle = true;
    }

    public TestError() {
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestError testError = (TestError)o;
        return Objects.equals(this.message, testError.message) && Objects.equals(this.code, testError.code) && Objects.equals(this.body, testError.body);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.code, this.body);
    }

    public String toString() {
        if (this.oldStyle) {
            return this.message;
        }
        if (this.body != null) {
            return NicePrinter.print((Object)this.body);
        }
        return String.format("%s: %s", this.code, this.message);
    }

    public static TestError from(OpenLUserDetailedRuntimeException ex) {
        TestError error = new TestError();
        if (ex.getBody() instanceof OpenLUserDetailedRuntimeException.Body) {
            OpenLUserDetailedRuntimeException.Body body = (OpenLUserDetailedRuntimeException.Body)ex.getBody();
            error.setMessage(body.getMessage());
            error.setCode(body.getCode());
        } else {
            error.setBody(ex.getBody());
        }
        return error;
    }

    public static TestError from(Throwable ex) {
        return new TestError(ex.getMessage());
    }
}

