/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataTableBindHelper;
import org.openl.rules.data.FieldChain;
import org.openl.rules.data.IDataBase;
import org.openl.rules.data.ITableModel;
import org.openl.rules.data.PrecisionFieldChain;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestError;
import org.openl.rules.testmethod.TestMethodBoundNode;
import org.openl.rules.testmethod.TestSuite;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CollectionElementField;
import org.openl.types.impl.CollectionType;
import org.openl.types.impl.DynamicObject;
import org.openl.types.impl.ThisField;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;

public class TestSuiteMethod
extends ExecutableRulesMethod {
    private static final String PRECISION_PARAM = "precision";
    private static final Pattern DASH_SEPARATOR = Pattern.compile("\\s[-]\\s");
    private IOpenMethod testedMethod;
    private TestDescription[] tests;
    private Map<String, Integer> indexes;
    private final boolean runMethod;
    private DynamicObject[] testObjects;
    private final IDataBase db;
    private ITableModel dataModel;
    private TestSuiteMethod originalTestSuiteMethod;

    public TestSuiteMethod(IOpenMethod testedMethod, IOpenMethodHeader header, TestMethodBoundNode boundNode) {
        super(header, boundNode);
        this.db = boundNode.getDataBase();
        this.testedMethod = testedMethod;
        this.initProperties(this.getSyntaxNode().getTableProperties());
        this.runMethod = XlsNodeTypes.XLS_RUN_METHOD.toString().equals(this.getSyntaxNode().getType());
    }

    public TestSuiteMethod(IOpenMethod testedMethod, TestSuiteMethod target) {
        super(target.getHeader(), target.getBoundNode());
        this.db = target.db;
        this.testedMethod = testedMethod;
        this.initProperties(target.getMethodProperties());
        this.runMethod = target.isRunMethod();
        this.testObjects = target.getTestObjects();
        this.dataModel = target.getDataModel();
        this.originalTestSuiteMethod = target.originalTestSuiteMethod != null ? target.originalTestSuiteMethod : target;
    }

    public TestSuiteMethod getOriginalTestSuiteMethod() {
        return this.originalTestSuiteMethod != null ? this.originalTestSuiteMethod : this;
    }

    private TestDescription[] initTestsAndIndexes() {
        DynamicObject[] testObjects = this.getTestObjects();
        TestDescription[] tests = new TestDescription[testObjects.length];
        this.indexes = new HashMap<String, Integer>(tests.length);
        Map<String, Object> properties = this.getProperties();
        Integer precision = null;
        if (properties != null && properties.containsKey(PRECISION_PARAM)) {
            precision = Integer.parseInt(properties.get(PRECISION_PARAM).toString());
        }
        IOpenMethod testedMethod = this.getTestedMethod();
        ArrayList<IOpenField> fieldsToTest = new ArrayList<IOpenField>();
        ArrayList<IOpenField> errorFieldsToTest = new ArrayList<IOpenField>();
        TestSuiteMethod.createFieldsToTest(fieldsToTest, errorFieldsToTest, testedMethod, this.getDataModel(), precision);
        for (int i = 0; i < tests.length; ++i) {
            tests[i] = new TestDescription(testedMethod, testObjects[i], fieldsToTest, errorFieldsToTest, this.getDataModel(), this.db);
            tests[i].setIndex(i);
            this.indexes.put(tests[i].getId(), i);
        }
        return tests;
    }

    public synchronized int[] getIndices(String ids) {
        String[] ranges;
        if (this.tests == null) {
            this.initTestsAndIndexes();
        }
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (String range : ranges = StringUtils.split((String)ids.trim(), (char)',')) {
            if (range.isEmpty() && this.indexes.containsKey(",")) {
                result.add(this.indexes.get(","));
                continue;
            }
            String v = range.trim();
            if (this.indexes.containsKey(v)) {
                result.add(this.indexes.get(v));
                continue;
            }
            String[] edges = StringUtils.split((String)v, (char)'-');
            if (edges.length > 2 || edges[edges.length - 1].trim().isEmpty()) {
                edges = DASH_SEPARATOR.split(v);
            }
            if (edges.length == 0) {
                if (!this.indexes.containsKey("-")) continue;
                result.add(this.indexes.get("-"));
                continue;
            }
            String startIdValue = edges[0].trim();
            String endIdValue = edges[edges.length - 1].trim();
            int startIndex = this.indexes.get(startIdValue);
            int endIndex = this.indexes.get(endIdValue);
            for (int i = startIndex; i <= endIndex; ++i) {
                result.add(i);
            }
        }
        Integer[] indices = new Integer[result.size()];
        return ArrayUtils.toPrimitive((Integer[])result.toArray(indices));
    }

    @Override
    public TestMethodBoundNode getBoundNode() {
        return (TestMethodBoundNode)super.getBoundNode();
    }

    public BindingDependencies getDependencies() {
        RulesBindingDependencies bindingDependencies = new RulesBindingDependencies();
        this.updateDependency(bindingDependencies);
        return bindingDependencies;
    }

    private void updateDependency(BindingDependencies bindingDependencies) {
        IOpenMethod testedMethod = this.getTestedMethod();
        if (testedMethod instanceof ExecutableRulesMethod || testedMethod instanceof OpenMethodDispatcher) {
            bindingDependencies.addMethodDependency(testedMethod, (IBoundNode)this.getBoundNode());
        }
    }

    public int getNumberOfTestsCases() {
        return this.getTestObjects().length;
    }

    public String getSourceUrl() {
        return this.getSyntaxNode().getUri();
    }

    public DynamicObject[] getTestObjects() {
        this.initializeTestData();
        return this.testObjects;
    }

    public synchronized TestDescription[] getTests() {
        if (this.tests == null) {
            this.tests = this.initTestsAndIndexes();
        }
        return this.tests;
    }

    public TestDescription getTest(int numberOfTest) {
        return this.getTests()[numberOfTest];
    }

    public void setTestedMethod(IOpenMethod testedMethod) {
        this.testedMethod = testedMethod;
    }

    public String getColumnDisplayName(String columnTechnicalName) {
        int columnIndex = this.getColumnIndex(columnTechnicalName);
        return this.getColumnDisplayName(columnIndex);
    }

    public int getColumnIndex(String columnName) {
        ColumnDescriptor[] descriptors;
        for (ColumnDescriptor descriptor : descriptors = this.getDataModel().getDescriptors()) {
            if (descriptor == null || !descriptor.getName().equals(columnName)) continue;
            return descriptor.getColumnIdx();
        }
        return -1;
    }

    public String getColumnName(int index) {
        if (index >= 0) {
            ColumnDescriptor descriptor = this.getDataModel().getDescriptor(index);
            return descriptor == null ? null : descriptor.getName();
        }
        return null;
    }

    public String getColumnDisplayName(int index) {
        if (index >= 0) {
            ColumnDescriptor descriptor = this.getDataModel().getDescriptor(index);
            return descriptor == null ? null : descriptor.getDisplayName();
        }
        return null;
    }

    public int getColumnsCount() {
        return this.getDataModel().getColumnCount();
    }

    public IOpenMethod getTestedMethod() {
        return this.testedMethod;
    }

    @Override
    protected boolean isMethodCacheable() {
        return false;
    }

    @Override
    protected TestUnitsResults innerInvoke(Object target, Object[] params, IRuntimeEnv env) {
        return new TestSuite(this).invoke(target, env);
    }

    public boolean isRunMethod() {
        return this.runMethod;
    }

    public boolean isRunmethodTestable() {
        for (int i = 0; i < this.getNumberOfTestsCases(); ++i) {
            if (!this.getTest(i).isExpectedResultDefined() && !this.getTest(i).isExpectedErrorDefined() && !this.containsFieldsForSprCellTests(this.getTest(i).getTestObject().getFieldValues().keySet()) && !(this.testedMethod instanceof Spreadsheet)) continue;
            return true;
        }
        return false;
    }

    private boolean containsFieldsForSprCellTests(Set<String> fieldNames) {
        for (String fieldName : fieldNames) {
            if (!fieldName.startsWith("$")) continue;
            return true;
        }
        return false;
    }

    public ITableModel getDataModel() {
        this.initializeTestData();
        return this.dataModel;
    }

    private void initializeTestData() {
        if (this.dataModel == null) {
            this.testObjects = (DynamicObject[])this.getBoundNode().getField().getData();
            this.dataModel = this.getBoundNode().getTable().getDataModel();
        }
    }

    private static void createFieldsToTest(List<IOpenField> fieldsToTest, List<IOpenField> errorFieldsToTest, IOpenMethod testedMethod, ITableModel dataModel, Integer testTablePrecision) {
        for (int colNum = 0; colNum < dataModel.getColumnCount(); ++colNum) {
            int i;
            IOpenField[] fieldSequence;
            IOpenClass resultType;
            List<IOpenField> toAdd;
            Object[] nodes;
            ColumnDescriptor columnDescriptor = dataModel.getDescriptor(colNum);
            if (columnDescriptor == null || (nodes = columnDescriptor.getFieldChainTokens()).length == 0) continue;
            if (nodes[0].getIdentifier().startsWith("_res_")) {
                toAdd = fieldsToTest;
                resultType = testedMethod.getType();
            } else {
                if (!nodes[0].getIdentifier().startsWith("_error_")) continue;
                toAdd = errorFieldsToTest;
                resultType = JavaOpenClass.getOpenClass(TestError.class);
            }
            Integer fieldPrecision = testTablePrecision;
            if (nodes.length > 1 && StringUtils.matches((Pattern)DataTableBindHelper.PRECISION_PATTERN, (CharSequence)nodes[nodes.length - 1].getIdentifier())) {
                fieldPrecision = DataTableBindHelper.getPrecisionValue(nodes[nodes.length - 1]);
                nodes = (IdentifierNode[])ArrayUtils.remove((Object[])nodes, (int)(nodes.length - 1));
            }
            boolean resIsCollection = TestSuiteMethod.isCollectionType(nodes[0].getIdentifier());
            int startIndex = 0;
            IOpenClass currentType = resultType;
            if (resIsCollection) {
                CollectionElementField arrayAccessField;
                startIndex = 1;
                fieldSequence = new IOpenField[nodes.length];
                ThisField arrayField = new ThisField(resultType);
                CollectionType collectionType = TestSuiteMethod.getCollectionType(arrayField.getType());
                if (collectionType == CollectionType.MAP) {
                    Object key = DataTableBindHelper.getCollectionKey((IdentifierNode)nodes[0]);
                    arrayAccessField = new CollectionElementField((IOpenField)arrayField, key, arrayField.getType().getComponentClass());
                } else {
                    int index = DataTableBindHelper.getCollectionIndex((IdentifierNode)nodes[0]);
                    arrayAccessField = new CollectionElementField((IOpenField)arrayField, index, arrayField.getType().getComponentClass(), collectionType);
                }
                currentType = arrayAccessField.getType().isArray() ? arrayAccessField.getType().getComponentClass() : arrayAccessField.getType();
                fieldSequence[0] = arrayAccessField;
            } else {
                fieldSequence = new IOpenField[nodes.length - 1];
            }
            for (i = startIndex; i < fieldSequence.length; ++i) {
                String identifier = nodes[i + 1 - startIndex].getIdentifier();
                boolean isCollection = TestSuiteMethod.isCollectionType(identifier);
                if (isCollection) {
                    IOpenField arrayField = currentType.getField(DataTableBindHelper.getCollectionName((IdentifierNode)nodes[i + 1 - startIndex]));
                    if (arrayField == null && currentType.equals(JavaOpenClass.OBJECT) && StringUtils.matches((Pattern)DataTableBindHelper.SPREADSHEETRESULT_FIELD_PATTERN, (CharSequence)identifier)) {
                        JavaOpenClass spreadsheetResultOpenClass = JavaOpenClass.getOpenClass(SpreadsheetResult.class);
                        arrayField = spreadsheetResultOpenClass.getField(DataTableBindHelper.getCollectionName((IdentifierNode)nodes[i + 1 - startIndex]));
                    }
                    if (arrayField != null) {
                        CollectionElementField arrayAccessField;
                        IOpenClass type = arrayField.getType();
                        CollectionType collectionType = TestSuiteMethod.getCollectionType(type);
                        if (collectionType == CollectionType.MAP) {
                            Object key = DataTableBindHelper.getCollectionKey((IdentifierNode)nodes[i + 1 - startIndex]);
                            arrayAccessField = new CollectionElementField(arrayField, key, type.getComponentClass());
                        } else {
                            int arrayIndex = DataTableBindHelper.getCollectionIndex((IdentifierNode)nodes[i + 1 - startIndex]);
                            arrayAccessField = new CollectionElementField(arrayField, arrayIndex, type.getComponentClass(), collectionType);
                        }
                        fieldSequence[i] = arrayAccessField;
                    }
                } else {
                    JavaOpenClass spreadsheetResultOpenClass;
                    IOpenField openField;
                    fieldSequence[i] = currentType.getField(identifier);
                    if (fieldSequence[i] == null && StringUtils.matches((Pattern)DataTableBindHelper.SPREADSHEETRESULT_FIELD_PATTERN, (CharSequence)identifier) && (openField = (spreadsheetResultOpenClass = JavaOpenClass.getOpenClass(SpreadsheetResult.class)).getField(identifier)) != null) {
                        fieldSequence[i] = openField;
                    }
                }
                if (fieldSequence[i] == null) break;
                currentType = fieldSequence[i].getType().isArray() && isCollection ? fieldSequence[i].getType().getComponentClass() : fieldSequence[i].getType();
            }
            if (i != 0 && i != fieldSequence.length) continue;
            if (fieldSequence.length == 0) {
                if (columnDescriptor.isReference()) {
                    if (resultType.isSimple() || resultType.isArray()) {
                        toAdd.add((IOpenField)new ThisField(resultType));
                        continue;
                    }
                    toAdd.addAll(resultType.getFields());
                    continue;
                }
                fieldSequence = new IOpenField[]{new ThisField(resultType)};
            }
            if (fieldPrecision != null) {
                toAdd.add((IOpenField)new PrecisionFieldChain(currentType, fieldSequence, fieldPrecision));
                continue;
            }
            if (fieldSequence.length > 1) {
                boolean hasNull = false;
                for (IOpenField field : fieldSequence) {
                    if (field != null) continue;
                    hasNull = true;
                    break;
                }
                if (hasNull) continue;
                toAdd.add((IOpenField)new FieldChain(currentType, fieldSequence));
                continue;
            }
            IOpenField field = fieldSequence[0];
            if (field == null) continue;
            toAdd.add(field);
        }
    }

    private static boolean isCollectionType(String identifier) {
        return StringUtils.matches((Pattern)DataTableBindHelper.COLLECTION_ACCESS_BY_INDEX_PATTERN, (CharSequence)identifier) || StringUtils.matches((Pattern)DataTableBindHelper.COLLECTION_ACCESS_BY_KEY_PATTERN, (CharSequence)identifier);
    }

    private static CollectionType getCollectionType(IOpenClass type) {
        Class instanceClass = type.getInstanceClass();
        if (ClassUtils.isAssignable((Class)instanceClass, List.class)) {
            return CollectionType.LIST;
        }
        if (ClassUtils.isAssignable((Class)instanceClass, Map.class)) {
            return CollectionType.MAP;
        }
        return CollectionType.ARRAY;
    }

    @Override
    public void clearForExecutionMode() {
        this.initializeTestData();
        super.clearForExecutionMode();
    }
}

