/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.testmethod;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.testmethod.BaseTestUnit;
import org.openl.rules.testmethod.ITestResultBuilder;
import org.openl.rules.testmethod.ITestUnit;
import org.openl.rules.testmethod.ParameterWithValueDeclaration;
import org.openl.rules.testmethod.TestDescription;
import org.openl.rules.testmethod.TestError;
import org.openl.rules.testmethod.TestUnitsResults;
import org.openl.rules.testmethod.TestUtils;
import org.openl.rules.testmethod.result.ComparedResult;

public class TestUnit
extends BaseTestUnit {
    private final Object expectedResult;
    private final TestError expectedError;
    private final Object actualResult;

    TestUnit(TestDescription test, Object res, Throwable error, long executionTime) {
        super(test, res, error, executionTime);
        this.expectedError = test.getExpectedError();
        this.expectedResult = test.getExpectedResult();
        this.actualResult = res;
    }

    @Override
    public Object getExpectedResult() {
        return this.expectedError == null ? this.expectedResult : this.expectedError;
    }

    @Override
    public Object getActualResult() {
        Throwable actualError = this.getActualError();
        return actualError == null ? this.actualResult : actualError;
    }

    @Override
    public ParameterWithValueDeclaration getActualParam() {
        return new ParameterWithValueDeclaration("actual", this.getActualResult());
    }

    @Override
    public ParameterWithValueDeclaration[] getContextParams(TestUnitsResults objTestResult) {
        return TestUtils.getContextParams(objTestResult.getTestSuite(), this.getTest());
    }

    @Override
    public List<ComparedResult> getResultParams() {
        ArrayList<ComparedResult> params = new ArrayList<ComparedResult>();
        for (ComparedResult comparedResult : this.getComparisonResults()) {
            ComparedResult copy = new ComparedResult(comparedResult.getFieldName(), this.buildParameterDeclaration(comparedResult.getFieldName(), "expectedResult", comparedResult.getExpectedValue()), this.buildParameterDeclaration(comparedResult.getFieldName(), "actualResult", comparedResult.getActualValue()), comparedResult.getStatus());
            params.add(copy);
        }
        return params;
    }

    private ParameterWithValueDeclaration buildParameterDeclaration(String fieldName, String defaultName, Object value) {
        if (fieldName == null) {
            fieldName = defaultName;
        }
        return new ParameterWithValueDeclaration(fieldName, value);
    }

    @Override
    public List<OpenLMessage> getErrors() {
        Throwable actualError = this.getActualError();
        if (actualError != null) {
            return OpenLMessagesUtils.newErrorMessages((Throwable)actualError);
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean writeFailuresOnly() {
        return false;
    }

    public static class Builder
    implements ITestResultBuilder {
        private static final Builder instance = new Builder();

        private Builder() {
        }

        public static Builder getInstance() {
            return instance;
        }

        @Override
        public ITestUnit build(TestDescription test, Object res, Throwable error, long executionTime) {
            return new TestUnit(test, res, error, executionTime);
        }
    }
}

