/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;

public class StyleTrackingListener
implements HSSFListener {
    private final HSSFListener delegate;
    private final Map<Integer, FormatRecord> customFormats = new HashMap<Integer, FormatRecord>();
    private final List<ExtendedFormatRecord> extendedFormats = new ArrayList<ExtendedFormatRecord>();
    private final List<FontRecord> fonts = new ArrayList<FontRecord>();

    StyleTrackingListener(HSSFListener delegate) {
        this.delegate = delegate;
    }

    public void processRecord(Record record) {
        if (record instanceof FormatRecord) {
            FormatRecord fr = (FormatRecord)record;
            this.customFormats.put(fr.getIndexCode(), fr);
        }
        if (record instanceof ExtendedFormatRecord) {
            ExtendedFormatRecord xr = (ExtendedFormatRecord)record;
            this.extendedFormats.add(xr);
        }
        if (record instanceof FontRecord) {
            this.fonts.add((FontRecord)record);
        }
        this.delegate.processRecord(record);
    }

    public String getFormatString(int formatIndex) {
        if (formatIndex < 0) {
            return null;
        }
        String format = formatIndex >= HSSFDataFormat.getNumberOfBuiltinBuiltinFormats() || this.customFormats.get(formatIndex) != null ? this.customFormats.get(formatIndex).getFormatString() : HSSFDataFormat.getBuiltinFormat((short)((short)formatIndex));
        return format;
    }

    public int getFormatIndex(CellValueRecordInterface cell) {
        ExtendedFormatRecord xfr = this.extendedFormats.get(cell.getXFIndex());
        if (xfr == null) {
            return -1;
        }
        return xfr.getFormatIndex();
    }

    public short getIndent(CellValueRecordInterface cell) {
        ExtendedFormatRecord xfr = this.extendedFormats.get(cell.getXFIndex());
        return xfr == null ? (short)0 : xfr.getIndent();
    }

    List<ExtendedFormatRecord> getExtendedFormats() {
        return this.extendedFormats;
    }

    Map<Integer, FormatRecord> getCustomFormats() {
        return this.customFormats;
    }

    List<FontRecord> getFonts() {
        return this.fonts;
    }
}

