/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import java.lang.ref.WeakReference;
import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.lang.xls.SpreadsheetConstants;
import org.openl.rules.lang.xls.load.LazySheetLoader;
import org.openl.rules.lang.xls.load.SheetLoader;
import org.openl.rules.lang.xls.load.WorkbookLoadUtils;
import org.openl.rules.lang.xls.load.WorkbookLoader;
import org.openl.source.IOpenSourceCodeModule;

public class UnloadableLazyWorkbookLoader
implements WorkbookLoader {
    private final IOpenSourceCodeModule fileSource;
    private boolean canUnload = true;
    private Workbook workbook;
    private WeakReference<Workbook> workbookCache = new WeakReference<Object>(null);
    private Integer numberOfSheetsCache;
    private SpreadsheetConstants spreadsheetConstantsCache;

    public UnloadableLazyWorkbookLoader(IOpenSourceCodeModule fileSource) {
        this.fileSource = fileSource;
    }

    @Override
    public Workbook getWorkbook() {
        Workbook cachedWorkbook = (Workbook)this.workbookCache.get();
        if (cachedWorkbook != null) {
            return cachedWorkbook;
        }
        Workbook wb = this.workbook != null ? this.workbook : this.loadWorkbook();
        this.workbookCache = new WeakReference<Workbook>(wb);
        if (!this.canUnload) {
            this.workbook = wb;
        }
        return wb;
    }

    protected Workbook loadWorkbook() {
        return WorkbookLoadUtils.loadWorkbook(this.fileSource);
    }

    @Override
    public SheetLoader getSheetLoader(int sheetIndex) {
        return new LazySheetLoader(this, sheetIndex);
    }

    @Override
    public boolean isCanUnload() {
        return this.canUnload;
    }

    @Override
    public void setCanUnload(boolean canUnload) {
        this.canUnload = canUnload;
        if (canUnload) {
            this.workbook = null;
        }
    }

    @Override
    public int getNumberOfSheets() {
        Integer numberOfSheets = this.numberOfSheetsCache;
        if (numberOfSheets == null) {
            numberOfSheets = this.getWorkbook().getNumberOfSheets();
            if (this.canUnload) {
                this.numberOfSheetsCache = numberOfSheets;
            }
        }
        return numberOfSheets;
    }

    @Override
    public SpreadsheetConstants getSpreadsheetConstants() {
        SpreadsheetConstants spreadsheetConstants = this.spreadsheetConstantsCache;
        if (spreadsheetConstants == null) {
            spreadsheetConstants = new SpreadsheetConstants(this.getWorkbook().getSpreadsheetVersion());
            if (this.canUnload) {
                this.spreadsheetConstantsCache = spreadsheetConstants;
            }
        }
        return spreadsheetConstants;
    }
}

