/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openl.binding.BindingDependencies;
import org.openl.rules.annotations.Executable;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.tbasic.AlgorithmBoundNode;
import org.openl.rules.tbasic.AlgorithmFunction;
import org.openl.rules.tbasic.AlgorithmInvoker;
import org.openl.rules.tbasic.AlgorithmSubroutineMethod;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.vm.IRuntimeEnv;

@Executable
public class Algorithm
extends AlgorithmFunction {
    private IOpenClass thisClass;
    private List<RuntimeOperation> algorithmSteps;
    private Map<String, RuntimeOperation> labels;
    private Invokable invoker;

    public static Algorithm createAlgorithm(IOpenMethodHeader header, AlgorithmBoundNode node) {
        return new Algorithm(header, node);
    }

    public Algorithm() {
        super(null, null);
    }

    public Algorithm(IOpenMethodHeader header, AlgorithmBoundNode node) {
        super(header, node);
        this.initProperties(this.getSyntaxNode().getTableProperties());
    }

    public String getSourceUrl() {
        return this.getSyntaxNode().getUri();
    }

    @Override
    protected Object innerInvoke(Object target, Object[] params, IRuntimeEnv env) {
        if (this.invoker == null) {
            this.invoker = new AlgorithmInvoker(this);
        }
        return this.invoker.invoke(target, params, env);
    }

    @Override
    public void setAlgorithmSteps(List<RuntimeOperation> algorithmSteps) {
        this.algorithmSteps = algorithmSteps;
    }

    @Override
    public void setLabels(Map<String, RuntimeOperation> labels) {
        this.labels = labels;
    }

    public void setThisClass(IOpenClass thisClass) {
        this.thisClass = thisClass;
    }

    @Override
    public List<RuntimeOperation> getAlgorithmSteps() {
        return this.algorithmSteps;
    }

    protected Map<String, RuntimeOperation> getLabels() {
        return this.labels;
    }

    protected IOpenClass getThisClass() {
        return this.thisClass;
    }

    public BindingDependencies getDependencies() {
        RulesBindingDependencies bindingDependencies = new RulesBindingDependencies();
        this.getBoundNode().updateDependency(bindingDependencies);
        return bindingDependencies;
    }

    public Collection<AlgorithmSubroutineMethod> getSubroutines() {
        IOpenClass thisIOpenClass = this.getThisClass();
        if (thisIOpenClass == null) {
            return Collections.emptyList();
        }
        ArrayList<AlgorithmSubroutineMethod> subroutines = new ArrayList<AlgorithmSubroutineMethod>();
        for (IOpenMethod method : thisIOpenClass.getMethods()) {
            if (!(method instanceof AlgorithmSubroutineMethod)) continue;
            subroutines.add((AlgorithmSubroutineMethod)method);
        }
        return subroutines;
    }
}

