/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.record.ArrayRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.TableRecord;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;
import org.apache.poi.ss.util.CellReference;
import org.openl.excel.parser.event.EventSheetDescriptor;

public class SharedValueListener
implements HSSFListener {
    private final EventSheetDescriptor sheet;
    private int sheetIndex = -1;
    private final List<SharedFormulaRecord> sharedFormulaRecords = new ArrayList<SharedFormulaRecord>();
    private final List<CellReference> firstCellRefs = new ArrayList<CellReference>();
    private final List<ArrayRecord> arrayRecords = new ArrayList<ArrayRecord>();
    private final List<TableRecord> tableRecords = new ArrayList<TableRecord>();
    private FormulaRecord currentFormula;

    public SharedValueListener(EventSheetDescriptor sheet) {
        this.sheet = sheet;
    }

    public void processRecord(Record record) {
        switch (record.getSid()) {
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() != 16) break;
                ++this.sheetIndex;
                break;
            }
            case 6: {
                if (!this.isNeededSheet()) break;
                this.currentFormula = (FormulaRecord)record;
                break;
            }
            case 1212: {
                if (!this.isNeededSheet()) break;
                this.sharedFormulaRecords.add((SharedFormulaRecord)record);
                this.firstCellRefs.add(new CellReference(this.currentFormula.getRow(), this.currentFormula.getColumn()));
                break;
            }
            case 545: {
                if (!this.isNeededSheet()) break;
                this.arrayRecords.add((ArrayRecord)record);
                break;
            }
            case 566: {
                if (!this.isNeededSheet()) break;
                this.tableRecords.add((TableRecord)record);
            }
        }
    }

    private boolean isNeededSheet() {
        return this.sheetIndex == this.sheet.getIndex();
    }

    public SharedValueManager getSharedValueManager() {
        return SharedValueManager.create((SharedFormulaRecord[])this.sharedFormulaRecords.toArray(new SharedFormulaRecord[0]), (CellReference[])this.firstCellRefs.toArray(new CellReference[0]), (ArrayRecord[])this.arrayRecords.toArray(new ArrayRecord[0]), (TableRecord[])this.tableRecords.toArray(new TableRecord[0]));
    }
}

