/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.LocaleDependConvertor;

class String2DateConvertor
implements IString2DataConvertor<Date> {
    String2DateConvertor() {
    }

    @Override
    public Date parse(String data, String format) {
        if (data == null) {
            return null;
        }
        if (format != null) {
            SimpleDateFormat df = new SimpleDateFormat(format, LocaleDependConvertor.getLocale());
            try {
                return df.parse(data);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Cannot convert '%s' to date type using: '%s' format", data, format));
            }
        }
        List<DateFormat> dateFormats = Arrays.asList(DateFormat.getDateInstance(3, LocaleDependConvertor.getLocale()), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX", LocaleDependConvertor.getLocale()), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", LocaleDependConvertor.getLocale()), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", LocaleDependConvertor.getLocale()), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm", LocaleDependConvertor.getLocale()), new SimpleDateFormat("yyyy-MM-dd", LocaleDependConvertor.getLocale()));
        for (DateFormat dateFormat : dateFormats) {
            try {
                dateFormat.setLenient(false);
                dateFormat.getCalendar().set(0, 0, 0, 0, 0, 0);
                dateFormat.getCalendar().set(14, 0);
                return dateFormat.parse(data);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert '%s' to Date type", data));
    }
}

