/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import org.openl.rules.convertor.IString2DataConvertor;

class String2LocalDateConvertor
implements IString2DataConvertor<LocalDate> {
    private final List<DateTimeFormatter> supportedFormats = new ArrayList<DateTimeFormatter>();

    String2LocalDateConvertor() {
        this.supportedFormats.add(DateTimeFormatter.ISO_LOCAL_DATE);
        this.supportedFormats.add(DateTimeFormatter.ofPattern("M/dd/yyyy"));
    }

    @Override
    public LocalDate parse(String data, String format) {
        if (data == null) {
            return null;
        }
        for (DateTimeFormatter dtFormat : this.supportedFormats) {
            try {
                return LocalDate.parse(data, dtFormat);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert '%s' to LocalDate type", data));
    }
}

