/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt;

import java.util.Objects;
import org.openl.rules.lang.xls.binding.DTColumnsDefinition;
import org.openl.rules.lang.xls.binding.DTColumnsDefinitionType;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;

public class DTColumnsDefinitionField
implements IOpenField {
    private final IOpenClass type;
    private final IOpenClass declaringClass;
    private final String name;
    private final String title;
    private final DTColumnsDefinition dtColumnsDefinition;

    DTColumnsDefinitionField(String name, IOpenClass type, IOpenClass declaringClass, DTColumnsDefinition dtColumnsDefinition, String title) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.declaringClass = Objects.requireNonNull(declaringClass, "declaringClass cannot be null");
        this.dtColumnsDefinition = Objects.requireNonNull(dtColumnsDefinition, "dtColumnsDefinition cannot be null");
        this.title = title;
    }

    public String getDisplayName(int mode) {
        StringBuilder sb = new StringBuilder();
        sb.append("'").append(this.name).append("'");
        if (!StringUtils.isEmpty((CharSequence)this.title)) {
            sb.append(String.format(" with column title '%s'", this.title));
        }
        sb.append(" in external ");
        if (this.dtColumnsDefinition.getType() == DTColumnsDefinitionType.RETURN) {
            sb.append("return");
        } else if (this.dtColumnsDefinition.getType() == DTColumnsDefinitionType.ACTION) {
            sb.append("action");
        } else if (this.dtColumnsDefinition.getType() == DTColumnsDefinitionType.CONDITION) {
            sb.append("condition");
        }
        sb.append(" table");
        if (!StringUtils.isEmpty((CharSequence)this.dtColumnsDefinition.getTableName())) {
            sb.append(" '").append(this.dtColumnsDefinition.getTableName()).append("'");
        }
        return sb.toString();
    }

    public DTColumnsDefinition getDtColumnsDefinition() {
        return this.dtColumnsDefinition;
    }

    public String getName() {
        return this.name;
    }

    public IOpenClass getType() {
        return this.type;
    }

    public boolean isStatic() {
        return false;
    }

    public IMemberMetaInfo getInfo() {
        return null;
    }

    public IOpenClass getDeclaringClass() {
        return this.declaringClass;
    }

    public Object get(Object target, IRuntimeEnv env) {
        throw new UnsupportedOperationException();
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        throw new UnsupportedOperationException();
    }

    public boolean isConst() {
        return false;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isContextProperty() {
        return false;
    }

    public String getContextProperty() {
        return null;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }
}

