/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.util.Date;
import java.util.Objects;
import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.ILocalVar;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DecisionTableRuntimePool;
import org.openl.rules.dt.algorithm.evaluator.IConditionEvaluator;
import org.openl.rules.dt.data.RuleExecutionObject;
import org.openl.rules.dt.element.ConditionCasts;
import org.openl.rules.dt.element.ConditionHelper;
import org.openl.rules.dt.element.DecisionValue;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.helpers.CharRange;
import org.openl.rules.helpers.DateRange;
import org.openl.rules.helpers.DoubleRange;
import org.openl.rules.helpers.INumberRange;
import org.openl.rules.helpers.IntRange;
import org.openl.rules.helpers.NumberUtils;
import org.openl.rules.helpers.StringRange;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.GridTableUtils;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IDynamicObject;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.OpenFieldDelegator;
import org.openl.util.ClassUtils;
import org.openl.util.MessageUtils;
import org.openl.vm.IRuntimeEnv;

public class Condition
extends FunctionalRow
implements ICondition {
    private IMethodCaller evaluator;
    private IConditionEvaluator conditionEvaluator;
    private IOpenSourceCodeModule userDefinedOpenSourceCodeModule;
    private boolean conditionParametersUsed;
    private boolean ruleIdOrRuleNameUsed;
    private boolean dependentOnOtherColumnsParams;
    private IOpenCast comparisonCast;

    public Condition(String name, int row, ILogicalTable table, DTScale.RowScale scale) {
        super(name, row, table, scale);
    }

    @Override
    public IParameterDeclaration[] getParams() {
        IParameterDeclaration[] params = super.getParams();
        return params == null ? IParameterDeclaration.EMPTY : params;
    }

    @Override
    public IConditionEvaluator getConditionEvaluator() {
        return this.conditionEvaluator;
    }

    @Override
    public void setConditionEvaluator(IConditionEvaluator conditionEvaluator) {
        this.conditionEvaluator = conditionEvaluator;
    }

    @Override
    public boolean isAction() {
        return false;
    }

    @Override
    public boolean isCondition() {
        return true;
    }

    @Override
    public IMethodCaller getEvaluator() {
        return this.evaluator == null ? this.getMethod() : this.evaluator;
    }

    @Override
    public void setEvaluator(IMethodCaller evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public DecisionValue calculateCondition(int ruleN, Object target, Object[] dtParams, IRuntimeEnv env) {
        if (target instanceof IDynamicObject) {
            target = new RuleExecutionObject(this.ruleExecutionType, (IDynamicObject)target, ruleN);
        }
        if (this.isEmpty(ruleN)) {
            return DecisionValue.NxA_VALUE;
        }
        if (this.conditionParametersUsed || this.ruleIdOrRuleNameUsed || this.dependentOnOtherColumnsParams) {
            return this.makeDecision(ruleN, target, dtParams, env);
        }
        DecisionTableRuntimePool runtimePool = (DecisionTableRuntimePool)env.getLocalFrame()[0];
        DecisionValue decisionValue = (DecisionValue)runtimePool.getConditionExecutionResult(this.getName());
        if (decisionValue == null) {
            decisionValue = this.makeDecision(ruleN, target, dtParams, env);
            runtimePool.pushConditionExecutionResultToPool(this.getName(), decisionValue);
        }
        return decisionValue;
    }

    @Override
    public void setComparisonCast(IOpenCast comparisonCast) {
        this.comparisonCast = comparisonCast;
    }

    private DecisionValue makeDecision(int ruleN, Object target, Object[] dtParams, IRuntimeEnv env) {
        Object[] params = this.mergeParams(target, dtParams, env, ruleN);
        Object result = this.getMethod().invoke(target, params, env);
        if (this.comparisonCast != null) {
            return Objects.equals(result = this.comparisonCast.convert(result), params[params.length - 1]) ? DecisionValue.TRUE_VALUE : DecisionValue.FALSE_VALUE;
        }
        return Boolean.TRUE.equals(result) ? DecisionValue.TRUE_VALUE : DecisionValue.FALSE_VALUE;
    }

    public static IOpenField getLocalField(IOpenField f) {
        if (f instanceof ILocalVar) {
            return f;
        }
        if (f instanceof OpenFieldDelegator) {
            OpenFieldDelegator d = (OpenFieldDelegator)f;
            return d.getDelegate();
        }
        return f;
    }

    @Override
    public boolean isDependentOnInputParams() {
        IParameterDeclaration[] params = this.getParams();
        RulesBindingDependencies dependencies = new RulesBindingDependencies();
        this.getMethod().updateDependency((BindingDependencies)dependencies);
        for (IOpenField field : dependencies.getFieldsMap().values()) {
            if (!((field = Condition.getLocalField(field)) instanceof ILocalVar)) continue;
            for (IParameterDeclaration param : params) {
                if (!Objects.equals(field.getName(), param.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IOpenSourceCodeModule getUserDefinedExpressionSource() {
        if (this.userDefinedOpenSourceCodeModule == null) {
            return this.getSourceCodeModule();
        }
        return this.userDefinedOpenSourceCodeModule;
    }

    @Override
    protected IOpenSourceCodeModule getExpressionSource(TableSyntaxNode tableSyntaxNode, IMethodSignature signature, IOpenClass methodParamType, IOpenClass declaringClass, OpenL openl, IBindingContext bindingContext) throws Exception {
        if (!GridTableUtils.isSingleCellTable(this.getCodeTable())) {
            ILogicalTable redundantRow = (ILogicalTable)this.getCodeTable().getRow(1);
            GridCellSourceCodeModule errorSrc = new GridCellSourceCodeModule(redundantRow.getSource(), bindingContext);
            throw SyntaxNodeExceptionUtils.createError((String)MessageUtils.getConditionMultipleExpressionErrorMessage((String)this.getName()), (IOpenSourceCodeModule)errorSrc);
        }
        IOpenSourceCodeModule source = super.getExpressionSource(tableSyntaxNode, signature, methodParamType, declaringClass, openl, bindingContext);
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            if (!signature.getParameterName(i).equals(source.getCode())) continue;
            this.userDefinedOpenSourceCodeModule = source;
            this.prepareParams(declaringClass, signature, methodParamType, source, openl, bindingContext);
            if (this.params.length == 1) {
                if (this.params[0].getType().isArray() && this.params[0].getType().getComponentClass().getInstanceClass() != null) {
                    IOpenClass inputType = signature.getParameterType(i);
                    ConditionCasts conditionCasts = ConditionHelper.findConditionCasts(this.params[0].getType().getComponentClass(), inputType, bindingContext);
                    if (conditionCasts.isCastToConditionTypeExists() || conditionCasts.isCastToInputTypeExists() && !inputType.isArray()) {
                        return !this.hasFormulas() ? source : new StringSourceCodeModule(this.getContainsInArrayExpression(tableSyntaxNode, source, signature.getParameterType(i), this.params[0], conditionCasts, bindingContext), source.getUri());
                    }
                }
                if (Condition.isRangeExpression(signature.getParameterType(i), this.params[0].getType())) {
                    return !this.hasFormulas() ? source : new StringSourceCodeModule(this.getRangeExpression(tableSyntaxNode, source, signature.getParameterType(i), this.params[0], bindingContext), source.getUri());
                }
                return !this.hasFormulas() && (!this.params[0].getType().isArray() || !signature.getParameterType(i).isArray()) ? source : new StringSourceCodeModule(source.getCode() + " == " + this.params[0].getName(), source.getUri());
            }
            if (this.params.length != 2) continue;
            return !this.hasFormulas() ? source : new StringSourceCodeModule(this.params[0].getName() + "<=" + source.getCode() + " and " + source.getCode() + "<" + this.params[1].getName(), source.getUri());
        }
        return source;
    }

    private String getContainsInArrayExpression(TableSyntaxNode tableSyntaxNode, IOpenSourceCodeModule source, IOpenClass methodType, IParameterDeclaration param, ConditionCasts conditionCasts, IBindingContext bindingContext) {
        if (Objects.equals(param.getType().getComponentClass(), methodType)) {
            return String.format("contains(%s, %s)", param.getName(), source.getCode());
        }
        if (conditionCasts.isCastToConditionTypeExists()) {
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)String.format("PERFORMANCE: Condition '%s' uses additional type casting from '%s' to '%s' in calculation time for each table row.", this.getName(), methodType.getName(), param.getType().getComponentClass().getName()), (ISyntaxNode)tableSyntaxNode));
            return String.format("contains(%s, (%s) %s)", param.getName(), param.getType().getComponentClass().getName(), source.getCode());
        }
        if (conditionCasts.isCastToInputTypeExists()) {
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)String.format("PERFORMANCE: Condition '%s' uses additional type casting from '%s' to '%s' in calculation time for each table row.", this.getName(), param.getType().getComponentClass().getInstanceClass().getTypeName(), methodType.getName()), (ISyntaxNode)tableSyntaxNode));
            return String.format("contains((%s[]) %s, %s)", methodType.getName(), param.getName(), source.getCode());
        }
        throw new IllegalStateException("It should not happen.");
    }

    private static boolean isIntRangeType(IOpenClass type) {
        return IntRange.class == type.getInstanceClass();
    }

    private String getRangeExpression(TableSyntaxNode tableSyntaxNode, IOpenSourceCodeModule source, IOpenClass methodType, IParameterDeclaration param, IBindingContext bindingContext) {
        if (Condition.isIntRangeType(param.getType()) && NumberUtils.isFloatPointType(methodType.getInstanceClass())) {
            bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)String.format("PERFORMANCE: Condition '%s' uses additional type casting from '%s' to '%s' in calculation time for each table row.", this.getName(), param.getType().getName(), DoubleRange.class.getTypeName()), (ISyntaxNode)tableSyntaxNode));
        }
        return String.format("contains(%s, %s)", param.getName(), source.getCode());
    }

    private static boolean isRangeExpression(IOpenClass methodType, IOpenClass paramType) {
        if (ClassUtils.isAssignable((Class)paramType.getInstanceClass(), INumberRange.class) && ClassUtils.isAssignable((Class)methodType.getInstanceClass(), Number.class)) {
            return true;
        }
        if (ClassUtils.isAssignable((Class)paramType.getInstanceClass(), INumberRange.class) && methodType.getInstanceClass().isPrimitive() && Character.TYPE != methodType.getInstanceClass()) {
            return true;
        }
        if (ClassUtils.isAssignable((Class)paramType.getInstanceClass(), DateRange.class) && ClassUtils.isAssignable((Class)methodType.getInstanceClass(), Date.class)) {
            return true;
        }
        if (ClassUtils.isAssignable((Class)paramType.getInstanceClass(), CharRange.class) && (ClassUtils.isAssignable((Class)methodType.getInstanceClass(), Character.class) || Character.TYPE == methodType.getInstanceClass())) {
            return true;
        }
        return ClassUtils.isAssignable((Class)paramType.getInstanceClass(), StringRange.class) && ClassUtils.isAssignable((Class)methodType.getInstanceClass(), CharSequence.class);
    }

    @Override
    public int getNumberOfEmptyRules(int paramIndex) {
        if (this.storage != null) {
            return this.storage[paramIndex].getInfo().getNumberOfSpaces();
        }
        return 0;
    }

    @Override
    public void setConditionParametersUsed(boolean conditionParametersUsed) {
        this.conditionParametersUsed = conditionParametersUsed;
    }

    @Override
    public boolean isRuleIdOrRuleNameUsed() {
        return this.ruleIdOrRuleNameUsed;
    }

    @Override
    public void setRuleIdOrRuleNameUsed(boolean ruleIdOrRuleNameUsed) {
        this.ruleIdOrRuleNameUsed = ruleIdOrRuleNameUsed;
    }

    @Override
    public boolean isDependentOnOtherColumnsParams() {
        return this.dependentOnOtherColumnsParams;
    }

    @Override
    public void setDependentOnOtherColumnsParams(boolean dependentOnOtherColumnsParams) {
        this.dependentOnOtherColumnsParams = dependentOnOtherColumnsParams;
    }
}

