/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.rules.data.DataOpenField;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.runtime.RuleInfo;
import org.openl.rules.testmethod.TestSuiteMethod;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.util.ClassUtils;

public class InterfaceGenerator {
    public static final int PUBLIC_ABSTRACT_INTERFACE = 1537;
    public static final int PUBLIC_ABSTRACT = 1025;
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";

    public static Class<?> generateInterface(String className, RuleInfo[] rules, ClassLoader classLoader) throws Exception {
        ClassWriter classWriter = new ClassWriter(0);
        String name = className.replace('.', '/');
        classWriter.visit(52, 1537, name, null, JAVA_LANG_OBJECT, null);
        for (RuleInfo ruleInfo : rules) {
            String ruleName = ruleInfo.getName();
            classWriter.visitMethod(1025, ruleName, InterfaceGenerator.getMethodTypes(ruleInfo), null, null);
        }
        classWriter.visitEnd();
        ClassUtils.defineClass((String)className, (byte[])classWriter.toByteArray(), (ClassLoader)classLoader);
        return Class.forName(className, true, classLoader);
    }

    public static Class<?> generateInterface(String className, IOpenClass openClass, ClassLoader classLoader, String[] includes, String[] excludes) throws Exception {
        RuleInfo ruleInfo;
        boolean isMember;
        if (!((String)className).contains(".")) {
            className = "org.openl.generated.interfaces." + (String)className;
        }
        if (openClass == null) {
            return InterfaceGenerator.generateInterface((String)className, RuleInfo.EMPTY_RULES, classLoader);
        }
        ArrayList<RuleInfo> rules = new ArrayList<RuleInfo>();
        HashSet<MethodKey> methodsInClass = new HashSet<MethodKey>();
        HashMap<IOpenClass, Boolean> validationMap = new HashMap<IOpenClass, Boolean>();
        Collection methods = openClass.getMethods();
        for (IOpenMethod method : methods) {
            if (InterfaceGenerator.isIgnoredMember((IOpenMember)method, validationMap) || !(isMember = InterfaceGenerator.isMember(ruleInfo = InterfaceGenerator.getRuleInfoForMethod(method), includes, excludes))) continue;
            rules.add(ruleInfo);
            methodsInClass.add(new MethodKey(method));
        }
        for (IOpenField field : openClass.getFields()) {
            MethodKey key;
            if (InterfaceGenerator.isIgnoredMember((IOpenMember)field, validationMap) || !field.isReadable() || !(isMember = InterfaceGenerator.isMember(ruleInfo = InterfaceGenerator.getRuleInfoForField(field), includes, excludes)) || methodsInClass.contains(key = new MethodKey(ruleInfo.getName(), IOpenClass.EMPTY))) continue;
            rules.add(ruleInfo);
            methodsInClass.add(key);
        }
        return InterfaceGenerator.generateInterface((String)className, rules.toArray(RuleInfo.EMPTY_RULES), classLoader);
    }

    private static boolean isMember(RuleInfo ruleInfo, String[] includes, String[] excludes) {
        boolean isMember = true;
        String methodSignature = InterfaceGenerator.getRuleInfoSignature(ruleInfo);
        if (includes != null && includes.length > 0) {
            isMember = false;
            for (String pattern : includes) {
                if (!Pattern.matches(pattern, methodSignature)) continue;
                isMember = true;
            }
        }
        if (excludes != null && excludes.length > 0 && isMember) {
            for (String pattern : excludes) {
                if (!Pattern.matches(pattern, methodSignature)) continue;
                isMember = false;
            }
        }
        return isMember;
    }

    private static String getRuleInfoSignature(RuleInfo ruleInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(ruleInfo.getReturnType().getCanonicalName());
        sb.append(" ");
        sb.append(ruleInfo.getName());
        sb.append("(");
        boolean first = true;
        for (Class<?> paramType : ruleInfo.getParamTypes()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(paramType.getCanonicalName());
        }
        sb.append(")");
        return sb.toString();
    }

    private static RuleInfo getRuleInfoForField(IOpenField field) {
        String methodName = ClassUtils.getter((String)field.getName());
        Class[] paramTypes = new Class[]{};
        Class returnType = field.getType().getInstanceClass();
        return InterfaceGenerator.createRuleInfo(methodName, paramTypes, returnType);
    }

    private static RuleInfo getRuleInfoForMethod(IOpenMethod method) {
        String methodName = method.getName();
        IOpenClass[] paramClasses = method.getSignature().getParameterTypes();
        Class<Object> returnType = method.getType().getInstanceClass();
        if (returnType == null) {
            returnType = Object.class;
        }
        Class<?>[] paramTypes = InterfaceGenerator.getInstanceClasses(paramClasses);
        return InterfaceGenerator.createRuleInfo(methodName, paramTypes, returnType);
    }

    public static RuleInfo createRuleInfo(String ruleName, Class<?>[] paramTypes, Class<?> returnType) {
        RuleInfo ruleInfo = new RuleInfo();
        ruleInfo.setName(ruleName);
        ruleInfo.setParamTypes(paramTypes);
        ruleInfo.setReturnType(returnType);
        return ruleInfo;
    }

    private static boolean isIgnoredMember(IOpenMember member, Map<IOpenClass, Boolean> validationMap) {
        DataOpenField dataOpenField;
        if (member instanceof DataOpenField && (XlsNodeTypes.XLS_RUN_METHOD.equals((Object)(dataOpenField = (DataOpenField)member).getNodeType()) || XlsNodeTypes.XLS_TEST_METHOD.equals((Object)dataOpenField.getNodeType()))) {
            return true;
        }
        if (InterfaceGenerator.isInvalidType(member.getType(), validationMap)) {
            return true;
        }
        if (member instanceof IOpenMethod) {
            IOpenMethod openMethod = (IOpenMethod)member;
            for (IOpenClass parameterType : openMethod.getSignature().getParameterTypes()) {
                if (!InterfaceGenerator.isInvalidType(parameterType, validationMap)) continue;
                return true;
            }
        }
        return member instanceof JavaOpenConstructor || member instanceof ComponentOpenClass.ThisField || member instanceof ComponentOpenClass.GetOpenClass || member instanceof TestSuiteMethod;
    }

    private static boolean isInvalidType(IOpenClass openClass, Map<IOpenClass, Boolean> invalidTypeMap) {
        Boolean v = invalidTypeMap.get(openClass);
        if (v != null) {
            return v;
        }
        invalidTypeMap.put(openClass, Boolean.FALSE);
        if (openClass.isArray()) {
            boolean isInvalidComponentType = InterfaceGenerator.isInvalidType(openClass.getComponentClass(), invalidTypeMap);
            invalidTypeMap.put(openClass, isInvalidComponentType);
            return isInvalidComponentType;
        }
        if (openClass instanceof DatatypeOpenClass) {
            if (openClass.getInstanceClass() == null) {
                invalidTypeMap.put(openClass, Boolean.TRUE);
                return true;
            }
            for (IOpenField openField : openClass.getFields()) {
                if (!InterfaceGenerator.isInvalidType(openField.getType(), invalidTypeMap)) continue;
                invalidTypeMap.put(openClass, Boolean.TRUE);
                return true;
            }
        }
        if (NullOpenClass.isAnyNull((IOpenClass[])new IOpenClass[]{openClass})) {
            invalidTypeMap.put(openClass, Boolean.TRUE);
            return true;
        }
        return false;
    }

    private static String getMethodTypes(RuleInfo ruleInfo) {
        Class<?> returnType = ruleInfo.getReturnType();
        Class<?>[] paramTypes = ruleInfo.getParamTypes();
        StringBuilder builder = new StringBuilder("(");
        for (Class<?> paramType : paramTypes) {
            builder.append(Type.getType(paramType));
        }
        builder.append(")");
        builder.append(Type.getType(returnType));
        return builder.toString();
    }

    private static Class<?>[] getInstanceClasses(IOpenClass[] openClasses) {
        ArrayList<Class> classes = new ArrayList<Class>();
        if (openClasses != null) {
            for (IOpenClass openClass : openClasses) {
                Class clazz = openClass.getInstanceClass();
                if (clazz == null) {
                    throw new IllegalStateException("Instance class cannot be null");
                }
                classes.add(clazz);
            }
        }
        return classes.toArray(new Class[0]);
    }
}

