/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions.style;

import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.AUndoableCellAction;
import org.openl.rules.table.ui.ICellStyle;

public class SetFillColorAction
extends AUndoableCellAction {
    private short[] prevColor;
    private final short[] newColor;

    public SetFillColorAction(int col, int row, short[] color, MetaInfoWriter metaInfoWriter) {
        super(col, row, metaInfoWriter);
        this.newColor = color;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        ICellStyle style = grid.getCell(this.getCol(), this.getRow()).getStyle();
        this.prevColor = style != null ? style.getFillForegroundColor() : null;
        grid.setCellFillColor(this.getCol(), this.getRow(), this.newColor);
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        grid.setCellFillColor(this.getCol(), this.getRow(), this.prevColor);
    }
}

