/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openl.OpenL;
import org.openl.binding.exception.DuplicatedFieldException;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.types.IOpenField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmOpenClass
extends ComponentOpenClass {
    private static final Logger LOG = LoggerFactory.getLogger(AlgorithmOpenClass.class);
    private final Set<String> invisibleFields = new HashSet<String>();

    public AlgorithmOpenClass(String name, OpenL openl) {
        super(name, openl);
    }

    public IOpenField getField(String fname) {
        if (!this.invisibleFields.contains(fname)) {
            return super.getField(fname);
        }
        return null;
    }

    public IOpenField getField(String fname, boolean strictMatch) {
        if (!this.invisibleFields.contains(fname)) {
            return super.getField(fname, strictMatch);
        }
        return null;
    }

    public Collection<IOpenField> getFields() {
        return this.filterFields(super.getFields());
    }

    public void addField(IOpenField field) {
        try {
            super.addField(field);
        }
        catch (DuplicatedFieldException e) {
            LOG.debug("Error occurred: ", (Throwable)e);
            throw new DuplicatedVarException("", e.getFieldName());
        }
    }

    private Collection<IOpenField> filterFields(Collection<IOpenField> fields) {
        ArrayList<IOpenField> visibleFields = new ArrayList<IOpenField>();
        for (IOpenField field : fields) {
            if (this.invisibleFields.contains(field.getName())) continue;
            visibleFields.add(field);
        }
        return visibleFields;
    }

    public Collection<IOpenField> getDeclaredFields() {
        return this.filterFields(super.getDeclaredFields());
    }

    public void setFieldToInvisibleState(String fname) {
        this.invisibleFields.add(fname);
    }

    public void setFieldToVisibleState(String fname) {
        this.invisibleFields.remove(fname);
    }

    public void allFieldsToVisible() {
        this.invisibleFields.clear();
    }
}

